include("scripts/events/ordertelephoneevent.lua")

-- set event
event = orderTelephoneEvent()

-- day class
class 'day3' (interface)

function day3:__init() super()
end

function day3:onLevelGlobals()

	-- set event configuration
	event.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"	-- appearance of the mailman
	event.pool = 										-- product pool
	{ 
		"COKE", 
		"COFFEE", 
		"MILKSHAKEBANANA",
		"WAFFLE_CHOCOLATESAUCE",
	}					
	event.chances = 									-- product chances
	{ 	
		60, 
		50,
		10,
		20,
	}						
	event.timeUntilRingMin = 90000						-- minimum time until the phone rings
	event.timeUntilRingMax = 95000						-- maximum time until the phone rings
	event.timeUntilNextOrder = 8000						-- interval at which the orders come
	event.timeUntilEnd = 150000					-- time allowed to make all products
	event.waitX = 40									-- position the mailman waits inside
	event.waitY = 16
	event.workX = 37									-- position emily will be to deliver the order
	event.workY = 16
	event.workTelephoneOffsetX = 4						-- position emily will be to answer the phone relative to it
	event.workTelephoneOffsetY = 0					
	event.numProductsPerOrder = 2						-- number of products ordered each order
	event.numOrders = 10								-- total number of orders
	event.workAnim = "IDLE"								-- animation played by mailman
	event.score = 40
	event.maxBalloonSize = 15
	event.sequenceRing =
	{
		{ "scene",		"qStartMovie" 									},
		{ "telephone", 	"qSayPortrait",		"RESTAURANT0_DAY3_0", "PORTRAIT_BOSS" 		},
		{ "emily", 		"qSay",				"RESTAURANT0_DAY3_1" 		},
		{ "telephone", 	"qSayPortrait",		"RESTAURANT0_DAY3_2", "PORTRAIT_BOSS_ANGRY" },
		{ "emily",		"qSetAppearance",	"BLUSH"						},
		{ "emily", 		"qSay",				"RESTAURANT0_DAY3_3" 		},
		{ "emily",		"qSetAppearance",	""							},
		{ "telephone", 	"qSayPortrait",		"RESTAURANT0_DAY3_4", "PORTRAIT_BOSS_ANGRY" },
		{ "telephone", 	"qSayPortrait",		"RESTAURANT0_DAY3_5", "PORTRAIT_BOSS" 		},
		{ "telephone", 	"qSayPortrait",		"RESTAURANT0_DAY3_6", "PORTRAIT_BOSS" 		},
		{ "mailman",	"qSetPosition",		"movieNode" 				},
		{ "mailman",	"qSetVisible",		true		 				},		
		{ "mailman",	"qWalkToXY",		"waitX", "waitY" 			},
		{ "mailman",	"qSay",				"RESTAURANT0_DAY3_10"		},
		{ "emily", 		"qSetAppearance",	"PANIC" 					},
		{ "emily", 		"qSay",				"RESTAURANT0_DAY3_11" 		},
		{ "emily", 		"qSetAppearance",	"NEUTRAL"					},
		{ "telephone", 	"qSayPortrait",		"RESTAURANT0_DAY3_12", "PORTRAIT_BOSS" 		},
		{ "mailman",	"qWait",			500 						},
		{ "scene",		"qFinishMovie" 									},
		{ "emily", 		"qSetAppearance",	""							},
		{ "scene",		"qNotify", 			"start ordering"			},
	}
	event.sequenceDone =
	{
		{ "scene",		"qStartMovie" },
		{ "emily",		"qNotify",			"win lose" 					},
	}
	event.sequenceWin =
	{
		{ "emily",		"qWorkOn",			"telephone" 				},	
		{ "emily",		"qAnimate",			"JUMP", 1					},
		{ "emily",		"qWait",			500							},
		{ "emily",		"qAnimate",			"IDLE", 0					},
		{ "emily", 		"qSay",				"RESTAURANT0_DAY3_21" 		},
		{ "mailman",	"qWalkToNode",		"movieNode" 				},
		{ "mailman",	"qDestroy",			"event.mailman"				},
		{ "telephone",	"qSayPortrait",		"RESTAURANT0_DAY3_22", "PORTRAIT_BOSS" 		},
		{ "telephone",	"qSayPortrait",		"RESTAURANT0_DAY3_23", "PORTRAIT_BOSS" 		},
		{ "telephone",	"qPlaySound",		"SOUND_PHONE_HANG_UP"		},
		{ "telephone",	"qSay",				"RESTAURANT0_DAY3_24" 		},
		{ "",			"qSequence",		"sequenceBetty" 			},
	}
	event.sequenceLose =
	{
		{ "telephone", 	"qSay",				"RESTAURANT0_DAY3_20"		},	
		{ "emily",		"qWorkOn",			"telephone" 				},		
		{ "emily",		"qSetAppearance",	"SAD"						},
		{ "emily", 		"qSay",				"RESTAURANT0_DAY3_40" 		},
		{ "emily",		"qSay",				"RESTAURANT0_DAY3_41" 		},
		{ "mailman",	"qWalkToXY",		20, 22 						},
		{ "mailman",	"qSay",				"RESTAURANT0_DAY3_42" 		},
		{ "emily",		"qSetAppearance",	""							},
		{ "telephone",	"qSayPortrait",		"RESTAURANT0_DAY3_43", "PORTRAIT_BOSS" 		},
		{ "telephone",	"qSayPortrait",		"RESTAURANT0_DAY3_23", "PORTRAIT_BOSS" 		},
		{ "telephone",	"qPlaySound",		"SOUND_PHONE_HANG_UP"		},
		{ "telephone",	"qSay",				"RESTAURANT0_DAY3_24" 		},
		{ "emily",		"qSetAppearance",	"HAPPY"						},
		{ "emily",		"qSay",				"RESTAURANT0_DAY3_44" 		},
		{ "emily",		"qSetAppearance",	""							},
		{ "mailman",	"qSay",				"RESTAURANT0_DAY3_45" 		},
		{ "mailman",	"qWalkToNode",		"movieNode" 				},
		{ "mailman",	"qDestroy",			"event.mailman"				},	
		{ "",			"qSequence",		"sequenceBetty" 			},
	}
	event.sequenceBetty =
	{
		{ "cleaner", 	"qWalkToXY",		21, 25	 					},
		{ "cleaner", 	"qSay",				"RESTAURANT0_DAY3_30" 		},
		{ "emily", 		"qSay",				"RESTAURANT0_DAY3_31" 		},
		{ "cleaner", 	"qSay",				"RESTAURANT0_DAY3_32" 		},
		{ "emily",		"qSetAppearance",	"HAPPY"						},
		{ "emily", 		"qSay",				"RESTAURANT0_DAY3_33" 		},
		{ "emily",		"qSetAppearance",	""							},
		{ "cleaner", 	"qSay",				"RESTAURANT0_DAY3_35" 		},
		{ "cleaner", 	"qSay",				"RESTAURANT0_DAY3_36" 		},
		{ "emily",		"qSetAppearance",	"HAPPY"						},
		{ "emily", 		"qSay",		 		"RESTAURANT0_DAY3_37" 		},
		{ "emily",		"qSetAppearance",	""							},
		{ "scene",		"qFinishMovie" 									},
		{ "cleaner",	"qWait",			1000 						},
	}

end


-- set day
day = day3()