include("scripts/events/brokenobjectevent.lua")

-- set event
event = brokenObjectEvent()
event.targetType = "Table4"
event.targetGridX = -1
event.targetGridY = -1

-- day class
class 'day4' (interface)

function day4:__init() super()
end

function day4:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- set initial positions
	cleaner:setPosition(cleaner:getHomeNode())
	
	-- set event configuration
	event.animFix = "FIX"
	event.soundFix = "SOUND_FIXTABLE_LOOP"
	event.sequenceStart = nil
	event.timeUntilFixed = 1000 * 100
	event.score = 300
	event.overheadY = 33
	event.pbY = 15	
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 											},
		{ "",				"parallel"  											},
		{ "cleaner",		"qWalkTo",					om:getTable(2)				},
		{ "cleaner",		"qAnimate",					"CLEAN_UP", 2				},
		{ "cleaner",		"qWait",					1000						},
		{ "cleaner",		"qWalkTo",					om:getTable(3)				},
		{ "cleaner",		"qAnimate",					"CLEAN_UP", 2				},
		{ "cleaner",		"qWait",					1000						},
		{ "cleaner",		"qWalkToXY",				15, 17						},
		{ "emily",			"qWait",					1000						},
		{ "emily",			"qWalkToXY",				20, 17						},		
		{ "emily",	 		"qSetAppearance",			"NEUTRAL"	 				},
		{ "",				"sequential" 											},
		{ "emily",	 		"qSetAppearance",			"SURPRISED" 				},
		{ "emily",	 		"qSay",						"RESTAURANT0_DAY4_0" 		},
		{ "emily",	 		"qSetAppearance",			"NEUTRAL"		 			},
		{ "cleaner", 		"qSay",						"RESTAURANT0_DAY4_1" 		},
		{ "cleaner",		"qSay",						"RESTAURANT0_DAY4_2" 		},
		{ "cleaner",		"qSay",						"RESTAURANT0_DAY4_3" 		},
		{ "emily",	 		"qSetAppearance",			"" 							},
		{ "emily",	 		"qSay",						"RESTAURANT0_DAY4_4" 		},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qStartGame" 											},
		{ "brokenObject",	"qCreateScreenOverhead",	"INGAME_ARROW"				},
	}	
	
end

-- set day
day = day4()