include("scripts/events/cameraevent.lua")

-- set event
event = cameraEvent()

-- day class
class 'day5' (interface)

function day5:__init() super()
end

function day5:onLevelGlobals()

	local sequence2 =
	{
		{ "camPerson",		"qSayTimed",		"RESTAURANT0_DAY5_20", 3000	},		
	}

	-- set event configuration
	event.baseName = "INGAME_PERSON_FRANCOIS"
	event.coordinates =
	{
		{ 40, 15, 36, 15 },
		{  9, 16, 13, 16, sequence2 },
		{  2, 27,  6, 27 },	
		{ 32, 32, 36, 32 },	
		{ 21, 26, 21, 30 },	
		{ 13, 32, 17, 32 },	
		{ 20, 16, 16, 16 },	
		{ 38, 16, 34, 16 },	
	}
	event.score = 500
	event.timerStart = 5 * 1000
	event.timerReturn = 8 * 1000
	event.scoreGotOne = 25
	event.scoreGotAll = 100
	event.sequenceStart =
	{
		{ "scene",			"qStartMovie" 									},
		{ "",				"parallel"										},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "camPerson",		"qSetAppearance",	"CAMERA"					},
		{ "camPerson",		"qSetPosition",		movieNode					},
		{ "camPerson",		"qWalkToXY",		25, 22						},
		{ "",				"sequential"									},
		{ "camPerson",		"qSay",				"RESTAURANT0_DAY5_0"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY5_1"		},
		{ "camPerson",		"qSay",				"RESTAURANT0_DAY5_2"		},
		{ "emily",			"qAnimate",			"LAUGH", -1, 8				},
		{ "emily",			"qWait",			750							},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "emily",			"qSay",				"RESTAURANT0_DAY5_3"		},		
		{ "camPerson",		"qSay",				"RESTAURANT0_DAY5_4"		},
		{ "camPerson",		"qSay",				"RESTAURANT0_DAY5_5"		},
		{ "emily",			"qSetAppearance",	"NEUTRAL"					},
		{ "emily",			"qSay",				"RESTAURANT0_DAY5_6"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "camPerson",		"qSay",				"RESTAURANT0_DAY5_7"		},
		{ "camPerson",		"qSay",				"RESTAURANT0_DAY5_8"		},		
		{ "scene", 			"qFinishMovie" 									},
	}
	event.sequenceTooLate =
	{
		{ "camPerson",		"qSayTimed",		"RESTAURANT0_DAY5_9", 3000	},		
	}
	event.sequenceCompleted =
	{
		{ "scene",			"qStartMovie" 									},
		{ "camPerson",		"qSay",				"RESTAURANT0_DAY5_10"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY5_11"		},
		{ "camPerson",		"qSay",				"RESTAURANT0_DAY5_12"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY5_13"		},
		{ "scene", 			"qFinishMovie" 									},
		{ "camPerson",		"qWalkToNode",		entryNode					},
		{ "camPerson",		"qDestroy",										},
	}
	
end

function day5:onNotify(notification)

	if (notification == "camera start") then
		
		event.camPerson:animate("TAKEPICTURE", 1)
			
		emily:animate("POSE", 1)
		event.camPerson:playSound("SOUND_TIP_POPS_IN_AIR","sound")
	
	elseif (notification == "camera complete") then
	
	
	end

end

-- set day
day = day5()