include("scripts/events/droppedobjectevent.lua")

-- set event
event = droppedObjectEvent()

-- day class
class 'day6' (interface)

function day6:__init() super()
end

function day6:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- set initial positions
	cleaner:setPosition(entryNode)
	cleaner:setAppearance("LOVE")
	entertainer:setPosition(entryNode)
	emily:setPosition(grid:getCounterNode())
	
	-- set event configuration
	event.hookType = "TableTask"
	event.person = cleaner	
	event.timeUntilDropMin = 200
	event.timeUntilDropMax = 800
	event.timeUntilDropInt = 300
	event.dropChance = 90
	event.dropIgnore = 2	
	event.preset = "global_cloth.d2p"	
	event.hintId = HINT_CLOTH
	event.areas = 
	{
		{ 7, 11, 14, 22 },
		{ 17, 11, 36, 18 },
	}	
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "cleaner",		"qSetPosition",		movieNode					},
		{ "cleaner",		"qWalkToXY",		32, 17						},
		{ "cleaner", 		"qSay",				"RESTAURANT0_DAY6_0" 		},
		{ "emily",	 		"qSay",				"RESTAURANT0_DAY6_1" 		},
		{ "entertainer",	"qSetPosition",		movieNode					},
		{ "entertainer",	"qWait",			500							},
		{ "entertainer",	"qWalkToXY",		36, 15						},
		{ "entertainer",	"qAnimate",			"ENTERTAIN", -1				},
		{ "entertainer",	"qWait",			2000						},
		{ "entertainer",	"qAnimate",			"IDLE", 0					},
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY6_2" 		},
		{ "entertainer",	"qSay",				"RESTAURANT0_DAY6_3" 		},
		{ "cleaner",	 	"qSay",				"RESTAURANT0_DAY6_4" 		},
		{ "emily",			"qSetAppearance",	"BLUSH"						},
		{ "emily",			"qWait",			200							},
		{ "emily",	 		"qSay",				"RESTAURANT0_DAY6_5" 		},
		{ "emily",			"qSetAppearance",	""							},
		{ "cleaner",		"qWalkToNode",		cleaner:getHomeNode()		},
		{ "emily",			"qWalkToXY",		32, 17						},
		{ "emily",	 		"qSay",				"RESTAURANT0_DAY6_6" 		},
		{ "entertainer",	"qWalkToXY",		36, 17						},
		{ "entertainer",	"qSay",				"RESTAURANT0_DAY6_7" 		},
		{ "emily",	 		"qSay",				"RESTAURANT0_DAY6_8" 		},
		{ "scene", 			"qFinishMovie" 									},
		{ "scene", 			"qStartGame" 									},		
	}
	event.sequenceDroppedFirst = 
	{
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY6_9" 		},
		{ "cleaner",		"qWait",			100								},
		{ "cleaner",		"qAnimate",			"SHRUG", 1						},
		{ "cleaner",		"qWait",			500								},
	}	
	event.sequenceDropped = 
	{
		{ "cleaner",		"qWait",			300								},
		{ "cleaner",		"qAnimate",			"SHRUG", 1						},
		{ "cleaner",		"qWait",			500								},
	}
	
end

-- set day
day = day6()