include("scripts/events/heimlichevent.lua")

-- set event
event = heimlichEvent()

-- day class
class 'day7' (interface)

function day7:__init() super()
end

function day7:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- set initial positions
	cleaner:setPosition(cleaner:getHomeNode())
	entertainer:setPosition(entertainer:getHomeNode())
	emily:setPosition(grid:getNode(18, 17))
	
	-- set event configuration
	event.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"
	event.neededToSave = 6
	event.saveClickMin = 0.30
	event.saveClickMax = 0.70
	event.speedMin = 1.0
	event.speedMax = 2.0
	event.score = 500
	event.sequenceStart =
	{
		{ "scene",			"qStartMovie" 									},
		{ "choker",			"qSetPosition",		"movieNode"					},	
		{ "choker",			"qWalkToXY",		22, 17						},
		{ "choker",			"qSay",				"RESTAURANT0_DAY7_0"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY7_1"		},
		{ "choker",			"qCreateOverhead",	"INGAME_THINK_ICON"			},
		{ "choker",			"qWait",			2000						},
		{ "choker",			"qRemoveOverhead"								},
		{ "choker",			"qSay",				"RESTAURANT0_DAY7_2"		},
		{ "choker",			"qSay",				"RESTAURANT0_DAY7_3"		},
		{ "scene",			"qNotify",			"make product"				},
	}
	event.sequenceMake =
	{
		{ "emily",			"qWalkToProduct",	getProduct("WAFFLE")		},
		{ "emily",			"qAnimate",			"WORK", -1					},
		{ "emily",			"qWait",			800							},
		{ "emily",			"qWalkToXY",		18, 17						},	
		{ "scene",			"qNotify",			"hand over product"			},
	}
	event.sequenceChoke =
	{
		{ "choker",			"qAnimate",			"EAT_WAFFLE", -1, 5			},
		{ "emily",			"qWait",			2000						},
		{ "emily",			"qAnimate",			"LAUGH", -1, 8				},
		{ "emily",			"qSay",				"RESTAURANT0_DAY7_4"		},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "emily",			"qSetAppearance",	"HAPPY"						},
		{ "choker",			"qWait",			200							},
		{ "choker",			"qPlaySound",		"SOUND_CHOKE"				},
		{ "choker",			"qAnimate",			"CHOKE_LOOP", 1, 5			},
		{ "choker",			"qWait",			400							},
		{ "choker",			"qCreateOverhead",	"INGAME_EMPTY_PLATES_SIGN"	},
		{ "choker",			"qPlaySound",		"SOUND_EVENT_ATTENTION"		},
		{ "choker",			"qWait",			500							},
		{ "choker",			"qRemoveOverhead"								},
		{ "emily",			"qSetAppearance",	"PANIC"						},
		{ "choker",			"qSay",				"RESTAURANT0_DAY7_5"		},
		{ "choker",			"qAnimate",			"CHOKE_LOOP", -1, 5			},
		{ "emily",			"qSay",				"RESTAURANT0_DAY7_6"		},
		{ "emily",			"qSetAppearance",	"NEUTRAL"					},		
		{ "emily",			"qSay",				"RESTAURANT0_DAY7_7"		},
		{ "scene", 			"qFinishMovie" 									},
		{ "scene", 			"qStartGame" 									},		
		{ "emily",			"qSetAppearance",	""							},
		{ "choker",			"qCreateOverhead",	"INGAME_ARROW"				},
	}
	event.sequenceSaved =
	{
		{ "scene",			"qStartMovie" 									},
		{ "choker",			"qSay",				"RESTAURANT0_DAY7_8"		},
		{ "emily",			"qWalkToXY",		18, 17						},	
		{ "emily",			"qSay",				"RESTAURANT0_DAY7_9"		},
		{ "scene", 			"qFinishMovie" 									},
		{ "choker",			"qWalkToNode",		"exitNode"					},
		{ "choker",			"qDestroy",										},
	}
	event.sequenceFailed =
	{
		{ "scene",			"qStartMovie" 									},
		{ "choker",			"qAnimate",			"CHOKE_LOOP", 0				},
		{ "emily",			"qWalkToXY",		18, 17						},	
		{ "choker",			"qAnimate",			"SPIT", 1, true, -1			},
		{ "choker",			"qSay",				"RESTAURANT0_DAY7_10"		},
		{ "choker",			"qSay",				"RESTAURANT0_DAY7_11"		},
		{ "choker",			"qWalkToNode",		"movieNode"					},
		{ "choker",			"qDestroy",			"event.choker"				},
		{ "scene", 			"qFinishMovie" 									},
		{ "",				"sequential"									},
		{ "",				"parallel"										},
		{ "pm",				"qAllPeopleWalkOut"								},
	}
	
end

function day7:onLevelInited()
end

function day7:onNotify(notification)

	if (notification == "make product") then
		qSequence(event.sequenceMake)
	
	end
	
	if (notification == "hand over product") then
		qSequence(event.sequenceChoke)
	
	end
	
end

-- set day
day = day7()