-- day class
class 'day8' (interface)

-- configuration variables
day8.tiredTimes = { 60 * 1000,		-- 1 minute(s) after starting the event
					120 * 1000,		-- 2 minute(s) after starting the event
					180 * 1000,		-- 3 minute(s) after starting the event
				  }
day8.sequenceStart = nil

-- internal variables
-- don't change unless you know what you're doing
day8.timerNext = 0
day8.timerTired = 0
day8.timerStart = 40 * 1000
day8.index = 1
day8.emilyWalkTimePerNode = 0
day8.tiredWalkTimePerNode = 0
day8.hyperWalkTimePerNode = 0
day8.started = false
day8.first = true

function day8:__init() super()
end

function day8:onLevelGlobals()

	-- hide chocolates
	om:getChocolates():setVisible(false)
	om:getChocolates():getHighlight():setActive(false)

	self.sequenceStart =
	{
		{ "scene",			"qStartMovie" 									},
		{ "",				"parallel"										},
		{ "cleaner",		"qWalkToXY",		25, 22						},
		{ "emily",			"qWalkToXY",		29, 25						},		
		{ "",				"sequential"									},
		{ "cleaner",		"qWait",			300							},
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY8_0"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY8_1"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY8_2"	},
		{ "cleaner",		"qNotify",			"show chocolates"			},
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY8_3"	},
		{ "emily",			"qWait",			500							},
		{ "emily",			"qWalkToXY",		25, 25						},
		{ "emily",			"qWait",			500							},
		{ "emily",			"qWalkToXY",		29, 25						},
		{ "emily",			"qWait",			500							},
		{ "emily",			"qRemoveOverhead"								},
		{ "emily",			"qSetAppearance",	""							},
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY8_4"	},
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY8_5"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY8_6"	},
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY8_7"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY8_8"	},
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY8_9"	},
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY8_10"	},
		{ "scene",			"qNotify",			"start"						},
		{ "scene", 			"qFinishMovie" 									},
		{ "cleaner",		"qWait",			200							},
	}
	
	-- initialize values
	self.emilyWalkTimePerNode = emily:getWalkTimePerNode()
	self.tiredWalkTimePerNode = emily:getWalkTimePerNode() * 2
	self.hyperWalkTimePerNode = emily:getWalkTimePerNode() / 2
	
	-- emily walks slow per default
	emily:setWalkTimePerNode(self.tiredWalkTimePerNode)
	emily:setAppearance("SLEEPY")
	emily:createOverhead("INGAME_SLEEP_ICON")
	
end

function day8:onLevelInited()
end

function day8:onNotify(notification)

	if (notification == "show chocolates") then
		om:getChocolates():setVisible(true)
		om:getChocolates():getHighlight():setActive(true)
		
	elseif (notification == "start") then
		self.started = true
	
	end

end

function day8:onTick(time)

	if (self.timerStart > 0) then
		self.timerStart = self.timerStart - time
		if (self.timerStart <= 0) then
			qSequence(self.sequenceStart)
		
			self.timerNext = self.tiredTimes[self.index]
		end	
	end
	
	if (self.started == true) then
		if (self.timerTired > 0) then
		
			local etpn = emily:getWalkTimePerNode()		
		
			if (etpn == self.tiredWalkTimePerNode) then
				self.timerTired = self.timerTired - time
				if (self.timerTired <= 0) then
					-- reset speed
					emily:setWalkTimePerNode(self.emilyWalkTimePerNode)
					emily:setAppearance("")
					emily:clearOverhead()
					self.timerTired = 0
					
				end
				
			elseif (etpn == self.emilyWalkTimePerNode) then
				-- used chocolates
				emily:clearOverhead()
				self.timerTired = 0
				
			elseif (etpn == self.hyperWalkTimePerNode) then
				-- used chocolates (x2?)
				emily:clearOverhead()
				self.timerTired = 0
				
			end
		end	
	
		if (self.timerNext > 0) then
			self.timerNext = self.timerNext - time
			if (self.timerNext <= 0) then
				
				local etpn = emily:getWalkTimePerNode()				
				
				-- change walk speed
				if (etpn == self.emilyWalkTimePerNode) then
					-- currently normal
					-- make tired
					emily:setWalkTimePerNode(self.tiredWalkTimePerNode)
					emily:setAppearance("SLEEPY")
					emily:createOverhead("INGAME_SLEEP_ICON")				
					
					self.timerTired = 20 * 1000
					-- cout("Day8 - Emily now tired\n")
					
					if (self.first == true) then
						if (om:getChocolates():isAvailable()) then
							om:getChocolates():createOverhead("INGAME_ARROW")
							self.first = false
							
						end					
					end
				
				elseif (etpn == self.hyperWalkTimePerNode) then
					-- already double
					-- ignore
				
				elseif (etpn == self.tiredWalkTimePerNode) then
					-- already slow
					-- this shouldn't happen!
					-- ignore
					warn("Day8 - emily is already tired; ignoring...")
				
				end		
				
				-- set next timer
				self.index = self.index + 1
				if (self.tiredTimes[self.index] ~= nil) then
					self.timerNext = self.tiredTimes[self.index] - self.tiredTimes[self.index-1]
				end
			end	
		end
		
	end
	
end


-- set day
day = day8()