include("scripts/events/findevent.lua")

-- set event
event = findEvent()
event.objectTypes = { "Tool" }

-- day class
class 'day9' (interface)

day9.carpet = nil
day9.carpetType = "Doormat"
day9.carpetPerson = nil

function day9:__init() super()
end

function day9:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- set initial positions
	cleaner:setPosition(grid:getNode(21, 25))
	cleaner:animate("IDLE_BACK", 0)
	entertainer:setPosition(entertainer:getHomeNode())
	emily:setPosition(grid:getCounterNode())

	-- set event configuration
	event.baseName = "INGAME_PERSON_SPECIAL_MECHANIC"
	event.scoreGotOne = 50
	event.scoreGotAll = 100
	event.timeUntilEnterMin = 14000
	event.timeUntilEnterMax = 28000
	event.entryX = 0
	event.entryY = 3
	event.waitX = 40
	event.waitY = 16
	event.sequenceStart =
	{
		{ "scene",			"qStartMovie" 									},
		{ "cleaner",		"qWait",			2000						},
		{ "cleaner",		"qWalkToLeftOf",	emily						},
		{ "cleaner",		"qWait",			500							},
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY9_0"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY9_1"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY9_2"		},
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY9_3"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY9_4"		},
		{ "cleaner",		"qWalkToNode",		cleaner:getHomeNode()		},
		{ "scene", 			"qFinishMovie" 									},
		{ "scene", 			"qStartGame" 									},			
	}
	event.sequenceFirst = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "findPerson",		"qSay",				"RESTAURANT0_DAY9_5"		},
		{ "cleaner",		"qWalkToLeftOf",	"findPerson"				},
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY9_6"		},
		{ "findPerson",		"qSay",				"RESTAURANT0_DAY9_7"		},
		{ "findPerson",		"qSay",				"RESTAURANT0_DAY9_8"		},
		{ "findPerson",		"qSay",				"RESTAURANT0_DAY9_9"		},
		{ "cleaner",		"qWalkToXY",		32, 16						},
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY9_10"		},
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY9_11"		},
		{ "scene", 			"qFinishMovie" 									},
		{ "carpet",			"qWait",			1000						},
		{ "carpet",			"qCreateOverhead",	"INGAME_EMPTY_PLATES_SIGN"	},
		{ "carpet",			"qPlaySound",		"SOUND_EVENT_ATTENTION"		},		
	}
	event.sequenceCompleted = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "findPerson",		"qAnimate",			"IDLE", -1					},
		{ "findPerson",		"qWalkToXY",		"waitX", "waitY"			},
		{ "findPerson",		"qSay",				"RESTAURANT0_DAY9_12"		},
		{ "cleaner",		"qWalkToNode",		cleaner:getHomeNode()		},
		{ "entertainer",	"qWalkToNode",		entertainer:getHomeNode()	},
		{ "emily",			"qWalkToXY",		16, 34						},
		{ "emily",			"qSay",				"RESTAURANT0_DAY9_13"		},
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY9_14"		},
		{ "cleaner",		"qSetAppearance",	"LOVE"						},		
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY9_15"		},
		{ "entertainer",	"qAnimate",			"ENTERTAIN", -1				},
		{ "entertainer",	"qWait",			1000						},
		{ "entertainer",	"qAnimate",			"IDLE", 0					},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "emily",			"qWalkToXY",		23, 17						},
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY9_16"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY9_17"		},
		{ "cleaner",		"qWalkToXY",		20, 17						},
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY9_18"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY9_19"		},
		{ "cleaner",		"qSetAppearance",	"SAD"						},
		{ "cleaner",		"qSay",				"RESTAURANT0_DAY9_20"		},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "cleaner",		"qSetReturnHome",	false						},
		{ "emily",			"qSay",				"RESTAURANT0_DAY9_21"		},
		{ "emily",			"qWalkToNode",		movieNode					},
		{ "emily",			"qDestroy"										},
		{ "findPerson",		"qWalkToNode",		movieNode					},
		{ "findPerson",		"qDestroy"										},
		{ "entertainer",	"qWalkToXY",		17, 17						},
		{ "scene", 			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}	
	
end

function day9:onLevelInited()

	-- link person from find event to carpet
	-- to become the person that makes it dirty
	self.carpetPerson = event.findPerson

end

function day9:createObject(desc)

	result = nil
	
	if (self.carpet == nil) then
		if (desc:getType() == self.carpetType) then
			result = carpetObject()
			result.event = self		
			result:setType("carpetObject")

			-- store
			self.carpet = result
			-- hacky global variable
			carpet = result
		end
	end
	
	return result

end

function day9:onLockToNode(actor, node)

	if (self.carpet and self.carpetPerson) then
		if (self.carpet:isInside(node:getGridX(), node:getGridY())) then
			if (actor:getTag() == 0) then
				-- entering carpet
				actor:setTag(1)
				
				-- customers
				if (actor:getType() == "customer") then
					if (actor:getCustomerGroup():getTag() == 0) then
						if (self.carpet.dirty) then
							actor:getCustomerGroup():changeMood(-1)
						
						end
					end
					
					actor:getCustomerGroup():setTag(actor:getCustomerGroup():getTag() + 1)
					
				end
			end
		else
			if (actor:getTag() == 1) then
				-- leaving carpet
				actor:setTag(0)
				
				-- customers
				if (actor:getType() == "customer") then
					actor:getCustomerGroup():setTag(actor:getCustomerGroup():getTag() - 1)
					
					if (actor:getCustomerGroup():getTag() == 0) then
					
					end
				end
				
				-- dirty
				if (actor:getType() == self.carpetPerson:getType()) then
					if (self.carpet.dirty == false and self.carpet.dirtyable == true) then
						self.carpet.dirty = true
						self.carpet.count = self.carpet.count + 1
						self.carpet:animate(self.carpet:getBaseName() .. "_DIRTY", 0)
						self.carpet:createHighlight()
						
						if (self.carpet.count > 1) then
							self.carpet:playSound("SOUND_EVENT_ATTENTION")
							self.carpet:createOverhead("INGAME_EMPTY_PLATES_SIGN")
							
						end						
					end					
				end				
			end
		end
	end
end

function day9:onDayEnd()

	-- carpet no longer becomes dirty
	self.carpet.dirtyable = false

	-- prevent walking out
	autoAllPeopleWalkOut = false
		
	-- play completed sequence
	qSequence(event.sequenceCompleted)
	    
end

-- set day
day = day9()

-- a carpet object
class 'carpetObject' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
carpetObject.event = nil
carpetObject.dirty = false
carpetObject.dirtyable = true
carpetObject.count = 0

function carpetObject:__init() super()
end

function carpetObject:onCreate()

	self:animate(self:getBaseName(), 0)

end

function carpetObject:onClick()

	if (self.dirty) then
		self:playSound("SOUND_OBJECT_CLICK")	
		if (self:isSelected() == false) then
			self:setSelected(true)
			cleaner:qWorkOn(self)
		
		end
	end

end

function carpetObject:onWorkStart(task)

	self.dirtyable = false
	self:setSelected(false)
	task:setDuration(3000)
	task:getPerson():animate("CLEAN", -1)
	return true

end

function carpetObject:onWorkComplete(task)

	self.dirtyable = true
	self.dirty = false
	self:animate(self:getBaseName(), 0)
	self:removeHighlight()
	self:removeOverhead()

end

function carpetObject:isInside(gridX, gridY)

	local gx = gridX - self:getPosition():getGridX()
	local gy = gridY - self:getPosition():getGridY()
	local gw = self:getWidth() / GRID_SPACING_X
	local gh = self:getHeight() / GRID_SPACING_Y
	
	if (gx < 0) then
		return false
	end
	
	if (gx >= gw) then
		return false
	end
	
	if (gy < 0) then
		return false
	end
	
	if (gy >= gh) then
		return false
	end
	
	return true

end

function carpetObject:getWorkNode()
	
	return grid:getNode(36, 12)

end
