include("scripts/products/regularproduct.lua")
include("scripts/appliances/churnerappliance.lua")
include("scripts/appliances/fruittreeappliance.lua")
include("scripts/appliances/cow.lua")
include("scripts/products/cakemoldproduct.lua")
include("scripts/products/cakemoldpieproduct.lua")
include("scripts/products/pieproduct.lua")
include("scripts/products/jamproduct.lua")
include("scripts/products/eggproduct.lua")
include("scripts/products/fruitproduct.lua")
include("scripts/products/treefruitproduct.lua")
include("scripts/persons/chicken.lua")


-- global variables and behavior we might need in a specific restaurant

-- entry node
entryX = 32
entryY = 0
entryNode = nil

-- exit node
exitX = 32
exitY = 0
exitNode =  nil

-- movie node
movieX = 32
movieY = 0
movieNode = nil

-- restaurant class
class 'restaurant1' (interface)

function restaurant1:__init() super()
end

function restaurant1:onLevelGlobals()

	if (player:getCurrentDayIndex() ~= 0) then
		chicken = pm:createPerson("chicken")
		chicken:setPosition(entryNode)
		if (chicken.points ~= nil) then
			if (table.getn(chicken.points) > 0) then
				index = 1 + getRandom(table.getn(chicken.points))
				startX = chicken.points[index][1]
				startY = chicken.points[index][2]
				chicken:setPosition(grid:getNode(startX, startY))			
	
			end	
		end
	end
	
	local table = nil
	for tableIdx = 1, 6 do
		table = om:getTable(tableIdx)
		if (table ~= nil) then
			table:setOverheadY( table:getOverheadY() - 85 )
			
		end

	end
	
	if getProduct("APPLEPIE") then
		local oven = getAppliance("rest1_oven")
		oven:animate("APP_OVEN_ACTIVE", -1, 5)
	end
	
	if getProduct("JAM") then
		local oven = getAppliance("rest1_jam_maker")
		oven:animate("APP_JAM_STOVE_ACTIVE", 0)
	end

end

function restaurant1:onLevelInited()
end

function restaurant1:createPerson(class)

	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_TASHI")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	

	elseif (class == "chicken") then
		c = chickenPerson("INGAME_PERSON_CHICKEN")
		c:setType("chicken")
		c:animate("IDLE", 0)
		return c
					
	elseif (class == "charles") then
		c = npc("INGAME_PERSON_CHARLES")
		c:setType("charles")
		c:animate("IDLE", 0)
		c:setButtX(20)
		return c	
		
	end
	
	return nil

end

function restaurant1:createProduct(base)

	bubbleJamAppleX = 544
	bubbleJamAppleY = 410
	bubbleJamCherryX = 619
	bubbleJamCherryY = 410
	bubbleJamS = true
	
	if (type(base) == "string")	then
	
		if (base == "EGG") then
			p = eggProduct(base)
			p:setWorkTime(400)
			p:setWorkAnimation("FIX")
			p:setWorkSound("SOUND_PICK_TEA_GARDEN")
			return p
		
		elseif (base == "MILK") then
			p = regularProduct(base)	-- regularProduct
			p:setVisible(false)
			p:setClickable(false)
			p:setWorkTime(50)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_GENERAL")
			return p
		
		elseif (base == "BUTTERMILK") then
			p = regularProduct(base)
			p:setVisible(false)
			p:setClickable(false)
			p:setWorkTime(50)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_GENERAL")
			return p
		
		elseif (base == "BUTTER") then
			p = regularProduct(base)
			p:setVisible(false)
			p:setClickable(false)
			p:setWorkTime(50)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_GENERAL")
			return p
			
		elseif (base == "LEMONADE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_POUR_FLUID")
			return p
			
		elseif (base == "BREADSLICES") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_SLICE_FRENCH_BREAD")
			return p
			
		elseif (base == "BREAD") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_SLICE_FRENCH_BREAD")
			return p
		
		elseif (base == "CORN") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_CHICKEN_CORN")
			return p
			
		elseif (base == "APPLE") then
			p = fruitProduct(base)
			p:setBubbleX(bubbleJamAppleX)
			p:setBubbleY(bubbleJamAppleY)
			p:setBubbleSmall(bubbleJamS)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_PICK_TEA_GARDEN")
			p:setStock(2)
			p:setMaxStock(12)
			return p
			
		elseif (base == "CHERRY") then
			p = fruitProduct(base)
			p:setBubbleX(bubbleJamCherryX)
			p:setBubbleY(bubbleJamCherryY)
			p:setBubbleSmall(bubbleJamS)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_PICK_TEA_GARDEN")
			p:setStock(2)
			p:setMaxStock(12)
			return p
		
		elseif (base == "JAM") then
			p = jamProduct(base)
			p:setBubbleX(bubbleJamAppleX)
			p:setBubbleY(bubbleJamAppleY)
			p:setBubbleSmall(bubbleJamS)
			p:setWorkTime(0)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_PUT_SHRIMP_IN_RICE")
			return p
			
		elseif (base == "CAKEMOLD") then
			p = cakemoldProduct(base)
			p:setBubbleX(bubbleJamAppleX)
			p:setBubbleY(bubbleJamAppleY)
			p:setBubbleSmall(bubbleJamS)
			p:setWorkTime(0)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_USE_SLICER_LOOP")
			p:setVisibleOnTray(false)
			return p
			
		elseif (base == "CAKEMOLD_APPLE") then
			p = cakemoldPieProduct(base)
			p:setBubbleTarget("rest1_oven")
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			return p
			
		elseif (base == "CAKEMOLD_CHERRY") then
			p = cakemoldPieProduct(base)
			p:setBubbleTarget("rest1_oven")
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			return p		
		
		elseif (base == "APPLEPIE") then
			p = pieProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkOffsetX(-2)
			p:setWorkSound("SOUND_GRAB_GENERAL")
			p:setStock(4)
			p:setMaxStock(4)
			p:setStockCounterX(36)
			p:setStockCounterY(-8)
			p:animate("PROD_BUT_APPLEPIE_4", 0)
			return p

		elseif (base == "CHERRYPIE") then
			p = pieProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkOffsetX(2)
			p:setWorkSound("SOUND_GRAB_GENERAL")			
			p:setStock(4)
			p:setMaxStock(4)
			p:setStockCounterX(36)
			p:setStockCounterY(-8)
			p:animate("PROD_BUT_CHERRYPIE_4", 0)
			return p
			
		elseif (string.find(base, "APPLE_")) then
			p = treeFruitProduct(base)
			p:setBasketProductName("APPLE")
			p:setAnchorPointType(CENTER)
			p:setVisible(false)
			p:setClickable(false)
			p:setWorkTime(50)
			p:setWorkAnimation("WORK")
	
			return p

		elseif (string.find(base, "CHERRY_")) then
			p = treeFruitProduct(base)
			p:setBasketProductName("CHERRY")
			p:setAnchorPointType(CENTER)
			p:setVisible(false)
			p:setClickable(false)
			p:setWorkTime(50)
			p:setWorkAnimation("WORK")
			return p
			
		end
		
	elseif (type(base) == "userdata") then
		--
		-- attempting to create a copy!
		if (base:getBase() == "CAKEMOLD_APPLE") then
			p = cakemoldPieProduct(base)
			return p
		
		elseif (base:getBase() == "CAKEMOLD_CHERRY") then
			p = cakemoldPieProduct(base)
			return p
			
		elseif (string.find(base:getBase(), "APPLE_")) or (string.find(base:getBase(), "CHERRY_")) then
			p = treeFruitProduct(base)
			return p
		
		end
	
	end
		
	return nil
	
end

function restaurant1:createObject(desc)

	if (desc:getType() == "Churner") then
		result = churnerAppliance()
		result:createHighlight()
		result:setType(desc:getType())
		return result
		
	elseif (desc:getType() == "AppleTree") then
		result = fruitTreeAppliance()
		result:createHighlight()
		result:setType(desc:getType())
		result:setMaxFruitAmount(3)
		result:setFruitProductBaseName("APPLE_")
		return result
		
	elseif (desc:getType() == "CherryTree") then
		result = fruitTreeAppliance()
		result:createHighlight()
		result:setType(desc:getType())
		result:setMaxFruitAmount(4)
		result:setFruitProductBaseName("CHERRY_")
		return result
		
	elseif (desc:getType() == "Cow") then
		result = cow()
		result:createHighlight()
		result:setType(desc:getType())
		return result
	
	end
	
	return nil
end

-- Needed for Trophy 'Break an egg':
function restaurant1:onDayBegin()
	if (player:getCurrentDayIndex() ~= 0) then
		tm:setLevelHasEggs(true)					
	end
end


-- set restaurant
restaurant = restaurant1()