-- set event

-- day class
class 'day0' (interface)

day0.tutorial = false

function day0:__init() super()
end

function day0:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.mo = pm:createPerson("npc")
	self.mo:setPosition(grid:getNode(32,2))
	self.mo:setBaseName("INGAME_PERSON_SPECIAL_MECHANIC")
	self.mo:setName("MO")
	self.mo:setVisible(false)
	
	francois = pm:createPerson("francois")
	francois:setPosition(grid:getNode(35,0))
	francois:setName("FRANCOIS")
	francois:setVisible(false)
	
	self.firstCust = pm:createPerson("fakecustomer")
	self.firstCust:setPosition(grid:getNode(32,1))
	self.firstCust:setBaseName("INGAME_CUSTOMER_FEMALE_ELDERLY")
	self.firstCust:setWalkTimePerNode(70)
	self.firstCust:setName("FIRSTCUST")
	
	emily:setPosition(grid:getNode(33,2))
	emily:setVisible(false)

	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "",				"parallel"										},
		{ "mo",				"qSetVisible",		true						},
		{ "mo",				"qWalkToXY",		29,	16						},
		{ "emily",			"qSetVisible",		true						},
		{ "emily",			"qWait",			300							},
		{ "emily",			"qWalkToXY",		33,	16						},
		{ "francois",		"qSetVisible",		true						},
		{ "francois",		"qWait",			300							},
		{ "francois",		"qWalkToXY",		22,	13						},
		{ "",				"sequential"									},
		{ "mo",				"qSay",				"RESTAURANT1_DAY0_0"		},
		{ "francois",		"qAnimate",			"STEP_IN_DIRT", 1, false, 8, true },
		{ "francois",		"qWait",			3600						},
		{ "francois",		"qSetAppearance",	"DIRTY_SHOE"				},
		{ "francois",		"qAnimate",			"IDLE", 0					},
		{ "emily",			"qSay",				"RESTAURANT1_DAY0_1"		},
		{ "francois",		"qSetAppearance",	""							},
		{ "mo",				"qSay",				"RESTAURANT1_DAY0_2"		},
		{ "mo",				"qSay",				"RESTAURANT1_DAY0_3"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY0_4"		},
		{ "emily", 			"qWalkToXY", 		10, 16						},
		{ "mo",				"qSay",				"RESTAURANT1_DAY0_5"		},
		{ "mo",				"qWalkToXY",		32, 13						},
		{ "mo",				"qWalkToXY",		32, 0						},
		{ "mo",				"qDestroy",			"day.mo"					},
		{ "emily",			"qAnimate",			"HAMMER_RIGHT", -1			},
		{ "emily",			"qWait",			1500						},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "francois",		"qSay",				"RESTAURANT1_DAY0_X1"		},
		{ "francois",		"qWalkToXY",		32, 13						},
		{ "francois",		"qWalkToXY",		32, 0						},
		{ "francois",		"qDestroy",			"francois"					},
		{ "emily",			"qWalkToXY",		43, 22						},
		{ "emily",			"qAnimate",			"CLEAN", -1					},
		{ "emily",			"qWait",			1500						},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "scene",			"qFadeToBlack"	 								},
		{ "scene",			"qWait", 			1000						},
		{ "emily",			"qSetPosition",		grid:getNode(10,16)			},
		{ "emily",			"qAnimate",			"HAMMER_RIGHT", -1			},
		{ "scene",			"qWait", 			500							},
		{ "scene",			"qFadeOutBlack"	 								},
		{ "",				"parallel"										},
		{ "emily",			"qWait",			750							},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "firstCust",		"qWalkToXY",		21,	29						},
		{ "",				"sequential"									},
		{ "firstCust",		"qSay",				"RESTAURANT1_DAY0_6"		},
		{ "emily",			"qWalkToCounter"								},
		{ "emily",			"qSay",				"RESTAURANT1_DAY0_7"		},
		{ "firstCust",		"qSay",				"RESTAURANT1_DAY0_8"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY0_9"		},
		{ "firstCust",		"qSetAppearance",	"HAPPY"						},
		{ "firstCust",		"qSay",				"RESTAURANT1_DAY0_10"		},
		{ "",				"qSequence",		"orderHandled"				}
	}
	
	event.orderHandled = 
	{
		{ "firstCust",		"qWait",			500							},
		{ "firstCust",		"qSay",				"RESTAURANT1_DAY0_11"		},
		{ "firstCust",		"qSay",				"RESTAURANT1_DAY0_12"		},
		{ "firstCust",		"qWalkToXY",		32, 13						},
		{ "firstCust",		"qWalkToXY",		32, 0						},
		{ "firstCust",		"qWalkToXY",		29, 0						},
		{ "firstCust",		"qDestroy",			"day.firstCust"				},
		{ "scene", 			"qFinishMovie" 									},
		{ "scene", 			"qStartGame" 									}
		
	}
	
end

function day0:onLevelInited()

	qSequence(self.sequenceStart)

end

function day0:onDayBegin()
end

function day0:onNotify(notification)

	if (notification == "create order") then
		self.order = createOrder()
		
		-- calculate order position
		x = -self.firstCust:getAnchorX() + self.firstCust:getWidth() / 2
		y = -self.firstCust:getAnchorY()
		
		-- place order
		self.order:setX(x)
		self.order:setY(y)
		self.order:setAnchorPointType(BOTTOMCENTER)		
		self.firstCust:addChild(self.order)
		self.order:addProduct("BREAD")
		
		self.customerState = "ORDERED"

	elseif (notification == "distribute product") then
		tray:distributeProducts(self.order)
		self.order:draw()
		cleaner:qSayClickable("TEXT_HANDLEPAYMENT")
		self.customerState = "SHOULD_PAY"
		
	end

end

function day0:onClickPerson(person)
	
	-- Handle product click for the first customer:
	if (person:getBaseName() == "INGAME_CUSTOMER_FEMALE_ELDERLY" and self.customerState == "ORDERED") then
		self.customerState = "RECEIVING_PRODUCT"
		emily:qWalkToCounter()
		emily:qWait(200)
		scene:qNotify("distribute product")
	end
	return false
	
end


function day0:onTaskStart(actorType, taskType, p0, p1)

	if (taskType == "RegisterTask" and self.customerState == "CLICK_REGISTER") then
		self.order:setObsolete(true)
		self.order = nil
		qSequence(event.orderHandled)
		
	end
	return false
	
end


-- set day
day = day0()