include("scripts/events/brokenobjectevent.lua")

-- set event
event = brokenObjectEvent()
event.targetType = "Cow"
event.targetGridX = -1
event.targetGridY = -1
event.targetWorkX = 6
event.targetWorkY = 16
event.workAnimationFrameRate = 6
event.pbY = 30

-- day class
class 'day1' (interface)

function day1:__init() super()
end

function day1:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.tail = getObject("rest1_cow_tail")
	self.tail:setAcceptingTasks(true)
	
	self.mo = pm:createPerson("npc")
	self.mo:setBaseName("INGAME_PERSON_SPECIAL_MECHANIC")
	self.mo:setPosition(grid:getNode(1,16))
	self.mo:animate("IDLE", 0)
	
	-- set initial positions
	emily:setPosition(movieNode)
	
	event.brokenObject:animate("APP_COW_CRAZY", 0)
	event.brokenObject.readyAppearance = "APP_COW_SMILE"
	event.brokenObject.readyTime = 1000
	
	-- set event configuration
	event.animFix = "COW_RUB_LEFT"
	event.sequenceStart = nil
	event.timeUntilFixed = 1000 * 60
	event.score = 300
	event.overheadY = 33
	event.pbY = 35	
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 											},
		{ "emily",			"qWalkToXY",				12, 20						},
		{ "mo",	 			"qSay",						"RESTAURANT1_DAY1_0" 		},
		{ "emily", 			"qSetAppearance",			"SURPRISED"			 		},
		{ "emily", 			"qSay",						"RESTAURANT1_DAY1_1" 		},
		{ "mo",	 			"qSay",						"RESTAURANT1_DAY1_2" 		},
		{ "mo",	 			"qSay",						"RESTAURANT1_DAY1_3" 		},
		{ "emily", 			"qSetAppearance",			""					 		},
		{ "emily", 			"qSay",						"RESTAURANT1_DAY1_4" 		},
		{ "emily",			"qWalkToXY",				6, 16						},
		{ "emily",			"qAnimate",					"COW_RUB_STARTUP_LEFT", 1, false, 10	},
		{ "emily",			"qWait",					500							},
		{ "emily",			"qAnimate",					"COW_RUB_LEFT", -1, false, 6		},
		{ "emily",			"qWait",					1500						},
		{ "emily",			"qAnimate",					"IDLE", 0					},
		{ "tail",			"qAnimate",					"DECO_COW_TAIL_ANIM", -1, false, 10 },
		{ "mo",	 			"qSay",						"RESTAURANT1_DAY1_5" 		},
		{ "mo",	 			"qSay",						"RESTAURANT1_DAY1_6" 		},
		{ "emily", 			"qSay",						"RESTAURANT1_DAY1_7" 		},
		{ "tail",			"qAnimate",					"DECO_COW_TAIL", 0			},
		{ "",				"parallel"												},
		{ "mo", 			"qWalkToXY",				32, 2						},
		{ "mo", 			"qDestroy",												},
		{ "emily",			"qWalkToXY",				8, 17						},
		{ "",				"sequential"											},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qStartGame" 											},
	}

	event.sequenceWin =
	{
		{ "scene",			"qStartMovie" 											},
		{ "brokenObject",	"qAnimate",					"APP_COW_SMILE", 0			},
		{ "brokenObject",	"qPlaySound",				"SOUND_COW_MOO"				},
		{ "brokenObject",	"qSay",						"RESTAURANT1_DAY1_8",		},
		{ "emily",			"qAnimate",					"JUMP", 1					},
		{ "emily",			"qWait",					500							},
		{ "emily",			"qAnimate",					"IDLE", 0					},
		{ "scene",			"qFinishMovie" 											}
	}
	
end

-- set day
day = day1()