include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"Berry",
}

-- day class
class 'day2' (interface)

day2.sequenceStart = nil

day2.timeBeforeMidDay = 1000 * 90
day2.timer = 0

function day2:__init() super()
end

function day2:onLevelGlobals()
	
	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.mo = pm:createPerson("npc")
	self.mo:setBaseName("INGAME_PERSON_SPECIAL_MECHANIC")
	self.mo:setPosition(grid:getNode(30,0))
	self.mo:setVisible(false)
	
	-- position everyone
    emily:setPosition(grid:getNode(18, 32))
	
	-- set event configuration
	event.baseName = ""
	event.entryX = 30
	event.entryY = 0
	event.highlightX = 31
	event.highlightY = 12
	event.timeUntilEnterMin = 1
	event.timeUntilEnterMax = 2
	event.scoreFoundOne	= 50
	event.scoreFoundAll	= 100
	self.sequenceStart	=
	{
		{ "scene",		"qStartMovie" 									},
		{ "cleaner", 	"qWalkToXY",		6, 17				 		},
		{ "cleaner", 	"qWait",			500					 		},
		{ "cleaner", 	"qWalkToXY",		19, 26				 		},
		{ "cleaner", 	"qSay",				"RESTAURANT1_DAY2_0" 		},
		{ "emily", 		"qSay",				"RESTAURANT1_DAY2_1" 		},
		{ "cleaner", 	"qSetAppearance",	"SAD" 						},
		{ "cleaner", 	"qSay",				"RESTAURANT1_DAY2_2" 		},
		{ "cleaner", 	"qSay",				"RESTAURANT1_DAY2_3" 		},
		{ "cleaner", 	"qSetAppearance",	""	 						},
		{ "emily", 		"qSay",				"RESTAURANT1_DAY2_4" 		},
		{ "cleaner",	"qSay",				"RESTAURANT1_DAY2_5" 		},
		{ "emily", 		"qSay",				"RESTAURANT1_DAY2_6" 		},
		{ "cleaner",	"qSay",				"RESTAURANT1_DAY2_7" 		},
		{ "cleaner",	"qWalkToNode",		cleaner:getHomeNode()		},
		{ "scene", 		"qFinishMovie" 									},
		{ "scene", 		"qStartGame" 									},		
		{ "scene",		"qNotify",			"start timer"				}
	}
	self.sequenceMidDay = 								
	{
		{ "scene",		"qStartMovie" 									},
		{ "emily", 		"qWalkToXY",		18, 32				 		},
		{ "cleaner", 	"qWalkToXY",		14, 32				 		},
		{ "cleaner", 	"qSay",				"RESTAURANT1_DAY2_8" 		},
		{ "emily", 		"qSay",				"RESTAURANT1_DAY2_9" 		},
		{ "cleaner", 	"qSay",				"RESTAURANT1_DAY2_10" 		},
		{ "cleaner",	"qNotify",			"ho_arrived"				},
		{ "emily",	 	"qSay",				"RESTAURANT1_DAY2_11" 		},
		{ "cleaner", 	"qSay",				"RESTAURANT1_DAY2_12" 		},
		{ "cleaner", 	"qSay",				"RESTAURANT1_DAY2_13" 		},
		{ "scene", 		"qFinishMovie" 									},
		{ "scene",		"qNotify",			"show bar"					}
	}
	event.sequenceDone = 									-- text when you find all items
	{
		{ "scene",		"qStartMovie" 									},
		{ "emily",		"qAnimate",			"JUMP", 1					},
		{ "emily",		"qWait",			500							},
		{ "emily",		"qSetAppearance",	"HAPPY"						},
		{ "emily",		"qAnimate",			"IDLE", 0					},
		{ "emily",		"qSay",				"RESTAURANT1_DAY2_25"		},
		{ "cleaner",	"qSetAppearance",	"HAPPY"						},
		{ "cleaner",	"qSay",				"RESTAURANT1_DAY2_26"		},
		{ "emily",		"qSetAppearance",	""							},
		{ "cleaner",	"qSetAppearance",	""							},
		{ "scene", 		"qFinishMovie" 									},
	}	
	event.sequenceCompleted = 								-- day ends
	{
		{ "scene",		"qStartMovie" 									},
		{ "",			"parallel"										},
		{ "emily",		"qWalkToNode",		grid:getCounterNode()		},
		{ "cleaner",    "qWalkToNode",      cleaner:getHomeNode()       },
		{ "",			"sequential"									},
		{ "mo",         "qSetVisible",      true                        },
		{ "mo", 		"qWalkToXY",		15, 26				 		},
		{ "mo", 		"qSay",				"RESTAURANT1_DAY2_14" 		},
		{ "mo", 		"qSetAppearance",	"BLUSH"				 		},
		{ "mo", 		"qSay",				"RESTAURANT1_DAY2_15" 		},
		{ "cleaner", 	"qSetAppearance",	"BLUSH"				 		},
		{ "cleaner", 	"qSay",				"RESTAURANT1_DAY2_16" 		},
		{ "emily", 		"qSay",				"RESTAURANT1_DAY2_17" 		},
		{ "emily", 		"qSay",				"RESTAURANT1_DAY2_18" 		},
		{ "cleaner", 	"qSay",				"RESTAURANT1_DAY2_19" 		},
		{ "mo", 		"qSay",				"RESTAURANT1_DAY2_20" 		},
		{ "cleaner", 	"qSay",				"RESTAURANT1_DAY2_21" 		},
		{ "cleaner", 	"qWalkToXY",		11, 26 						},
		{ "",			"parallel"										},
		{ "cleaner",	"qWait",			500							},
		{ "cleaner", 	"qWalkToXY",		31, 0 						},
		{ "mo",			"qWait",			500							},
		{ "mo", 		"qWalkToXY",		34, 0 						},
		{ "",			"sequential"									},
		{ "scene", 		"qFinishMovie" 									},
		{ "scene",		"qFinishGame" 									}
	}
	
	-- start sequence
	qSequence(self.sequenceStart)

end

function day2:onTick(time)

	if (event.completed == true) then
		return
	end
	
	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			qSequence(self.sequenceMidDay)
		end		
	end

end

function day2:onNotify(notification)

	if (notification == "start timer") then
		self.timer = self.timeBeforeMidDay
	
	end
	
end

function day2:onDayEnd()
	-- prevent walking out
	autoAllPeopleWalkOut = false
		
	-- play completed sequence
	qSequence(event.sequenceCompleted)
	    
end

-- set day
day = day2()
