include("scripts/events/ordertableevent.lua")

-- set event
event = orderTableEvent()

-- day class
class 'day3' (interface)

day3.child1 = nil
day3.child2 = nil
day3.child3 = nil
day3.child4 = nil
day3.child5 = nil
day3.child6 = nil
day3.child7 = nil
day3.child8 = nil -- parent
day3.table1 = nil
day3.table2 = nil

function day3:__init() super()

	makeProgressBarsSmall = true

end

function day3:onLevelGlobals()

	-- set tables
	self.table1 = om:getTable(2)
	self.table1:setReserved(true)
	self.table2 = om:getTable(1)
	self.table2:setReserved(true)

	-- create children
	self.children = {}
	for i = 1,8 do
		self["child" .. i] = pm:createPerson("fakecustomer")
		self["child" .. i]:setPosition(grid:getNode(0,0))
		self["child" .. i].state = "READ"
		self["child" .. i].timer = 1

		if (getRandom(2) == 0) then self["child" .. i]:setBaseName("INGAME_CUSTOMER_FEMALE_CHILD")
		else  			  			self["child" .. i]:setBaseName("INGAME_CUSTOMER_MALE_CHILD")
		end
	
	end
	-- turn one into a parent
	self.child8:setBaseName("INGAME_CUSTOMER_FEMALE_REGULAR")

	-- set event configuration
	event.pool = 										-- product pool
	{ 
		"CORN", 
		"BREAD",
		"LEMONADE",
		"BREADSLICES",
		"JAM_APPLE",
		"MILK",
		"BUTTERMILK",
		"EGG"
		
	}					
	event.chances = 									-- product chances
	{ 	
		100, 
		100,
		200,
		100,
		20,
		15,
		5,
		30
		
	}				
	event.timeUntilEnterMin = 100000
	event.timeUntilEnterMax = 140000		
	event.timeUntilNextOrder = 8000						-- interval at which the orders come
	event.timeUntilEnd = 150000							-- time allowed to make all products
	event.timeTransfer = 400							-- time it takes to transfer the order	
	event.numProductsPerOrder = 2						-- number of products ordered each order
	event.numOrders = 10								-- total number of orders
	event.score = 40
	event.maxBalloonSize = 15
	event.pbX = -20
	event.table = self.table2
	event.subjectImage = "EVENT_BIRTHDAY_BAR"
	event.sequenceStart = 
	{
		{ "scene",		"qNotify",			"start"						},	
		{ "scene",		"qStartMovie" 									},
		{ "child8",		"qSetPosition",		"movieNode" 				},
		{ "child8",		"qWalkToXY",		25,	13						},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_0"		},
		{ "",			"parallel"										},
		{ "child1",		"qSetPosition",		"movieNode" 				},
		{ "child1",		"qWait",			200							},
		{ "child1",		"qSitAt",			"table1", 0					},
		{ "child2",		"qSetPosition",		"movieNode" 				},
		{ "child2",		"qWait",			500							},
		{ "child2",		"qSitAt",			"table1", 1					},
		{ "child3",		"qSetPosition",		"movieNode" 				},
		{ "child3",		"qWait",			700							},
		{ "child3",		"qSitAt",			"table1", 2					},
		{ "child4",		"qSetPosition",		"movieNode" 				},
		{ "child4",		"qWait",			1100						},
		{ "child4",		"qSitAt",			"table1", 3					},
		{ "child5",		"qSetPosition",		"movieNode" 				},
		{ "child5",		"qWait",			1300						},
		{ "child5",		"qSitAt",			"table2", 0					},
		{ "child6",		"qSetPosition",		"movieNode" 				},
		{ "child6",		"qWait",			1600						},
		{ "child6",		"qSitAt",			"table2", 1					},
		{ "child7",		"qSetPosition",		"movieNode" 				},
		{ "child7",		"qWait",			2000						},
		{ "child7",		"qSitAt",			"table2", 2					},
		{ "",			"sequential"									},
		{ "child8",		"qSitAt",			"table2", 3					},
		{ "emily",		"qWalkTo",			"table2"					},
		{ "emily",		"qSay",				"RESTAURANT1_DAY3_1"		},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_2"		},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_3"		},
		{ "scene",		"qFinishMovie" 									},		
		{ "scene",		"qNotify",			"start ordering"			},
	}	
	event.sequenceWin = 
	{
		{ "scene",		"qStartMovie" 									},
		{ "child1",		"qSetAppearance",	"HAPPY"						},
		{ "child2",		"qSetAppearance",	"HAPPY"						},
		{ "child3",		"qSetAppearance",	"HAPPY"						},
		{ "child4",		"qSetAppearance",	"HAPPY"						},
		{ "child5",		"qSetAppearance",	"HAPPY"						},
		{ "child6",		"qSetAppearance",	"HAPPY"						},
		{ "child7",		"qSetAppearance",	"HAPPY"						},
		{ "child8",		"qSetAppearance",	"HAPPY"						},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_20"		},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_21"		},
		{ "",			"parallel"										},
		{ "child1",		"qSayTimed",		"RESTAURANT1_DAY3_22",	2500	},
		{ "child2",		"qWait",			100								},
		{ "child2",		"qSayTimed",		"RESTAURANT1_DAY3_22",	2500	},
		{ "child3",		"qWait",			300								},
		{ "child3",		"qSayTimed",		"RESTAURANT1_DAY3_22",	2500	},
		{ "child4",		"qWait",			200								},
		{ "child4",		"qSayTimed",		"RESTAURANT1_DAY3_22",	2500	},
		{ "child5",		"qWait",			200								},
		{ "child5",		"qSayTimed",		"RESTAURANT1_DAY3_22",	2500	},
		{ "child6",		"qWait",			100								},
		{ "child6",		"qSayTimed",		"RESTAURANT1_DAY3_22",	2500	},
		{ "child7",		"qWait",			300								},
		{ "child7",		"qSayTimed",		"RESTAURANT1_DAY3_22",	2500	},
		{ "",			"sequential"									},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_23"		},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_24"		},
		{ "emily",		"qSetAppearance",	"BLUSH"						},
		{ "emily",		"qSay",				"RESTAURANT1_DAY3_25"		},
		{ "emily",		"qSetAppearance",	""							},
		{ "scene",		"qFinishMovie" 									},
		{ "",			"qSequence",		"sequenceExit" 				},
	}
	event.sequenceLose = 
	{
		{ "scene",		"qStartMovie" 									},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_10"		},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_11"		},
		{ "emily",		"qWalkTo",			"table2"					},
		{ "emily",		"qSay",				"RESTAURANT1_DAY3_12"		},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_13"		},
		{ "child8",		"qSay",				"RESTAURANT1_DAY3_14"		},
		{ "scene",		"qFinishMovie" 									},
		{ "",			"qSequence",		"sequenceExit" 				},		
	}
	event.sequenceExit = 
	{
		{ "child1",		"qWait",			200							},
		{ "child1",		"qStand"										},				
		{ "child1",		"qWalkToNode",		exitNode					},
		{ "child1",		"qDestroy",			"day.child1"				},
		{ "child2",		"qWait",			500							},
		{ "child2",		"qStand"										},				
		{ "child2",		"qWalkToNode",		exitNode					},
		{ "child2",		"qDestroy",			"day.child2"				},
		{ "child3",		"qWait",			700							},
		{ "child3",		"qStand"										},				
		{ "child3",		"qWalkToNode",		exitNode					},
		{ "child3",		"qDestroy",			"day.child3"				},
		{ "child4",		"qWait",			1100						},
		{ "child4",		"qStand"										},				
		{ "child4",		"qWalkToNode",		exitNode					},
		{ "child4",		"qDestroy",			"day.child4"				},
		{ "child5",		"qWait",			1300						},
		{ "child5",		"qStand"										},				
		{ "child5",		"qWalkToNode",		exitNode					},
		{ "child5",		"qDestroy",			"day.child5"				},
		{ "child6",		"qWait",			1600						},
		{ "child6",		"qStand"										},				
		{ "child6",		"qWalkToNode",		exitNode					},
		{ "child6",		"qDestroy",			"day.child6"				},
		{ "child7",		"qWait",			2000						},
		{ "child7",		"qStand"										},				
		{ "child7",		"qWalkToNode",		exitNode					},
		{ "child7",		"qDestroy",			"day.child7"				},
		{ "child8",		"qWait",			2300						},		
		{ "child8",		"qStand"										},				
		{ "child8",		"qWalkToNode",		exitNode					},
		{ "child8",		"qDestroy",			"day.child8"				},		
		{ "scene",		"qNotify",			"all left"					},		
	}

end

function day3:onNotify(notification)

	if (notification == "start ordering") then
		for i = 1,8  do    
			self["child" .. i].state = "ORDER"
		
		end
		
	elseif (notification == "start eating") then
		for i = 1,8  do    
			if (getRandom(2) == 0) then	self["child" .. i].state = "DRINK"
			else						self["child" .. i].state = "EAT"
			end
		
		end
		
	elseif (notification == "stop eating") then
		for i = 1,8  do    
			self["child" .. i].state = "ORDER"
		
		end		
		
	elseif (notification == "all left") then
		self.table1:setReserved(false)
		self.table2:setReserved(false)	
	
	end

end

function day3:onTick(time)

	-- the group customers have to do other stuff
	if (event.started == true) then
		for i = 1,8  do    
			local child = self["child" .. i]
			if (child and child:isSitting()) then
				if (child.state == "READ") then
					if (child.timer > 0) then
						child.timer = child.timer - time
						if (child.timer <= 0) then
							child:animate(child.state, 1)
							child.timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)
						
						end
					end			
				
				elseif (child.state == "ORDER") then
					if (child.timer > 0) then
						child.timer = child.timer - time
						if (child.timer <= 0) then
							child:animate(child.state, 1)
							child.timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
						
						end
					end				
				
				elseif (child.state == "DRINK" or child.state == "EAT") then
					if (child.timer > 0) then
						child.timer = child.timer - time
						if (child.timer <= 0) then
							child:animate(child.state, 1)
							child.timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
						
							if (getRandom(2) == 0) then	child.state = "DRINK"
							else						child.state = "EAT"
							end					
						
						end
					end
				
				end
			end
		end
	end
	
end

-- set day
day = day3()