include("scripts/events/cameraevent.lua")

-- set event
event = cameraEvent()

-- day class
class 'day4' (interface)

day4.firstTry = true

function day4:__init() super()
end

function day4:onLevelGlobals()
	entertainer:setAutoActivation(false)
	entertainer:setVisible(false)
	entertainer:setClickable(false)
	self.firstTry = true

	-- set event configuration
	event.baseName = "INGAME_PERSON_BEAGLE"
	event.actionDuration = 100
	event.coordinates =
	{
		{ 26, 12, 23, 12 },
		{ 12, 18,  9, 18 },
		{ 26, 12, 23, 12 },
		{ 40, 23, 37, 23 },
		{ 35,  7, 32,  7 },
		{ 26, 12, 23, 12 },
		{ 46, 14, 43, 14 },
		{ 18, 18, 15, 18 },	
	}
	event.score = 500
	event.timerStart = 80 * 1000
	event.timerReturn = 8 * 1000
	event.scoreGotOne = 25
	event.scoreGotAll = 100
	event.sequenceStart =
	{
		{ "scene",			"qStartMovie" 									},
		{ "",				"parallel"										},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "camPerson",		"qSetVisible",		true						},
		{ "camPerson",		"qSetPosition",		movieNode					},
		{ "camPerson",		"qWalkToXY",		23, 21						},
		{ "",				"sequential"									},
		{ "cleaner",		"qSay",				"RESTAURANT1_DAY4_0"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_1"		},
		{ "scene", 			"qFinishMovie" 									},
		
	}
	event.sequenceTooLate =
	{
		{ "camPerson",		"qSayTimed",		"RESTAURANT1_DAY4_BARF_SAD", 1500	}		
	}	
	event.sequenceCompleted =
	{
		{ "scene",			"qStartMovie" 									},
		
		{ "camPerson",		"qAnimate",			"ENTERTAIN", -1				},
		{ "camPerson",		"qSay",				"RESTAURANT1_DAY4_BARF_HAPPY"	},
		{ "camPerson",		"qWait",			750							},
		{ "camPerson",		"qAnimate",			"IDLE", 0					},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_3"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_4"		},
		{ "camPerson",		"qSay",				"RESTAURANT1_DAY4_BARF_HAPPY"	},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_5"		},
		{ "scene", 			"qFinishMovie" 									},
		{ "camPerson",		"qWalkToNode",		entertainer:getHomeNode()	},
		{ "camPerson",		"qNotify",			"dog entertainer"			}
	}
	
end

function day4:onLevelInited()
	entertainer:setVisible(false)
	entertainer:setClickable(false)
	event.camPerson:setVisible(false)
end

function day4:onDayBegin()
end

function day4:onNotify(notification)

	if (notification == "camera start") then
		
		event.camPerson:setSelected(false)
		if (self.firstTry == true) then
			self.firstTry = false
			emily:qSay("RESTAURANT1_DAY4_2")
			parallel()
		end
		
		event.camPerson:qAnimate("ENTERTAIN", -1)
		event.camPerson:qSayTimed("RESTAURANT1_DAY4_BARF_HAPPY", 600)
		event.camPerson:qWait(700)
		event.camPerson:qAnimate("IDLE", 0)

		emily:qAnimate("LAUGH", -1, true, 8)
		emily:qWait(750)
		emily:qAnimate("IDLE", 0)
		
		event.camPerson:playSound("SOUND_TIP_POPS_IN_AIR","sound")
	
	elseif (notification == "camera complete") then
	
	
	elseif (notification == "dog entertainer") then
		entertainer:setAutoActivation(true)
		entertainer:qSetVisible(true)
		entertainer:qSetClickable(true)
		event.camPerson:qDestroy()
	
	end

end

-- set day
day = day4()