-- day class
class 'day5' (interface)

day5.goldDropped = false
day5.goldEgg = nil
day5.sequenceDropped = nil
day5.workNode = nil

function day5:__init() super()
end

function day5:onLevelGlobals()

	self.sequenceDropped = 
	{
		{ "scene",		"qStartMovie" 									},
		{ "emily",		"qWalkToNode",		"workNode" 					},
		{ "emily", 		"qSay",				"RESTAURANT1_DAY5_0"		},
		{ "cleaner",	"qWalkToXY",		17, 17						},
		{ "cleaner",	"qAnimate",			"LAUGH", -1, 8				},
		{ "cleaner",	"qWait",			750							},
		{ "cleaner",	"qAnimate",			"IDLE", 0					},
		{ "cleaner",	"qSay",				"RESTAURANT1_DAY5_1"		},
		{ "cleaner",	"qSay",				"RESTAURANT1_DAY5_2"		},
		{ "emily", 		"qSetAppearance",	"BLUSH"						},
		{ "emily", 		"qSay",				"RESTAURANT1_DAY5_3"		},
		{ "emily", 		"qSetAppearance",	""							},
		{ "cleaner",	"qSay",				"RESTAURANT1_DAY5_4"		},
		{ "cleaner",	"qSay",				"RESTAURANT1_DAY5_5"		},
		{ "cleaner",	"qWalkToNode",		cleaner:getHomeNode()		},
		{ "scene",		"qFinishMovie" 									},
		{ "scene",		"qNotify",			"enable golden egg"			},
	}

end

function day5:onLevelInited()

	chicken:setPosition(grid:getNode(22, 19))
	chicken.pointsTimer = 50000		
	chicken.areaTimer = 2000
	chicken.createTimer = 1000
	chicken.areaWidthOffset = 1
	chicken.areaHeightOffset = 1
	chicken.goldTimes = 
	{
		0 * 1000,
		60 * 1000,
		160 * 1000,
		260 * 1000,
		360 * 1000,
		460 * 1000,
	}		

end

function day5:onNotify(notification)

	if (notification == "enable golden egg") then
		self.goldEgg:setClickable(true)	

	elseif (notification == "chicken lays EGG_GOLD") then
		if (self.goldDropped) then
			return
			
		end
		
		chicken.areaWidthOffset = 3
		chicken.areaHeightOffset = 3
	
		-- get golden egg
		for index, egg in pairs(chicken.eggs) do
			if (egg:getState() == "GOLD") then
				self.goldEgg = egg
				self.goldEgg:setClickable(false)
				break
			end		
		end
		
		if (self.goldEgg == nil) then
			return
		
		end
		
		-- where should emily walk
		local gridX = self.goldEgg.gridX
		local gridY = self.goldEgg.gridY
		local emilyX = emily:getPosition():getGridX()
		local emilyY = emily:getPosition():getGridY()
		local emilyNode = grid:getNode(emilyX, emilyY)
		local offsets =
		{
			{0, -1},
			{0, -2},			
			{-2, 0},
			{2,  0},
			{-1, 0},
			{1,  0},
		}
		local workX = nil
		local workY = nil
		for index, offset in pairs(offsets) do
			workX = gridX + offset[1]
			workY = gridY + offset[2]
			self.workNode = grid:getNode(workX, workY)
			
			if (not self.workNode:isBlocked()) then
				if (grid:existsPath(emilyNode, self.workNode)) then
					break
				
				end
			end		
		end
		
		-- walk if we found a worknode
		if (self.workNode ~= nil) then
			qSequence(self.sequenceDropped)
			self.goldDropped = true
			
		else
			warn("could not find workNode for EGG_GOLD")
			
		end
	end

end

-- set day
day = day5()