include("scripts/events/mailmanevent.lua")

-- set event
event = mailmanEvent()

-- day class
class 'day6' (interface)

function day6:__init() super()
end

function day6:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.mo = pm:createPerson("npc")
	self.mo:setPosition(grid:getNode(32,2))
	self.mo:setBaseName("INGAME_PERSON_SPECIAL_MECHANIC")
	self.mo:setName("MO")
	
	-- position everyone
	entertainer:setPosition(entertainer:getHomeNode())
    cleaner:setPosition(cleaner:getHomeNode())
    emily:setPosition(grid:getCounterNode())

	-- set event configuration
	event.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"
	event.timeUntilEnterMin = 1000 * 15
	event.timeUntilEnterMax = 1000 * 30
	event.timeUntilAngry = 8000
	event.timeUntilLeave = 6000
	event.numPackages = 12
	event.entryX = 30
	event.entryY = 0
	event.waitX = 28
	event.waitY = 11
	event.workX = 24
	event.workY = 11
	event.angryAnim = "IDLE_WAITING"
	event.workAnim = "GIVE_LEFT"
	event.workAnimEmily = "WORK_RIGHT"
	event.scoreGotOne = 25
	event.scoreGotAll = 100
	event.package = "OBJECT_PACKAGE"
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "mo",				"qSetPosition",		movieNode					},
		{ "mo",				"qSetAppearance",	"HAPPY"						},
		{ "mo",				"qWalkToXY",		20,	29						},
		{ "mo",				"qSay",				"RESTAURANT1_DAY6_0"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY6_1"		},
		{ "mo",				"qSay",				"RESTAURANT1_DAY6_2"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY6_3"		},
		{ "mo",				"qSay",				"RESTAURANT1_DAY6_4"		},
		{ "emily",			"qAnimate",			"JUMP", 1					},
		{ "emily",			"qWait",			500							},
		{ "emily",			"qAnimate",			"IDLE", 0					},				
		{ "mo",				"qSay",				"RESTAURANT1_DAY6_5"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY6_6"		},
		{ "mo",				"qSay",				"RESTAURANT1_DAY6_7"		},
		{ "mo",				"qWalkToNode",		"movieNode"					},
		{ "mo",				"qDestroy",			"day.mo"					},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									}
	}

end

function day6:onLevelInited()

	chicken:setPosition(grid:getNode(22, 19))
	chicken.areaTimer = 2000
	chicken.createTimer = 1000
	chicken.easterTimes = 
	{
		3 * 1000,
	}		

end

-- set day
day = day6()