include("scripts/events/fillevent.lua")

-- set event
event = fillEvent()
event.targetType = "Bucket"

-- day class
class 'day7' (interface)

-- configuration variables
day7.timeUntilStartMin = 1000
day7.timeUntilStartMax = 2000
day7.timeUntilEnterMin = 1000 * 30
day7.timeUntilEnterMax = 1000 * 45
day7.numFills = 6
day7.numRight = 0
day7.numSpill = 0
day7.scoreFoundOne = 25
day7.scoreFoundOneSpill = 10
day7.scoreFoundAll = 100

-- internal variables
-- don't change unless you know what you're doing
day7.timer = 0
day7.sequenceStart = nil
day7.sequenceEnter = nil
day7.sequenceLeave = nil
day7.sequenceFinish = nil
day7.charles = nil
day7.count = 0

function day7:__init() super()
end

function day7:onLevelGlobals()

  	-- create charles
	self.charles = pm:createPerson("charles")
	self.charles:setPosition(entryNode)
	
	-- hide him and his bucket
	self.charles:setVisible(false)	
	event.fillObject:setVisible(false)
	
	-- initialize event
	event.overheadY = 0	
	event.speed = 0.25
	event.readyProgress = 0.75
	event.spillProgress = 1.0
	event.emptyObject = getObject("rest1_milk_tin")
	event.barBaseX = -1
	event.barFullX = -1
	event.barBaseY = -17
	event.barFullY = -50	
	event.barClip = {-24, -50, 48, 50}
	event.fillAnim = createSprite()	
	event.fillAnim:setVisible(false)
	event.fillAnim:setDefaultSection(player:getCurrentResourceSection())
	event.fillAnim:setDefaultFrameRate(10)
	event.fillAnim:setX(-32)
	event.fillAnim:setY(-80)
	event.fillObject:addChild(event.fillAnim)

	-- initialize event bar
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(self.numFills)
	eventBar:setProgress(0)	
	eventBar:setSubjectImage("OBJECT_BUCKET_BAR", player:getCurrentResourceSection())
	eventBar:setDescriptionText(getText("EVENTBAR"))	
	
	-- set timer
	self.timer = getRandomRange(self.timeUntilStartMin, self.timeUntilStartMax)
	
	-- set sequences
	self.sequenceStart = 
	{
		{ "scene",		"qStartMovie" 											},
		{ "charles",	"qSetVisible",				true						},
		{ "charles",	"qSetAppearance",			"ANNOYED"					},
		{ "charles",	"qWalkToXY",				22,	13						},
		{ "charles",	"qSay",						"RESTAURANT1_DAY7_0"		},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY7_1"		},
		{ "charles",	"qSay",						"RESTAURANT1_DAY7_2"		},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY7_3"		},
		{ "emily",		"qWalkToXY",				26, 13						},
		{ "emily",		"qSay",						"RESTAURANT1_DAY7_4"		},
		{ "fillObject",	"qSetVisible",				true						},
		{ "charles",	"qSay",						"RESTAURANT1_DAY7_5"		},
		{ "emily",		"qSetAppearance",			"OFFENDED"					},
		{ "emily",		"qSay",						"RESTAURANT1_DAY7_6"		},
		{ "emily",		"qSetAppearance",			""							},
		{ "charles",	"qSay",						"RESTAURANT1_DAY7_7"		},
		{ "scene",		"qFinishMovie" 											},
		{ "fillObject",	"qCreateScreenOverhead",	"INGAME_ARROW"				},
		{ "scene",		"qNotify",					"start"						},
	}
	self.sequenceEnter =
	{
		{ "charles",	"qSetVisible",				true						},
		{ "charles",	"qWalkToXY",				22,	13						},
		{ "charles",	"qNotify",					"enter"						},
	}
	self.sequenceSpill =
	{
		{ "scene",		"qNotify",					"leave"						},
		{ "fillObject", "qWait",					1900						},
		{ "fillObject", "qNotify",					"frame"						},
		{ "fillObject", "qWait",					3100						},
		{ "charles", 	"qWait",					5000						},
		{ "fillObject", "qClearOverhead",										},
		{ "fillObject",	"qSetVisible",				false						},
		{ "charles",	"qWalkToNode",				exitNode					},
		{ "charles",	"qSetVisible",				false						},	
	}
	self.sequenceLeave = 
	{
		{ "scene",		"qNotify",					"leave"						},
		{ "fillObject", "qWait",					1000						},
		{ "charles", 	"qWait",					1000						},
		{ "fillObject", "qClearOverhead",										},
		{ "fillObject",	"qSetVisible",				false						},
		{ "charles",	"qWalkToNode",				exitNode					},
		{ "charles",	"qSetVisible",				false						},
	}
	self.sequenceFinish = 
	{
		{ "scene",		"qStartMovie" 											},
		{ "emily",		"qWalkToNode",				grid:getCounterNode()		},
		{ "emily",		"qSetAppearance",			"OFFENDED"					},
		{ "emily",		"qSay",						"RESTAURANT1_DAY7_10"		},
		{ "cleaner",	"qWalkToXY",				19, 32						},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY7_11"		},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY7_12"		},
		{ "emily",		"qSetAppearance",			""							},
		{ "emily",		"qSay",						"RESTAURANT1_DAY7_13"		},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY7_14"		},
		{ "emily",		"qSay",						"RESTAURANT1_DAY7_15"		},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY7_16"		},
		{ "cleaner",	"qWalkToNode",				cleaner:getHomeNode()		},
		{ "scene",		"qFinishMovie" 											},
		{ "scene",		"qFinishGame"											},
		{ "scene",		"qNotify",					"end"						},
	}

end

function day7:onDayEnd()

	event.fillObject:setVisible(false)
	
end

function day7:onTick(time)

	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			if (self.sequenceStart) then
				qSequence(self.sequenceStart)
				self.sequenceStart = nil
			else
				qSequence(self.sequenceEnter)
			
			end		
			
			self.count = self.count + 1
		end
	end

end

function day7:onNotify(notification)

	if (notification == "start") then
		eventBar:animateToActive()
		eventBar:raiseCurtain()
		event:onStart()

	elseif (notification == "enter") then
		eventBar:raiseCurtain()
		event:onStart()		
		event.fillObject:setVisible(true)		
		event.fillFront:setVisible(true)
		event.fillAnim:setVisible(false)

	elseif (notification == "leave") then
		eventBar:lowerCurtain()
		
	elseif (notification == "end") then
		eventBar:animateToDeactive()
		
	elseif (notification == "frame") then
		event.fillAnim:animate("OBJECT_BUCKET_ANIM", 0)
		event.fillAnim:setCurrentFrame(event.fillAnim:getFrameCount() - 1)

	elseif (notification == "fillEvent completed") then
		if (event.fillObject.state == "filling") then
			event.fillObject:playSound(event.soundEventBad)
			qInsertSequence(self.sequenceLeave)	
			
		elseif (event.fillObject.state == "ready") then
			incScore(self.scoreFoundOne, event.fillObject:getScreenX(), event.fillObject:getScreenY() - 50, 0)
			self.numRight = self.numRight + 1
			qInsertSequence(self.sequenceLeave)
			
		elseif (event.fillObject.state == "spill") then
			incScore(self.scoreFoundOneSpill, event.fillObject:getScreenX(), event.fillObject:getScreenY() - 50, 0)
			self.numSpill = self.numSpill + 1
			qInsertSequence(self.sequenceSpill)
			
			event.fillBar:setVisible(false)
			event.fillFront:setVisible(false)
			event.fillAnim:setVisible(true)
			event.fillAnim:animate("OBJECT_BUCKET_ANIM", 1)
			
		end

		eventBar:setProgress(self.numRight + self.numSpill)
	
		if (self.count < self.numFills) then
			self.timer = getRandomRange(self.timeUntilEnterMin, self.timeUntilEnterMax)
		
		elseif (self.count == self.numFills) then
			qSequence(self.sequenceFinish)		
			
		end
		
		if ((self.numRight + self.numSpill) == self.numFills) then
			event.fillObject:playSound(event.soundEventCompleteAll)
			incScore(self.scoreFoundAll, event.fillObject:getScreenX(), event.fillObject:getScreenY() - 50, scoreBonusFloaterDelay, "BONUS")
		
		end

	end

end

-- set day
day = day7()