-- day class
class 'day8' (interface)

function day8:__init() super()
end

function day8:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- position everyone
    emily:setPosition(grid:getCounterNode())
    cleaner:setPosition(cleaner:getHomeNode())
    entertainer:setPosition(entertainer:getHomeNode())

	self.mo = pm:createPerson("npc")
	self.mo:setPosition(grid:getNode(29,0))
	self.mo:setBaseName("INGAME_PERSON_SPECIAL_MECHANIC")
	self.mo:setName("MO")
	
	francois = pm:createPerson("francois")
	francois:setPosition(grid:getNode(29,0))
	francois:setName("FRANCOIS")
	francois:createHighlight()
	
	self.minTimeBetweenPicks = 1000 * 5
	self.maxTimeBetweenPicks = 1000 * 9
	self.pickTimer = 0
	
	self.minTimeBetweenWaves = 1000 * 45
	self.maxTimeBetweenWaves = 1000 * 50
	self.waveTimer = 1000 * 15					-- Initial value is used for first wave, after this a random value is used
	self.maxWaveTime = 1000 * 10				-- Time francois keeps waving before he continues his wandering
	self.waitTimer = 0
	self.shouldWave = false
	self.waving = false
	self.waveID = 1
	self.maxWaveID = 5
	
	-- initialize event bar
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(5)
	eventBar:setProgress(0)				
	eventBar:setDescriptionText(getText("EVENTBAR"))
	eventBar:setSubjectImage("FRANCOIS_BAR", "restaurant_1")
	
    self.coordinates =
	{
		{ 23, 18 },
		{ 23, 11 },
		{ 37, 14 },
		{ 12, 18 },
		{ 45, 11 },
		{ 39, 24 }
	}
	self.currentNodeID = 0
	
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "francois",		"qSetPosition",		movieNode					},
		{ "francois",		"qSetAppearance",	"MOBILE"					},
		{ "francois",		"qWalkToXY",		21,	27						},
		{ "francois",		"qSay",				"RESTAURANT1_DAY8_0"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_1"		},
		{ "francois",		"qSay",				"RESTAURANT1_DAY8_2"		},
		{ "emily",			"qWalkToXY",		17,	27						},
		{ "francois",		"qSetAppearance",	""							},
		{ "emily",			"qSetAppearance",	"MOBILE"					},
		-- Start phone part	----------------
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_3"						},
		{ "emily", 			"qSayPortrait",		"RESTAURANT1_DAY8_4", "PORTRAIT_BOSS" 		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_5"						},
		{ "emily", 			"qSayPortrait",		"RESTAURANT1_DAY8_6", "PORTRAIT_BOSS_ANGRY" },
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_7"						},
		{ "emily", 			"qSayPortrait",		"RESTAURANT1_DAY8_8", "PORTRAIT_BOSS_ANGRY" },
		{ "emily", 			"qSayPortrait",		"RESTAURANT1_DAY8_9", "PORTRAIT_BOSS_ANGRY" },
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_10"						},
		{ "emily", 			"qSayPortrait",		"RESTAURANT1_DAY8_11", "PORTRAIT_BOSS_ANGRY" },
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_12"						},		-- *click*
		-- End phone part	----------------
		{ "emily",			"qSetAppearance",	""							},
		{ "francois",		"qSay",				"RESTAURANT1_DAY8_13"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_14"		},
		{ "francois",		"qSay",				"RESTAURANT1_DAY8_35"		},		
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									},
		{ "scene",			"qNotify", 			"just picked"				}
	}
	self.sequenceCompleted = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "francois",		"qWalkToXY",		28, 24						},
		{ "emily",			"qWalkToXY",		22,	24						},
		{ "francois",		"qSay",				"RESTAURANT1_DAY8_15"		},
		{ "francois",		"qSay",				"RESTAURANT1_DAY8_16"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_17"		},
		{ "mo",				"qSetPosition",		movieNode					},
		{ "mo",				"qWalkToXY",		23,	19						},
		{ "mo",				"qSetAppearance",	"HAPPY"						},
		{ "mo",				"qSay",				"RESTAURANT1_DAY8_18"		},
		{ "mo",				"qSay",				"RESTAURANT1_DAY8_19"		},
		{ "mo",				"qSetAppearance",	""							},
		{ "emily",			"qSetAppearance",	"SAD"						},
		{ "emily",			"qWait",			500							},
		{ "mo",				"qSetAppearance",	"SAD"						},
		{ "mo",				"qSay",				"RESTAURANT1_DAY8_20"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_21"		},
		{ "mo",				"qSetAppearance",	""							},
		{ "francois",		"qSetAppearance",	"HAPPY"						},
		{ "francois",		"qSay",				"RESTAURANT1_DAY8_22"		},
		{ "francois",		"qSetAppearance",	""							},
		{ "francois",		"qSay",				"RESTAURANT1_DAY8_23"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_24"		},
		{ "cleaner",		"qSetAppearance",	"RUN"						},
		{ "cleaner",		"qSetWalkTimePerNode", 35						},
		{ "cleaner",		"qWalkToXY",		16, 24						},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "cleaner",		"qSay",				"RESTAURANT1_DAY8_25"		},
		{ "mo",				"qSay",				"RESTAURANT1_DAY8_26"		},
		{ "emily",			"qSetAppearance",	"LAUGH"						},
		{ "cleaner",		"qSetAppearance",	"BLUSH"						},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_27"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "mo",				"qSay",				"RESTAURANT1_DAY8_28"		},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_29"		},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}	
	qSequence(self.sequenceStart)

end

function day8:onTick(time)

	if (self.waving == false) then
	
		if (self.pickTimer > 0) then
			self.pickTimer = self.pickTimer - time
			if (self.pickTimer <= 0) then
				francois:qNotify("picking time")
			
			end
		end
		
		if (self.waveID <= self.maxWaveID) and (self.waveTimer > 0) then
			self.waveTimer = self.waveTimer - time
			if (self.waveTimer <= 0) then
				self.shouldWave = true
			
			end
		end
		
	elseif (self.waitTimer > 0) then
		self.waitTimer = self.waitTimer - time
		if (self.waitTimer <= 0) then
			-- Francois waited long enough, let's continue picking flowers
			francois:qSetClickable(false)
			self.waving = false
			self.waitTimer = 0
			francois:qAnimate("IDLE", 0)
			francois:removeOverhead()
			francois:qNotify("just waved")
		end
	end

end

function day8:onNotify(notification)

	if (notification == "picking time") then
		-- Walk to the next node in the coordinate list, or to the first:
		self.currentNodeID = self.currentNodeID + 1
		if (self.coordinates[self.currentNodeID] == nil) then
			self.currentNodeID = 1
		end
		
		local gridx = self.coordinates[self.currentNodeID][1]
		local gridy = self.coordinates[self.currentNodeID][2]
	
		-- francois:getHighlight():setActive(false)
		francois:qWalkToXY(gridx, gridy)
		francois:qAnimate("PICK_FLOWER", 1, 8)
		francois:qWait(2000)
		francois:qAnimate("IDLE", 1, 8)
		
		if (self.shouldWave == true) then
			francois:qNotify("wave")
		else
			francois:qNotify("just picked")
		end
		
		
	elseif (notification == "just picked") then
		-- Reset the timer for the next pick:
		self.pickTimer = getRandomRange(self.minTimeBetweenPicks, self.maxTimeBetweenPicks)
	
	elseif (notification == "just waved") then
		-- Reset the timer for the next pick:
		self.waveTimer = getRandomRange(self.minTimeBetweenWaves, self.maxTimeBetweenWaves)
		self.pickTimer = getRandomRange(self.minTimeBetweenPicks, self.maxTimeBetweenPicks)
	
	elseif (notification == "wave") then
		self.waitTimer = self.maxWaveTime
		self.shouldWave = false
		self.waving = true
	    eventBar:raiseCurtain()		
		francois:qAnimate("IDLE_WAVE", -1, 8)
		francois:qCreateOverhead("INGAME_EMPTY_PLATES_SIGN")
		francois:qPlaySound("SOUND_EVENT_ATTENTION")
		francois:qSetClickable(true)

	elseif (notification == "francois talk") then
		scene:qStartMovie()
		francois:qSay("RESTAURANT1_DAY8_WAVE_FRANCOIS_" .. self.waveID)
		self:onNotify("emily talk") 
	
	elseif (notification == "emily talk") then
		eventBar:setProgress(self.waveID)
		
		if (self.waveID == self.maxWaveID) then
			eventBar:animateToDeactive()
			incScore(100, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, 0, "MEMORY")
		end
		
		emily:qSay("RESTAURANT1_DAY8_WAVE_EMILY_" .. self.waveID)
		scene:qFinishMovie()
		emily:qNotify("next")
	
	elseif (notification == "next") then
		self.waveID = self.waveID + 1
		francois:qNotify("just waved")	
	
	end
end

function day8:onClickPerson(person)

	if (person:getBaseName() == "INGAME_PERSON_FRANCOIS" and self.waving == true) then
        eventBar:lowerCurtain()	
		francois:setClickable(false)
		francois:removeOverhead()
		self.waving = false
		self.waitTimer = 0
		francois:qAnimate("IDLE", 0)
		francois:qNotify("francois talk")
		incScore(25, francois:getScreenX(), francois:getScreenY() + scorePersonFloaterOffsetY, 0, "MEMORY")
		
	end
	
end

function day8:onDayBegin()
	eventBar:animateToActive()
	
end

function day8:onDayEnd()
	francois:removeOverhead()
	
	-- prevent walking out
	autoAllPeopleWalkOut = false
	
	-- play completed sequence
	qSequence(self.sequenceCompleted)

end

-- set day
day = day8()