include("scripts/persons/tashi.lua")

-- day class
class 'day9' (interface)

day9.sequenceStart = nil
day9.sequenceWin = nil
day9.sequenceFinish = nil
day9.state = "idle"
day9.ministate = 0
day9.nextTimer = 0
day9.nextTimers = { 20000, 40000, 30000, 20000, 30000, 40000, 20000 }
day9.actionTimer = 0
day9.actionTimers = { 15000, 15000, 15000, 30000, 15000, 15000, 30000 }
day9.textTime = 4000
day9.states = { "egg", "jam", "cow", "pie", "entertain", "apples", "register", }
day9.index = 0
day9.heighest = 0
day9.scoreGotOne = 25
day9.scoreGotAll = 100

function day9:__init() super()
end

function day9:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	-- set initial positions
	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(entryNode)
	entertainer:setPosition(entertainer:getHomeNode())

	-- set sequences
	self.sequenceStart =
	{
		{ "scene",		"qStartMovie" 											},
		{ "cleaner",	"qSetAppearance",			"RUN"						},
		{ "cleaner",	"qSetWalkTimePerNode",		35							},
		{ "cleaner",	"qSetPosition",				movieNode					},
		{ "cleaner",	"qWalkToXY",				21, 29						},
		{ "cleaner",	"qSetWalkTimePerNode",		70							},
		{ "cleaner",	"qSetAppearance",			""							},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY9_0"		},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY9_1"		},
		{ "emily",		"qSetAppearance",			"SURPRISED"					},
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_2"		},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY9_3"		},
		{ "emily",		"qSetAppearance",			"SAD"						},
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_4"		},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY9_5"		},
		{ "emily",		"qSetAppearance",			""							},
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_6"		},
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_7"		},
		{ "cleaner",	"qWalkToNode",				cleaner:getHomeNode()		},
		{ "scene",		"qFinishMovie" 											},
		{ "scene",		"qStartGame" 											},
	}
	self.sequenceWin = 
	{	
		{ "scene",		"qStartMovie" 											},
		{ "cleaner",	"qSetAppearance",			"HAPPY"						},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY9_20"		},
		{ "emily",		"qSetAppearance",			"HAPPY"						},
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_21"		},
		{ "cleaner",	"qSetAppearance",			""							},
		{ "emily",		"qSetAppearance",			""							},
		{ "scene",		"qFinishMovie" 											},		
	}
	self.sequenceFinish = 
	{
		{ "scene",		"qStartMovie" 											},
		{ "",			"parallel"												},
		{ "emily",		"qWait",					300							},
		{ "emily",		"qWalkToXY",				32, 14						},
		{ "cleaner",	"qWalkToXY",				29, 14						},
		{ "",			"sequential"											},
		{ "emily",		"qSetAppearance",			"NEUTRAL"					},
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_30"		},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY9_31"		},
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_32"		},
		{ "emily",		"qSetAppearance",			""							},		
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_33"		},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY9_34"		},		
		{ "emily",		"qAnimate",					"LAUGH", -1, 8				},
		{ "emily",		"qWait",					750							},
		{ "emily",		"qAnimate",					"IDLE", 0					},
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_35"		},
		{ "cleaner",	"qSetAppearance",			"BLUSH"						},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY9_36"		},
		{ "cleaner",	"qSetAppearance",			""							},
		{ "emily",		"qAnimate",					"LAUGH", -1, 8				},
		{ "emily",		"qWait",					750							},
		{ "emily",		"qAnimate",					"IDLE", 0					},		
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_37"		},
		{ "emily",		"qSay",						"RESTAURANT1_DAY9_38"		},
		{ "cleaner",	"qSetAppearance",			"HAPPY"						},
		{ "cleaner",	"qSay",						"RESTAURANT1_DAY9_39"		},		
		{ "emily",		"qWalkToNode",				exitNode					},
		{ "scene",		"qFinishMovie" 											},	
		{ "scene",		"qFinishGame"											},
	}	
	
	-- start sequence
	qSequence(self.sequenceStart)
	
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(table.getn(self.states))
	eventBar:setProgress(0)	
	eventBar:setDescriptionText(getText("EVENTBAR"))

end

function day9:createPerson(class)

	if (class == "cleaner") then
		c = tashi("INGAME_PERSON_TASHI")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c:setButtX(20)
		c.clean = true
		return c	
		
	end
	
	return nil

end

function day9:onDayBegin()

	eventBar:animateToActive()
	self:gotoNext()

end

function day9:onDayEnd()

	autoAllPeopleWalkOut = false
	qSequence(self.sequenceFinish)

end

function day9:onNotify(notification)

    if (notification == "show wave") then
        if (self.state == "egg") then
			for index, egg in pairs(chicken.eggs) do
				if (egg.queued == false) then        
					hm:openHint(HINT_TEACHTASHI, egg:getScreenX(), egg:getScreenY())
					hm:placeArrow(ARROW_HINT_EGG_TASHI, egg, 0, 0)
					break
					
				end
			end
        end
    end

end

function day9:onTick(time)

	if (scene:isStartingMovie()) then
		return
	end
	
	if (scene:isPlayingMovie()) then
		return
	end
	
	if (self.actionTimer > 0) then
		self.actionTimer = self.actionTimer - time
		if (self.actionTimer <= 0) then
			self:gotoPrev()		
		
		end	
	end

    if (self.nextTimer > 0) then
		self.nextTimer = self.nextTimer - time
		if (self.nextTimer <= 0) then	
			if (self.state == "egg") then
				cleaner:qWalkToNode(cleaner:getHomeNode())
				cleaner:qPlaySound("SOUND_EVENT_ATTENTION")
				cleaner:qSayTimed("RESTAURANT1_DAY9_10", self.textTime)
			    cleaner:qNotify("show wave")
				self.ministate = 1
				self.actionTimer = self.actionTimers[self.index]
						
			elseif (self.state == "jam") then
				cleaner:qWalkToNode(cleaner:getHomeNode())
				cleaner:qPlaySound("SOUND_EVENT_ATTENTION")
				cleaner:qSayTimed("RESTAURANT1_DAY9_11", self.textTime)
				cleaner:qNotify("show wave")
				self.ministate = 1
				self.actionTimer = self.actionTimers[self.index]
			
			elseif (self.state == "cow") then
				cleaner:qWalkToNode(cleaner:getHomeNode())
				cleaner:qPlaySound("SOUND_EVENT_ATTENTION")
				cleaner:qSayTimed("RESTAURANT1_DAY9_12", self.textTime)
				cleaner:qNotify("show wave")
				self.ministate = 1
				self.actionTimer = self.actionTimers[self.index]
			
			elseif (self.state == "apples") then
				cleaner:qWalkToNode(cleaner:getHomeNode())
				cleaner:qPlaySound("SOUND_EVENT_ATTENTION")
				cleaner:qSayTimed("RESTAURANT1_DAY9_13", self.textTime)
				cleaner:qNotify("show wave")
				self.ministate = 1
				self.actionTimer = self.actionTimers[self.index]
			
			elseif (self.state == "entertain") then
				cleaner:qWalkToNode(cleaner:getHomeNode())
				cleaner:qPlaySound("SOUND_EVENT_ATTENTION")
				cleaner:qSayTimed("RESTAURANT1_DAY9_14", self.textTime)	
				cleaner:qNotify("show wave")
				self.ministate = 1
				self.actionTimer = self.actionTimers[self.index]
			
			elseif (self.state == "pie") then
				cleaner:qWalkToNode(cleaner:getHomeNode())
				cleaner:qPlaySound("SOUND_EVENT_ATTENTION")
				cleaner:qSayTimed("RESTAURANT1_DAY9_15", self.textTime)	
				cleaner:qNotify("show wave")
				self.ministate = 1
				self.actionTimer = self.actionTimers[self.index]
			
			elseif (self.state == "register") then
				cleaner:qWalkToNode(cleaner:getHomeNode())
				cleaner:qPlaySound("SOUND_EVENT_ATTENTION")
				cleaner:qSayTimed("RESTAURANT1_DAY9_16", self.textTime)	
				cleaner:qNotify("show wave")
				self.ministate = 1
				self.actionTimer = self.actionTimers[self.index]
			
			else
				warn("day9:onTick - invalid state")
			
			end
			
	    	eventBar:setSubjectImage("EVENT_TEACHTASHI" .. self.index .. "_BAR", player:getCurrentResourceSection())		
	    	eventBar:raiseCurtain()			
		end
	end

end

function day9:gotoNext()

    if (self.index > 0) then
    	if (self.heighest < self.index) then
    		self.heighest = self.index
    		incScore(self.scoreGotOne, cleaner:getScreenX(), cleaner:getScreenY() + scorePersonFloaterOffsetY)	
			
    	end

		cleaner:qPlaySound("SOUND_EVENT_COMPLETE_ITEM")
		cleaner:qWalkToNode(cleaner:getHomeNode())
		cleaner:qSayTimed("RESTAURANT1_DAY9_47", self.textTime)    	
    end

	self.index = self.index + 1
	
	if (self.index > table.getn(self.states)) then
		self.state = "ended"
		self.actionTimer = 0
		if (self.sequenceWin ~= nil) then
			qSequence(self.sequenceWin)
		
		end
		eventBar:setProgress(self.index - 1)
		eventBar:animateToDeactive()
		incScore(self.scoreGotAll, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")	
		cleaner:qPlaySound("SOUND_EVENT_COMPLETE_ALL")
		
	else
    	self.state = self.states[self.index]
    	self.ministate = 0
    	self.nextTimer = self.nextTimers[self.index]
    	self.actionTimer = 0
    	
	    eventBar:setProgress(self.index - 1)
		eventBar:lowerCurtain()  
	end

end

function day9:gotoPrev()

	if (self.index == 1) then
		-- do nothing

	elseif (self.index > 1) then
		self.index = self.index - 1
		self.state = self.states[self.index]
		self.ministate = 1
		self.nextTimer = 0
		self.actionTimer = 0
		
		if (self.state == "egg") then
			cleaner:qWalkToNode(cleaner:getHomeNode())
			cleaner:qPlaySound("SOUND_EVENT_BAD")
			cleaner:qSayTimed("RESTAURANT1_DAY9_40", self.textTime)	
					
		elseif (self.state == "jam") then
			cleaner:qWalkToNode(cleaner:getHomeNode())
			cleaner:qPlaySound("SOUND_EVENT_BAD")
			cleaner:qSayTimed("RESTAURANT1_DAY9_41", self.textTime)	
		
		elseif (self.state == "cow") then
			cleaner:qWalkToNode(cleaner:getHomeNode())
			cleaner:qPlaySound("SOUND_EVENT_BAD")
			cleaner:qSayTimed("RESTAURANT1_DAY9_42", self.textTime)	
		
		elseif (self.state == "apples") then
			cleaner:qWalkToNode(cleaner:getHomeNode())
			cleaner:qPlaySound("SOUND_EVENT_BAD")
			cleaner:qSayTimed("RESTAURANT1_DAY9_43", self.textTime)	
		
		elseif (self.state == "entertain") then
			cleaner:qWalkToNode(cleaner:getHomeNode())
			cleaner:qPlaySound("SOUND_EVENT_BAD")
			cleaner:qSayTimed("RESTAURANT1_DAY9_44", self.textTime)			
		
		elseif (self.state == "pie") then
			cleaner:qWalkToNode(cleaner:getHomeNode())
			cleaner:qPlaySound("SOUND_EVENT_BAD")
			cleaner:qSayTimed("RESTAURANT1_DAY9_45", self.textTime)	
		
		elseif (self.state == "register") then
			cleaner:qWalkToNode(cleaner:getHomeNode())
			cleaner:qPlaySound("SOUND_EVENT_BAD")
			cleaner:qSayTimed("RESTAURANT1_DAY9_46", self.textTime)	
		
		else
			warn("day9:gotoPrev - invalid state")
		
		end		
		
	end
	
	eventBar:setProgress(self.index - 1)
	eventBar:setSubjectImage("EVENT_TEACHTASHI" .. self.index .. "_BAR", player:getCurrentResourceSection())

end

function day9:onTaskComplete(actorType, taskType, p0, p1)

	if (taskType == "ProductTask") then
		if (self.state == "egg") then
			if (self.ministate == 1) then
				if (p0:getName() == "EGG") then
					self:gotoNext()
			
				end			
			end
		elseif (self.state == "jam") then
			if (self.ministate == 1) then
				if (p0:getName() == "JAM") then
					self.ministate = self.ministate + 1
			
				end
			elseif (self.ministate == 2) then
				if (p0:getName() == "APPLE" or p0:getName() == "CHERRY") then
					self:gotoNext()
				
				else
					self.ministate = self.ministate - 1
				
				end
			end
		elseif (self.state == "pie") then
			if (self.ministate == 1) then
				if ((p0:getName() == "CAKEMOLD_APPLE_FINISH") or (p0:getName() == "CAKEMOLD_CHERRY_FINISH")) then
					self:gotoNext()
					
				end
			end
		end
	elseif (taskType == "ActorTask") then
		if (self.state == "cow") then
			if (self.ministate == 1) then
				if (p0:getType() == "Cow") then
					self:gotoNext()
				
				end			
			end		
		elseif (self.state == "apples") then
			if (self.ministate == 1) then
				if (p0:getType() == "AppleTree") then
					self:gotoNext()
				
				end			
			end		
		end
	elseif (taskType == "EntertainTask") then
		if (self.state == "entertain") then
			if (self.ministate == 1) then
				self:gotoNext()
			
			end		
		end	
	elseif (taskType == "RegisterTask") then
		if (self.state == "register") then
			if (self.ministate == 1) then
				self:gotoNext()
			
			end		
		end	
	end

end

-- set day
day = day9()