include("scripts/appliances/gumballmachine.lua")
include("scripts/appliances/candyjars.lua")
include("scripts/appliances/candyoven.lua")
include("scripts/products/regularproduct.lua")
include("scripts/products/gumballproduct.lua")
include("scripts/products/candyjarproduct.lua")
include("scripts/products/candyOvenProduct.lua")
include("scripts/persons/charles.lua")
-- global variables and behavior we might need in a specific restaurant

-- entry node
-- npc's and such will be spawned at this location
entryX = 0
entryY = 5
entryNode = nil

-- exit node
exitX = 0
exitY = 5
exitNode =  nil

-- movie node
-- when a movie is playing and an npc's enters or exits (and gets destroyed),
-- it will do so from this node
movieX = 29
movieY = 4
movieNode = nil

-- worker table
-- this is the 1 person table that the cleaner sits on
workerTable = nil

-- restaurant class
class 'restaurant2' (interface)

function restaurant2:__init() super()
end

function restaurant2:onLevelGlobals()

	local tableIdx = 0
	local table = om:getTable(tableIdx)
	while (table ~= nil) do
		if (table:getNumChairs() == 1) then
			workerTable = table
					
		end
		tableIdx = tableIdx + 1
		table = om:getTable(tableIdx)
	end
	
	if (workerTable ~= nil) then
		workerTable:setReserved(true)
		workerTable:removeHighlight()
	
	else
		warn("restaurant2:onLevelInited - could not find worker table")	
	
	end
	
	if (getProduct("CANDY_CAKE")) or (getProduct("CANDY_COOKIE")) then
		local oven = getAppliance("rest2_candy_oven")
		oven:createHighlight()
	end
	
	if (entertainer ~= nil) then
		entertainer:setAppearance("CHOCO")
	
	end

end

function restaurant2:onLevelInited()

	local dayIndex = player:getCurrentDayIndex()
	local object = nil
	
	-- check for some locked shizzle
	if (um:isProductLocked(dayIndex, "LEMONADE")) then
		object = getObject("rest2_lemonade")
		if (object ~= nil) then
			object:setVisible(false)
		end
	end
	
	if (um:isProductLocked(dayIndex, "CHOC_MILK")) then
		object = getObject("rest2_choc_milk")
		if (object ~= nil) then
			object:setVisible(false)
		end
	end
	
	if (um:isProductLocked(dayIndex, "APPLE")) then
		object = getObject("rest2_apple_stove")
		if (object ~= nil) then
			object:setVisible(false)
		end
	end
	
end

function restaurant2:createObject(desc)

	if (desc:getType() == "GumballMachine") then
		result = gumballMachine()
		result:setType(desc:getType())
		return result
	
	elseif (desc:getType() == "CandyJars") then
		result = candyJars()
		result:setType(desc:getType())
		return result
	
	elseif (desc:getType() == "CandyOven") then
		result = candyOven()
		result:setType(desc:getType())
		return result
		
	end
	
	return nil
end

function restaurant2:createPerson(class)

	if (class == "cleaner") then
		c = charles("INGAME_PERSON_CHARLES")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c:setButtX(20)
		c.clean = (player:getCurrentDayIndex() >= 3)
		return c	
		
	end

end

function restaurant2:createProduct(base)

	bubbleAppleX = 390
	bubbleAppleY = 555
	bubbleAppleS = true
	candyMaxStock = 3
	ovenStartStock = 3
	ovenMaxStock = 3

	if (type(base) == "string")	then
	
		if (base == "LEMONADE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_POUR_FLUID")
			return p
			
		elseif (base == "CHOC_MILK") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_POUR_FLUID")
			return p
			
		elseif (base == "APPLE") then
			p = regularProduct(base)
			p:setBubbleX(bubbleAppleX)
			p:setBubbleY(bubbleAppleY)
			p:setBubbleSmall(bubbleAppleS)
			p:setWorkOffsetX(0)
			p:setWorkTime(0)
			p:setWorkAnimation("WORK_FRONT")
			return p
			
		elseif (base == "RED_SAUCE") then
			p = regularProduct(base)
			p:setBubbleX(bubbleAppleX)
			p:setBubbleY(bubbleAppleY)
			p:setBubbleSmall(bubbleAppleS)
			p:setWorkOffsetX(3)
			p:setWorkTime(400)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_ICECREAM")
			return p
			
		elseif (base == "CARAMEL_SAUCE") then
			p = regularProduct(base)
			p:setBubbleX(bubbleAppleX)
			p:setBubbleY(bubbleAppleY)
			p:setBubbleSmall(bubbleAppleS)
			p:setWorkOffsetX(7)
			p:setWorkTime(400)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_ICECREAM")
			return p
			
		elseif (base == "MARSHMELLOWS") then
			p = regularProduct(base)
			p:setBubbleX(bubbleAppleX)
			p:setBubbleY(bubbleAppleY)
			p:setBubbleSmall(bubbleAppleS)
			p:setWorkOffsetX(10)
			p:setWorkTime(400)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_ADD_PEPPER_SALT")
			return p
			
		elseif (base == "NUTS") then
			p = regularProduct(base)
			p:setBubbleX(bubbleAppleX)
			p:setBubbleY(bubbleAppleY)
			p:setBubbleSmall(bubbleAppleS)
			p:setWorkOffsetX(13)
			p:setWorkTime(400)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_ADD_PEPPER_SALT")
			return p
			
		-- candy jars
		elseif (base == "CANDY_CANE") then
			p = candyjarProduct(base)
			p:setStock(candyMaxStock)
			p:setMaxStock(candyMaxStock)
			p:setWorkOffsetX(-2)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GUMBALL_INBAG_OLD")
			p.fillSound = "SOUND_CANDY_REFILL0"
			return p
			
		elseif (base == "CHOCOLATE") then
			p = candyjarProduct(base)
			p:setStock(candyMaxStock)
			p:setMaxStock(candyMaxStock)
			p:setWorkOffsetX(-2)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GUMBALL_INBAG_OLD")
			p.fillSound = "SOUND_CANDY_REFILL2"
			return p
			
		elseif (base == "LOLLIPOP") then
			p = candyjarProduct(base)
			p:setStock(candyMaxStock)
			p:setMaxStock(candyMaxStock)
			p:setWorkOffsetX(-2)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GUMBALL_INBAG_OLD")
			p.fillSound = "SOUND_CANDY_REFILL1"
			return p
		
		elseif (base == "CANDY_KEY") then
			p = candyjarProduct(base)
			p:setStock(candyMaxStock)
			p:setMaxStock(candyMaxStock)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GUMBALL_INBAG_OLD")
			p.fillSound = "SOUND_CANDY_REFILL2"
			return p
			
		elseif (base == "TOFFEE") then
			p = candyjarProduct(base)
			p:setStock(candyMaxStock)
			p:setMaxStock(candyMaxStock)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GUMBALL_INBAG_OLD")
			p.fillSound = "SOUND_CANDY_REFILL0"
			return p
			
		elseif (base == "MINT_CANDY") then
			p = candyjarProduct(base)
			p:setStock(candyMaxStock)
			p:setMaxStock(candyMaxStock)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GUMBALL_INBAG_OLD")
			p.fillSound = "SOUND_CANDY_REFILL1"
			return p
			
		elseif (base == "LITTLE_CAKE") then
			p = candyjarProduct(base)
			p:setStock(candyMaxStock)
			p:setMaxStock(candyMaxStock)
			p:setWorkOffsetX(3)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GUMBALL_INBAG_OLD")
			p.fillSound = "SOUND_CANDY_REFILL1"
			return p
			
		elseif (base == "TUMTUM") then
			p = candyjarProduct(base)
			p:setStock(candyMaxStock)
			p:setMaxStock(candyMaxStock)
			p:setWorkOffsetX(3)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GUMBALL_INBAG_OLD")
			p.fillSound = "SOUND_CANDY_REFILL0"
			return p
			
		elseif (base == "SUGAR_HEART") then
			p = candyjarProduct(base)
			p:setStock(candyMaxStock)
			p:setMaxStock(candyMaxStock)
			p:setWorkOffsetX(3)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GUMBALL_INBAG_OLD")
			p.fillSound = "SOUND_CANDY_REFILL2"
			return p
			
		elseif (base == "GUMBALL_BAG") then
			p = gumballProduct(base)
			p:setWorkTime(400)
			p:setWorkAnimation("WORK_RIGHT")
			p:setWorkSound("SOUND_GUMBALL_INBAG_OLD")
			return p
			
		elseif (base == "CANDY_CAKE") then
			p = candyOvenProduct(base)
			p:setWorkTime(400)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GETCOOKIE")
			p:setStock(ovenStartStock)
			p:setMaxStock(ovenMaxStock)
			return p
			
		elseif (base == "CANDY_COOKIE") then
			p = candyOvenProduct(base)
			p:setWorkTime(400)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GETCOOKIE")
			p:setStock(ovenStartStock)
			p:setMaxStock(ovenMaxStock)
			return p
			
		end
		
	elseif (type(base) == "userdata") then
		if (base:getBase() == "CANDY_CAKE" or base:getBase() == "CANDY_COOKIE") then
			p = candyOvenProduct(base:getBase())
			p:setWorkTime(400)
			p:setWorkAnimation("WORK")
			return p
		
		end
	
	end
	
	return nil
	
end

function restaurant2:onClickTable(table)

	if (table:getNumChairs() == 1) then
		if (cleaner) then
			if (cleaner:isSitting()) then
				workerTable:standUp(cleaner)
		
			end
	
			cleaner:qWorkOn(getAppliance("rest2_candy_jars"))
			
			return true
			
		end	
	end
	
	return false

end

function restaurant2:onNotify(notification)

	if (cleaner) then
		if (notification == "chas_look") then
			cleaner:setLooking(true)
		elseif (notification == "chas_idle") then
			cleaner:setLooking(false)
		end
	end
	
end

-- set restaurant
restaurant = restaurant2()