-- set event

-- day class
class 'day0' (interface)

function day0:__init() super()
end

function day0:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	-- charlie
    cleaner:setPosition(grid:getNode(6, 23))
    cleaner:setReturnHome(false)
    cleaner:animate("SWEEP", -1, 8)
    
	-- emily    
    emily:setPosition(movieNode)
    
    -- show the movie bar non-animated
	scene:showBars(false)
	
	-- start movie sequence
	local startSequence =
    {
    	{ "scene",		"qStartMovie" 									},
    	{ "",			"sequential" 									},
    	{ "cleaner",	"qSetWalkTimePerNode", 120						},
    	{ "cleaner",	"qWait",			1000						},
    	{ "cleaner",	"qWalkToXY",		13, 21						},
    	{ "cleaner",	"qAnimate",			"SWEEP_STARTUP", 1, false, -1, true },
    	{ "cleaner",	"qWait",			200							},
    	{ "cleaner",	"qAnimate",			"SWEEP", -1, 8				},
    	{ "cleaner",	"qWait",			1500						},
    	{ "cleaner",	"qWalkToXY",		19, 25						},
    	{ "cleaner",	"qAnimate",			"SWEEP_STARTUP", 1, false, -1, true },
    	{ "cleaner",	"qWait",			200							},    	
    	{ "cleaner",	"qAnimate",			"SWEEP", -1, 8				},
    	{ "cleaner",	"qWait",			1000						},
    	{ "cleaner",	"qWalkToXY",		24, 22						},
    	{ "cleaner",	"qAnimate",			"SWEEP_STARTUP", 1, false, -1, true },
    	{ "cleaner",	"qWait",			200							},    	
    	{ "cleaner",	"qAnimate",			"SWEEP", -1, 8				},
    	{ "cleaner",	"qWait",			750							},
    	{ "",			"parallel"										},
    	{ "cleaner",	"qWalkToXY",		30, 23						},
    	{ "cleaner",	"qAnimate",			"SWEEP_STARTUP", 1, false, -1, true },
    	{ "cleaner",	"qWait",			200							},    	
    	{ "cleaner",	"qAnimate",			"SWEEP", -1, 8				},
    	{ "emily",		"qSetAppearance",	"RUN"						},
    	{ "emily",		"qSetWalkTimePerNode", 35						},
    	{ "emily",		"qWalkToXY",		26, 23						},
    	{ "emily",		"qSetAppearance",	"NEUTRAL"					},
    	{ "emily",		"qSay",				"WAITSTOP"					},
    	{ "",			"sequential"									},
    	{ "cleaner",	"qAnimate",			"IDLE_SAD", 0				},
    	{ "cleaner",	"qSay",				"NOUSE"						},
    	{ "emily",		"qSetAppearance",	"HAPPY"						},
    	{ "emily",		"qSay",				"HELPOUT"					},
    	{ "cleaner",	"qAnimate",	"IDLE", 0							},
    	{ "cleaner",	"qSay",				"HMMM"						},
    	{ "emily",		"qSetAppearance",	"NEUTRAL"					},
    	{ "cleaner",	"qSay",				"DONTLOOKLIKEMUCH"			},
    	{ "cleaner",	"qSay",				"WILLDO"					},
    	{ "emily",		"qSetAppearance",	"OFFENDED"					},
    	{ "emily",		"qSay",				"THANKS"					},
    	{ "emily",		"qSetAppearance",	"NEUTRAL"					},
    	{ "cleaner",	"qSay",				"RUNNINGCOUNTER"			},
    	{ "cleaner",	"qSetAppearance",	"ANNOYED"					},
    	{ "cleaner",	"qSay",				"REPEAT"					},
    	{ "emily",		"qSetAppearance",	""							},
    	{ "emily",		"qSay",				"NONEED"					},
    	{ "cleaner",	"qSetAppearance",	""							},
    	{ "cleaner",	"qSay",				"DONTBELATE"				},
    	{ "emily",		"qSetAppearance",	"NEUTRAL"					},
    	{ "emily",		"qSay",				"REGRET"					},
    	{ "emily",		"qSetAppearance",	""							},
    	
    	{ "",			"parallel" 										},
    	{ "cleaner",	"qSetWalkTimePerNode", 70						},
    	{ "emily",		"qSetWalkTimePerNode", 70						},
    	{ "emily",		"qWalkToNode",		movieNode					},
    	{ "cleaner",	"qWait",			1000						},
    	{ "cleaner",	"qWalkToNode",		movieNode					},
    	{ "",			"sequential" 									},
    	{ "scene",		"qFadeToBlack" 									},
    	
    	{ "emily",		"qSetPosition",		exitNode					},
    	{ "cleaner",	"qSetPosition",		exitNode					},
    	{ "emily",		"qNotify",			"remove boards"				},
    	
    	{ "scene",		"qFinishMovie" 									},
    	{ "scene",		"qFadeOutBlack" 								},
    	{ "scene",		"qStartGame" 									},
    	{ "cleaner",	"qWalkToNode",		cleaner:getHomeNode()		},
    	{ "cleaner",	"qSetReturnHome",	true						},
    	{ "emily",		"qWait",			300							},
    	{ "emily",		"qWalkToNode",		grid:getCounterNode()		},    	
    }
    
    qSequence(startSequence)

end

function day0:onNotify(message)
	if (message == "remove boards") then
		self:removeBoards()
	end
end

function day0:removeBoards()
	local window = getObject("rest2_boarded_window_r")
	if (window ~= nil) then
		window:setVisible(false)
	end
	
	window = getObject("rest2_boarded_window_l")
	if (window ~= nil) then
		window:setVisible(false)
	end
end

-- set day
day = day0()