include("scripts/events/npcchaseevent.lua")

-- set event
event = npcChaseEvent()
-- day class
class 'day1' (interface)

day1.twinOne = nil
day1.twinTwo = nil
day1.mother = nil
day1.numCaught = 0

function day1:__init() super()
end

function day1:onLevelGlobals()

	self.twin1 = pm:createPerson("chaseTwin")
	self.twin2 = pm:createPerson("chaseTwin")
	self.mother = pm:createPerson("npc")
	self.mother:setBaseName("INGAME_CUSTOMER_FEMALE_FARMER")
	self.mother:setDefaultSection("customers")
    self.mother:setDefaultFrameRate(10)
    self.mother:setPosition(exitNode)
    
    self.twin1.coordinates = 
		{
			{  2, 21,  2, 21, "CAUGHT_KID" },
			{ 23, 12, 23, 12, "CAUGHT_KID" },
			{ 10, 20, 10, 20, "CAUGHT_KID" },
			{ 16, 31, 16, 31, "CAUGHT_KID" },
		}
		
	self.twin2.coordinates = 
		{
			{ 44, 23, 44, 23, "CAUGHT_KID" },
			{ 17, 27, 17, 27, "CAUGHT_KID" },
			{ 35, 11, 35, 11, "CAUGHT_KID" },
			{ 15, 23, 15, 23, "CAUGHT_KID" },
		}
		
	self.twin1.arrivalAnim = "HYPER"
	self.twin2.arrivalAnim = "HYPER"
	
	self.twin1.visibleWhenCaught = false
	self.twin2.visibleWhenCaught = false
		
	self.twin1.sequenceCaught = 
	{
		{ "emily",		"qAnimate",			"CAUGHT_KID", 0 },
		{ "scene",		"qStartMovie" 						},
		{ "",			"sequential"						},
		{ "mother",		"qWalkToXY",		16, 32			},
		{ "mother",		"qAnimate",			"WALK_UP", 0	},
		{ "mother",		"qWait",			1000			},
		{ "",			"parallel"							},
		{ "emily",		"qAnimate",			"IDLE", 0		},
		{ "twin1",		"qSetVisible",		true			},
		{ "twin1",		"qAnimate",			"IDLE", 0		},
		{ "mother",		"qAnimate",			"IDLE", 0		},
		{ "mother",		"qWalkToXY",		29, 22			},
		{ "twin1",		"qWalkToXY",		26, 22			},
		{ "",			"sequential"						},
		{ "scene",		"qNotify", 			"final catch"	},
		{ "scene",		"qFinishMovie"						},
	}
	
	self.twin2.sequenceCaught = 
	{
		{ "emily",		"qAnimate",			"CAUGHT_KID", 0 },
		{ "scene",		"qStartMovie" 						},
		{ "",			"sequential"						},
		{ "mother",		"qWalkToXY",		15, 24			},
		{ "mother",		"qAnimate",			"WALK_UP", 0	},
		{ "mother",		"qWait",			1000			},
		{ "",			"parallel"							},
		{ "emily",		"qAnimate",			"IDLE", 0		},
		{ "twin2",		"qSetVisible",		true			},
		{ "twin2",		"qAnimate",			"IDLE", 0		},
		{ "mother",		"qAnimate",			"IDLE", 0		},
		{ "mother",		"qWalkToXY",		29, 22			},
		{ "twin2",		"qWalkToXY",		32, 22			},
		{ "",			"sequential"						},
		{ "scene",		"qNotify", 			"final catch"	},
		{ "scene",		"qFinishMovie"						},
	}
	
	event:addChaseNpc(self.twin1)
	event:addChaseNpc(self.twin2)
	
	event.timeUntilEnterMin = 40 * 1000
	event.timeUntilEnterMax = 45 * 1000

	event.scoreGotOne = 25
	event.scoreGotAll = 50
	event.timerReturn = 1000 * 8
	event.actionDuration = 1000 * 1
	event.caughtSounds = {"SOUND_GIRL_GIGGLE0", "SOUND_GIRL_GIGGLE1"}
	
	event.sequenceStart = 
	{
		{ "scene",		"qStartMovie" 									},
    	{ "",			"parallel" 										},
    	{ "twin1",		"qWalkToXY",		26, 22						},
    	{ "twin2",		"qWait",			750							},
    	{ "twin2",		"qWalkToXY",		32, 22						},
    	{ "",			"sequential" 									},
    	{ "twin1",		"qCreateOverhead",	"INGAME_THINK_ICON"			},
    	{ "twin2",		"qCreateOverhead",	"INGAME_THINK_ICON"			},
    	{ "twin1",		"qWait",			1000						},
    	{ "twin1",		"qClearOverhead"								},
    	{ "twin2",		"qClearOverhead"								},
    	{ "twin1",		"qWait",			750							},
    	{ "scene",		"qNotify",			"order blue"				},
    	
    	{ "emily",		"qWalkToXY",		7, 10						},
    	{ "emily",		"qAnimate",			"WORK", -1					},
    	{ "emily",		"qWait",			2000						},
    	{ "emily",		"qAnimate",			"IDLE", 0					},
    	{ "emily",		"qWalkToXY",		26, 23						},
    	{ "emily",		"qAnimate",			"WORK_UP", -1				},
    	{ "emily",		"qWait",			1000						},
    	{ "scene",		"qNotify",			"twin1 order"				},
    	{ "emily",		"qWalkToXY",		32, 23						},
    	{ "emily",		"qAnimate",			"WORK_UP", -1				},
    	{ "emily",		"qWait",			1000						},
    	{ "scene",		"qNotify",			"twin2 order"				},
    	{ "emily",		"qAnimate",			"IDLE", 0					},
    	
    	{ "mother",		"qSetPosition",		movieNode					},
    	{ "mother",		"qSetAppearance",	"RUN"						},
    	{ "",			"parallel" 										},
    	{ "mother",		"qSetWalkTimePerNode", 35						},
    	{ "mother",		"qWalkToXY",		29, 22						},
    	{ "mother",		"qSetAppearance",	"CONCERNED"					},
    	{ "mother",		"qSay",				"RESTAURANT2_DAY1_0"		},
    	{ "emily",		"qWalkToNode",		grid:getCounterNode()		},
    	{ "",			"sequential" 									},
    	{ "mother",		"qSay",				"RESTAURANT2_DAY1_1"		},
    	{ "mother",		"qSetWalkTimePerNode", 70						},
    	
    	{ "",			"parallel" 										},
    	{ "twin1",		"qWalkToXY",		20, 22						},
    	{ "twin2",		"qWalkToXY",		37, 22						},
    	{ "twin1",		"qAnimate",			"HYPER", -1					},
    	{ "twin2",		"qAnimate",			"HYPER", -1					},
    	
    	{ "",			"sequential" 									},
    	{ "emily",		"qSetAppearance",	"SURPRISED"					},
    	{ "emily",		"qSay",				"RESTAURANT2_DAY1_2"		},
    	{ "mother",		"qSay",				"RESTAURANT2_DAY1_3"		},
    	{ "mother",		"qSay",				"RESTAURANT2_DAY1_4"		},
    	
    	{ "emily",		"qSetAppearance",	""							},
    	{ "scene",		"qFinishMovie" 									},
    	{ "scene",		"qNotify",			"chase start"				},
	}
	
	event.sequenceLose = 
	{
		{ "scene",		"qStartMovie" 									},
    	{ "",			"sequential" 									},
    	{ "twin1",		"qSetAppearance",	""							},
    	{ "twin1",		"qAnimate",			"IDLE", 0					},
    	{ "twin2",		"qSetAppearance",	""							},
    	{ "twin2",		"qAnimate",			"IDLE", 0					},
    	{ "mother",		"qWalkToXY",		28, 22						},
    	{ "mother",		"qSay",				"RESTAURANT2_DAY1_10"		},
    	{ "mother",		"qSay",				"RESTAURANT2_DAY1_11"		},
    	
    	{ "",			"parallel" 										},
    	{ "mother",		"qWalkToNode",		exitNode					},
    	{ "twin1",		"qWait",			500							},
    	{ "twin1",		"qWalkToNode",		exitNode					},
    	{ "twin2",		"qWait",			750							},
    	{ "twin2",		"qWalkToNode",		exitNode					},
    	{ "mother",		"qSetVisible",		false						},
    	{ "twin1",		"qSetVisible",		false						},
    	{ "twin2",		"qSetVisible",		false						},
    	{ "",			"sequential" 									},
    	
    	{ "scene",		"qFinishMovie" 									},
	}
	
	event.sequenceWin = 
	{
		{ "scene",		"qStartMovie" 									},
		{ "",			"parallel" 										},
		{ "mother",		"qSetAppearance",	"HAPPY"						},
    	{ "mother",		"qWalkToXY",		29, 22						},
    	{ "twin1",		"qWalkToXY",		26, 22						},
    	{ "twin2",		"qWalkToXY",		32, 22						},
    	{ "mother",		"qSay",				"RESTAURANT2_DAY1_20"		},
    	{ "emily",		"qWalkToXY",		22, 22						},
    	{ "",			"sequential" 									},
    	{ "emily",		"qSetAppearance",	"BLUSH"						},
    	{ "emily",		"qSay",				"RESTAURANT2_DAY1_21"		},
    	{ "mother",		"qSay",				"RESTAURANT2_DAY1_22"		},
    	{ "",			"parallel" 										},
    	{ "mother",		"qWalkToNode",		exitNode					},
    	{ "twin1",		"qWait",			500							},
    	{ "twin1",		"qWalkToNode",		exitNode					},
    	{ "twin2",		"qWait",			750							},
    	{ "twin2",		"qWalkToNode",		exitNode					},
    	{ "mother",		"qSetVisible",		false						},
    	{ "twin1",		"qSetVisible",		false						},
    	{ "twin2",		"qSetVisible",		false						},
    	{ "",			"sequential" 									},
    	{ "emily",		"qSetAppearance",	""							},
    	
    	{ "scene",		"qFinishMovie" 									},
	}
	
end

function day1:onNotify(notification)
	if (notification == "order blue") then
		local order = self:createBlueOrder()
		order:setX(-32)
		order:setY(-140)
		order:popIn()
		self.twin1:addExtraChild(order)
		order = self:createBlueOrder()
		order:setX(-32)
		order:setY(-140)
		order:popIn()
		self.twin2:addExtraChild(order)
	
	elseif (notification == "twin1 order") then
		self.twin1:removeExtraChild()
	
	elseif (notification == "twin2 order") then
		self.twin2:removeExtraChild()
		
	elseif (notification == "final catch") then
		self.numCaught = self.numCaught + 1
		if (self.numCaught < 2) then
			-- do nothing
		else
			self.mother:setAppearance("HAPPY")
		end
		
	elseif (notification == "kill them") then
		if (self.mother ~= nil) then
			self.mother:setPosition(exitNode)
			self.mother:setDestroyed(true)
		end
		
		if (self.twin1 ~= nil) then
			self.twin1:setPosition(exitNode)
			self.twin1:setDestroyed(true)
		end
		
		if (self.twin2 ~= nil) then
			self.twin2:setPosition(exitNode)
			self.twin2:setDestroyed(true)
		end

	end
end

function day1:createBlueOrder()
	
	result = createOrder()
	result:addProduct("TUMTUM")
	result:setPivotPointType(BOTTOMCENTER)
	
	return result
	
end

function day1:createPerson(class)

	local result = nil
	if (class == "chaseTwin") then
		result = chaseNpc("INGAME_CUSTOMER_FEMALE_TWIN")
		result:setType(class)
		result:setDefaultSection("customers")
		result:setAppearance("RUN")
	end
	
	return result
end

-- set day
day = day1()
