-- day class
class 'day2' (interface)

day2.yardsTotal = 1000	-- textual number (gui / dialogs)
day2.nodesTotal = 4025	-- internal number 
day2.sequenceStart = nil
day2.sequenceWin = nil
day2.sequenceFinish = nil
day2.nodesLeft = 0
day2.started = false
day2.completed = false
day2.score = 100

function day2:__init() super()
end

function day2:onLevelInited()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	self.nodesLeft = self.nodesTotal
	
	francois = pm:createPerson("francois")
	francois:setPosition(grid:getNode(39, 28))
	emily:setPosition(grid:getNode(43, 28))
	cleaner:setPosition(cleaner:getHomeNode())
	workerTable:sitDown(cleaner, 0)
	cleaner:animate("WORK", -1)

	self.sequenceStart =
	{
		{ "scene",		"qStartMovie" 											},
		{ "francois",	"qSay",						"RESTAURANT2_DAY2_0"		},
		{ "emily",		"qSay",						"RESTAURANT2_DAY2_1"		},
		{ "cleaner",	"qNotify",					"chas_look"					},
		{ "cleaner",	"qSay",						"RESTAURANT2_DAY2_2"		},
		{ "emily",		"qSetAppearance",			"OFFENDED"					},
		{ "emily",		"qWait",					750							},
		{ "cleaner",	"qNotify",					"chas_idle"					},
		{ "francois",	"qSetAppearance",			"HAPPY"						},
		{ "francois",	"qSay",						"RESTAURANT2_DAY2_3"		},
		{ "emily",		"qSay",						"RESTAURANT2_DAY2_4"		},
		{ "cleaner",	"qNotify",					"chas_look"					},
		{ "cleaner",	"qSay",						"RESTAURANT2_DAY2_5"		},
		{ "cleaner",	"qNotify",					"chas_idle"					},
		{ "cleaner",	"qWalkToXY",				41, 24						},
		{ "cleaner",	"qSay",						"RESTAURANT2_DAY2_6"		},
		{ "emily",		"qSay",						"RESTAURANT2_DAY2_7"		},
		{ "emily",		"qSetAppearance",			"BLUSH"						},
		{ "emily",		"qSay",						"RESTAURANT2_DAY2_8"		},
		{ "francois",	"qAnimate",					"LAUGH", -1, 8				},
		{ "francois",	"qWait",					750							},
		{ "francois",	"qAnimate",					"IDLE", 0					},				
		{ "francois",	"qSay",						"RESTAURANT2_DAY2_9"		},
		{ "emily",		"qSetAppearance",			""							},
		{ "francois",	"qWalkToNode",				movieNode					},
		{ "francois",	"qDestroy",					"francois"					},		
		{ "",			"parallel"												},
		{ "emily",		"qWalkToNode",				grid:getCounterNode()		},
		{ "cleaner",	"qSit",						workerTable					},
		{ "cleaner",	"qAnimate",					"WORK", -1					},
		{ "",			"sequential"											},
		{ "scene",		"qFinishMovie" 											},
		{ "scene",		"qStartGame" 											},	
	}
	self.sequenceWin =
	{
		{ "scene",		"qStartMovie" 											},
		{ "emily",		"qWalkToNode",				grid:getCounterNode()		},
		{ "emily",		"qAnimate",					"JUMP", 1					},
		{ "emily",		"qWait",					500							},
		{ "emily",		"qAnimate",					"IDLE", 0					},		
		{ "emily",		"qSay",						"RESTAURANT2_DAY2_20"		},
		{ "cleaner",	"qWalkToXY",				20, 32						},
		{ "cleaner",	"qSay",						"RESTAURANT2_DAY2_21"		},
		{ "emily",		"qSetAppearance",			"OFFENDED"					},
		{ "emily",		"qSay",						"RESTAURANT2_DAY2_22"		},
		{ "cleaner",	"qAnimate",					"LAUGH", -1, 8				},
		{ "cleaner",	"qWait",					750							},
		{ "cleaner",	"qAnimate",					"IDLE", 0					},		
		{ "cleaner",	"qSay",						"RESTAURANT2_DAY2_23"		},
		{ "cleaner",	"qSit",						workerTable					},
		{ "cleaner",	"qAnimate",					"WORK", -1					},
		{ "emily",		"qSetAppearance",			""							},
		{ "scene",		"qFinishMovie" 											},
	}
	self.sequenceFinish =
	{
		{ "scene",		"qStartMovie" 											},
		{ "emily",		"qWalkToNode",				grid:getCounterNode()		},
		{ "cleaner",	"qWalkToXY",				20, 32						},
		{ "cleaner",	"qSay",						"RESTAURANT2_DAY2_30"		},
		{ "cleaner",	"qSay",						"RESTAURANT2_DAY2_31"		},
		{ "emily",		"qSay",						"RESTAURANT2_DAY2_32"		},
		{ "cleaner",	"qSay",						"RESTAURANT2_DAY2_33"		},
		{ "",			"parallel"												},
		{ "cleaner",	"qWalkToNode",				exitNode					},
		{ "emily",		"qWalkToNode",				exitNode					},
		{ "",			"sequential"											},
		{ "scene",		"qFinishMovie" 											},
		{ "scene",		"qFinishGame"											},
	}	
	
	-- start sequence
	qSequence(self.sequenceStart)
	
end

function day2:onDayBegin()

	eventBar:setSubjectImage("OBJECT_SHOE_BAR", player:getCurrentResourceSection())
	eventBar:setDescriptionText(getText("EVENTBAR"))
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(self.yardsTotal)
	eventBar:setProgress(0)	
	eventBar:animateToActive()
	eventBar:raiseCurtain()
	self.started = true

end

function day2:onDayEnd()

	autoAllPeopleWalkOut = false
	qSequence(self.sequenceFinish)

end

function day2:onLockToNode(actor, node)

	if (self.started and not self.completed) then
		if (actor:getType() == "emily") then
			self.nodesLeft = self.nodesLeft - 1
			
			local progress = 1 - (self.nodesLeft / self.nodesTotal)
			eventBar:setProgress(progress * self.yardsTotal)
			
			if (self.nodesLeft == 0) then
				eventBar:animateToDeactive()
				emily:playSound("SOUND_EVENT_COMPLETE_ALL")
				incScore(self.score, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)
				qInsertSequence(self.sequenceWin)
				self.completed = true
			
			end	
		end
	end
	
end

-- set day
day = day2()