include("scripts/events/mailmanevent.lua")

-- set event
event = mailmanEvent()

-- day class
class 'day3' (interface)

-- local dummy mailman for the intro sequence
day3.dummyPostman = nil

function day3:__init() super()
end

function day3:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- create dummy postman for intro scene
    self.dummyPostman = pm:createPerson("dummyMailman")
    
    -- and Matthew for the outro
    matthew = pm:createPerson("npc")
    matthew:setBaseName("INGAME_PERSON_MATTHEW")
    matthew:setPosition(exitNode)
    
	-- set event configuration
	event.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"
	event.timeUntilEnterMin = 20000
	event.timeUntilEnterMax = 24000
	event.timeUntilAngry = 6000
	event.timeUntilLeave = 3000
	event.numPackages = 12
	event.entryX = entryX
	event.entryY = entryY
	event.waitX = 30
	event.waitY = 23
	event.workX = 26
	event.workY = 23
	event.angryAnim = "IDLE_WAITING"
	event.workAnim = "GIVE_LEFT"
	event.workAnimEmily = "WORK_RIGHT"
	event.scoreGotOne = 25
	event.scoreGotAll = 100
	event.package = "OBJECT_PACKAGE"
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "dummyPostman",	"qSetPosition",		movieNode					},
		{ "dummyPostman",	"qWalkToXY",		30,	23						},
		{ "dummyPostman",	"qSay",				"RESTAURANT2_DAY3_0"		},
		{ "cleaner",		"qStand"										},
		{ "cleaner",		"qSetWalkTimePerNode", 35						},
		{ "cleaner",		"qWalkToXY",		26, 23						},
		--{ "cleaner",		"qAnimate",			"IDLE_ANNOYED", 0			},
		{ "cleaner",		"qSetAppearance",	"ANNOYED"					},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY3_1"		},
		{ "dummyPostman",	"qSay",				"RESTAURANT2_DAY3_2"		},
		{ "cleaner",		"qSetAppearance",	"ANGRY"						},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY3_3"		},
		{ "",				"parallel"										},
		{ "cleaner",		"qSetAppearance",	"ANNOYED"					},
		{ "cleaner",		"qSetWalkTimePerNode", 70						},
		{ "cleaner",		"qWalkToNode",		cleaner:getHomeNode()		},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "emily",			"qWait",			500							},
		{ "emily",			"qWalkToXY",		26, 23						},
		{ "",				"sequential"									},
		{ "emily",			"qSay",				"RESTAURANT2_DAY3_4"		},
		{ "dummyPostman",	"qAnimate",			"GIVE_LEFT", 1, false, -1, true		},
		{ "emily",			"qAnimate",			"WORK_RIGHT", 1, false, -1, true	},
		{ "emily",			"qWait",			750							},
		{ "dummyPostman",	"qNotify",			"not carrying"				},
		{ "dummyPostman",	"qAnimate",			"IDLE", 0					},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY3_5"		},
		{ "dummyPostman",	"qSay",				"RESTAURANT2_DAY3_6"		},
		{ "cleaner",		"qNotify",			"chas_look"					},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY3_7"		},
		{ "cleaner",		"qNotify",			"chas_idle"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY3_8"		},
		{ "dummyPostman",	"qSay",				"RESTAURANT2_DAY3_9"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY3_10"		},
		{ "dummyPostman",	"qWalkToNode",		movieNode					},
		{ "dummyPostman",	"qDestroy",			"day.dummyPostman"			},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									},
	}

	event.sequenceCompleted = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "cleaner",		"qStand"										},
		{ "cleaner",		"qWalkToXY",		30, 23						},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY3_20"		},
		{ "",				"parallel"										},
		{ "cleaner",		"qWalkToNode",		movieNode					},
		{ "cleaner",		"qSetPosition",		exitNode					},
		{ "emily",			"qWait",			750							},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "emily",			"qAnimate",			"WORK", -1					},
		{ "matthew",		"qSetAppearance",	"STOIC"						},
		{ "matthew",		"qWait",			2000						},
		{ "matthew",		"qWalkToXY",		30, 23						},
		{ "",				"sequential"									},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY3_21"		},
		{ "emily",			"qAnimate",			"IDLE", -1					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY3_21"		},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY3_22"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY3_23"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY3_24"		},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY3_25"		},
		{ "matthew",		"qSetAppearance",	"HAPPY"						},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY3_26"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY3_27"		},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY3_28"		},
		{ "",				"parallel"										},
		{ "matthew",		"qWalkToXY",		30, 10						},
		{ "emily",			"qWait",			750							},
		{ "emily",			"qSay",				"RESTAURANT2_DAY3_29"		},
		{ "",				"sequential"									},
		{ "matthew",		"qWalkToXY",		30, 23						},
		{ "matthew",		"qSetAppearance",	"STOIC"						},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY3_30"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY3_31"		},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY3_32"		},
		{ "matthew",		"qWalkToNode",		movieNode					},
		{ "matthew",		"qDestroy"										},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}
	
end

function day3:onLevelInited()
	-- position everyone
    emily:setPosition(grid:getCounterNode())
    cleaner:setPosition(cleaner:getHomeNode())
    workerTable:sitDown(cleaner, 0)
    cleaner:animate("WORK", -1)
end

function day3:createPerson(class)

	local m = nil
	
	if (class == "dummyMailman") then
		m = dummyMailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
		
	end
		
	return m
		
end

function day3:onNotify(message)

	if (message == "not carrying") then
		
		self.dummyPostman.carry = false
		
	end

end

function day3:onDayEnd()

	-- if we have gathered all Matthew's packages, we don't walk out right away
	-- but we do an animation first
	if (event.person.handed > 0) then
		-- prevent walking out
		autoAllPeopleWalkOut = false
		
		-- play completed sequence
		qSequence(event.sequenceCompleted)
	    
	end

end

-- set day
day = day3()


-- a dummy mailman
class 'dummyMailman' (npc)

-- internal variables		
dummyMailman.carry = true

function dummyMailman:__init(baseName) super(baseName)
end

function dummyMailman:onCreate()

	self:animate("IDLE", 0)
	
end

function dummyMailman:calcImageName(input)

	res = D2Person.calcImageName(self, input)
  
	if (self.carry) then
		res = res .. "_CARRY"
	end

	return res
  
end

