-- day class
class 'day4' (interface)

day4.timeUntilEnterMin = 1000 * 90
day4.timeUntilEnterMax = 1000 * 120
day4.timeInterval = 1000 * 15
day4.timeUntilNext = { day4.timeInterval, day4.timeInterval, day4.timeInterval, day4.timeInterval, day4.timeInterval, day4.timeInterval }
day4.timePerProduct = 1000 * 16
day4.timePerAnswer = 1000 * 8
day4.products = 
{ 
	{ "APPLE_CARAMEL_SAUCE_MARSHMELLOWS", "LEMONADE" }, 
	{ "CHOCOLATE", "CANDY_CAKE" },
	{ "CANDY_COOKIE", "CHOC_MILK" }, 
}

day4.sequenceStart = nil
day4.sequenceEnter = nil
day4.sequenceWin = nil
day4.sequenceLose = nil
day4.timer = 0
day4.timerpb = 0
day4.timerpbSuspended = false
day4.timeraq = 0
day4.index = 0
day4.state = "idle"
day4.mood = 0
day4.right = 0
day4.order = nil

function day4:__init() super()
end

function day4:onLevelGlobals()

	interviewer = pm:createPerson("npc")
	interviewer:setBaseName("INGAME_PERSON_SPECIAL_SHOWMASTER")
	interviewer:setType("interviewer")
	interviewer:animate("IDLE", 0)
	interviewer:setButtX(20)
	
	francois = pm:createPerson("francois")
	
	interviewerTable = om:getTable(1)
	interviewerTable:setReserved(true)
	interviewerTable:setOverheadY(interviewerTable:getOverheadY() - 75)
	
	self.order = createOrder()
	self.order:setX(-30)
	self.order:setY(36)		
	self.order:setAnchorPointType(BOTTOMCENTER)
	self.order:setPivotPointType(BOTTOMCENTER)
	self.order:setVisible(false)
	interviewer:addChild(self.order)
	
end

function day4:onLevelInited()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(cleaner:getHomeNode())
	workerTable:sitDown(cleaner, 0)
	cleaner:animate("WORK", -1)

	self.sequenceStart =
	{
		{ "scene",			"qStartMovie" 									},
		{ "francois",		"qSetPosition",		movieNode					},
		{ "francois",		"qSetAppearance",	"MOBILE"					},
		{ "francois",		"qWalkToXY",		20, 28						},
		{ "francois",		"qSay",				"RESTAURANT2_DAY4_0"		},
		{ "emily",			"qWalkToXY",		16, 28						},
		{ "emily",			"qSetAppearance",	"MOBILE",					},
		{ "francois",		"qSetAppearance",	""							},
		{ "emily",			"qSay",				"RESTAURANT2_DAY4_1"						},
		{ "emily", 			"qSayPortrait",		"RESTAURANT2_DAY4_2", "PORTRAIT_BOSS" 		},
		{ "emily", 			"qSayPortrait",		"RESTAURANT2_DAY4_3", "PORTRAIT_BOSS" 		},
		{ "cleaner",		"qNotify",			"chas_look"					},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY4_4"		},
		{ "cleaner",		"qNotify",			"chas_idle"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY4_5"						},
		{ "emily", 			"qSayPortrait",		"RESTAURANT2_DAY4_6", "PORTRAIT_BOSS" 		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY4_7"						},
		{ "",				"parallel"										},
		{ "emily", 			"qSayPortrait",		"RESTAURANT2_DAY4_8", "PORTRAIT_BOSS" 		},
		{ "cleaner",		"qNotify",			"chas_look"					},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY4_8"		},
		{ "cleaner",		"qNotify",			"chas_idle"					},
		{ "",				"sequential"									},
		{ "emily", 			"qSayPortrait",		"RESTAURANT2_DAY4_9", "PORTRAIT_BOSS" 		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY4_10"						},
		{ "emily", 			"qSayPortrait",		"RESTAURANT2_DAY4_11","PORTRAIT_BOSS" 		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY4_12"						},
		{ "emily",			"qSetAppearance",	"",							},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "francois",		"qWalkToNode",		movieNode					},
		{ "francois",		"qDestroy",			"francois"					},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									},			
	}
	
	self.sequenceEnter =
	{
		{ "scene",			"qStartMovie" 									},	
		{ "interviewer",	"qSetPosition",		movieNode					},
		{ "interviewer",	"qWalkToXY",		31, 20						},
		{ "interviewer",	"qSay",				"RESTAURANT2_DAY4_20"		},	
		{ "emily",			"qWalkToXY",		27, 20						},
		{ "emily",			"qSetAppearance",	"HAPPY"						},
		{ "emily",			"qSay",				"RESTAURANT2_DAY4_21"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "interviewer",	"qSay",				"RESTAURANT2_DAY4_22"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY4_23"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY4_24"		},
		{ "interviewer",	"qSay",				"RESTAURANT2_DAY4_25"		},
		{ "interviewer",	"qSitAt",			interviewerTable, 1			},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qNotify",			"next question"				},
	}
	
	self.sequenceWin =
	{
		{ "scene",			"qStartMovie" 									},	
		{ "interviewer",	"qWalkToXY",		31, 20						},
		{ "emily",			"qWalkToXY",		27, 20						},
		{ "interviewer",	"qSay",				"RESTAURANT2_DAY4_40"		},	
		{ "emily",			"qSay",				"RESTAURANT2_DAY4_41"		},
		{ "interviewer",	"qWalkToNode",		movieNode					},
		{ "interviewer",	"qDestroy",			"interviewer"				},
		{ "scene",			"qFinishMovie" 									},
	}
	
	self.sequenceLose =
	{
		{ "scene",			"qStartMovie" 									},	
		{ "interviewer",	"qWalkToXY",		31, 20						},
		{ "emily",			"qWalkToXY",		27, 20						},
		{ "interviewer",	"qSay",				"RESTAURANT2_DAY4_42"		},
		{ "interviewer",	"qSay",				"RESTAURANT2_DAY4_43"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY4_44"		},
		{ "interviewer",	"qWalkToNode",		movieNode					},
		{ "interviewer",	"qDestroy",			"interviewer"				},
		{ "scene",			"qFinishMovie" 									},	
	}

	qSequence(self.sequenceStart)

end

function day4:onDayBegin()

	self.timer = getRandomRange(self.timeUntilEnterMin, self.timeUntilEnterMax)

end

function day4:onNotify(notification)

	if (notification == "next question") then
		self:gotoNext()
	
	elseif (notification == "correct") then
		self:onCorrect()
	
	elseif (notification == "incorrect") then
		self:onIncorrect()
	
	end

end

function day4:onCorrect()

	emily:qPlaySound("SOUND_EVENT_COMPLETE_ITEM")
	scene:qFinishMovie()
	self.right = self.right + 1
	self:changeMood(1)
	incScore(50, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)
	eventBar:setProgress(self.right)

end

function day4:onIncorrect()

	emily:qPlaySound("SOUND_EVENT_BAD")
	scene:qFinishMovie()
	self:changeMood(-1)

end

function day4:onClickTable(table)

	if (self.state == "interviewing") then
		if (table:isReserved()) then
			if (self.timerpb > 0) then
				self.timerpbSuspended = true
		
			end	
		end
	end

end

function day4:onTaskComplete(actorType, taskType, p0, p1)

	if (self.state == "interviewing") then
		if (taskType == "TableTask") then
			if (p0:isReserved()) then
				-- the table is reserved
				-- it's the table where the interviewer is sitting on
				if (self.timerpb > 0) then
					local n = tray:distributeProducts(self.order)
					if (n > 0) then
						self.order:draw()
						if (self.order:isCompleted()) then
							self.order:setVisible(false)
							self.timerpb = 0
							self.timerpbSuspended = false
							
							insert()
							emily:qNotify("correct")
							emily:qNotify("next question")
							append()

						end				
					else
						self.timerpbSuspended = false

					end
				end	
			end	
		end
	end

end

function day4:onClickMessage(text, result)
	
	if (text == "RESTAURANT2_DAY4_30") then
		if (result == "yes") then
			-- correct
			insert()
			emily:qNotify("correct")
			emily:qSay("RESTAURANT2_DAY4_31")
			append()
			interviewer:qAnimate("WRITE", -1)
			interviewer:qNotify("next question")
			interviewer:qWait(1000)
			interviewer:qAnimate("IDLE", 0)			
			
		elseif (result == "no") then
			-- incorrect
			insert()
			emily:qNotify("incorrect")
			emily:qSay("RESTAURANT2_DAY4_32")
			append()
			interviewer:qAnimate("WRITE", -1)
			interviewer:qNotify("next question")
			interviewer:qWait(1000)
			interviewer:qAnimate("IDLE", 0)			
			
		end
		
		self.timeraq = 0
		
	elseif (text == "RESTAURANT2_DAY4_33") then
		if (result == "yes") then
			-- incorrect
			insert()
			emily:qNotify("incorrect")
			emily:qSay("RESTAURANT2_DAY4_34")
			append()	
			interviewer:qAnimate("WRITE", -1)
			interviewer:qNotify("next question")
			interviewer:qWait(1000)
			interviewer:qAnimate("IDLE", 0)			
			
		elseif (result == "no") then
			-- correct
			insert()
			emily:qNotify("correct")
			emily:qSay("RESTAURANT2_DAY4_35")
			append()
			interviewer:qAnimate("WRITE", -1)
			interviewer:qNotify("next question")
			interviewer:qWait(1000)
			interviewer:qAnimate("IDLE", 0)			
			
		end
		
		self.timeraq = 0
		
	elseif (text == "RESTAURANT2_DAY4_36") then
		if (result == "yes") then
			-- incorrect
			insert()
			emily:qNotify("incorrect")
			emily:qSay("RESTAURANT2_DAY4_37")
			append()
			interviewer:qAnimate("WRITE", -1)
			interviewer:qNotify("next question")
			interviewer:qWait(1000)
			interviewer:qAnimate("IDLE", 0)			
			
		elseif (result == "no") then
			-- correct		
			insert()
			emily:qNotify("correct")
			emily:qSay("RESTAURANT2_DAY4_38")
			append()			
			interviewer:qAnimate("WRITE", -1)
			interviewer:qNotify("next question")
			interviewer:qWait(1000)
			interviewer:qAnimate("IDLE", 0)			
	
		end
		
		self.timeraq = 0
		
	end
			
end

function day4:onTick(time)

	if (self.state == "idle") then
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				qSequence(self.sequenceEnter)
				self.state = "enter"
						
			end	
		end
		
	elseif (self.state == "enter") then
		-- do nothing
	
	elseif (self.state == "interviewing") then
		if (self.timerpb > 0) then
			if (self.timerpbSuspended == false) then
				self.timerpb = self.timerpb - time
				if (self.timerpb <= 0) then
					self.order:setVisible(false)
					self.timerpb = 0			
					self.timerpbSuspended = false
				
					insert()
					emily:qNotify("incorrect")
					emily:qNotify("next question")
					append()				
								
				end		
			end
		end
		
		--[[
		-- DELIV-135.  Questions shouldn't be timed
		if (self.timeraq > 0) then
			self.timeraq = self.timeraq - time
			if (self.timeraq <= 0) then
				interviewer:finishTask()
				
				insert()
				emily:qNotify("incorrect")
				emily:qNotify("next question")
				append()					
			end		
		end
		--]]
	
		if (self.timer > 0) then
			self.timer = self.timer - time
			
			if ((self.index == 1) or (self.index == 3) or (self.index == 5)) then
    			if (self.timer + time > 3000) then
    			    if (self.timer <= 3000) then
    			       interviewerTable:createOverhead("INGAME_THINK_ICON")
    			        
    			    end			
    			end
    			
    			if (self.timer + time > 650) then
    			    if (self.timer <= 650) then
    			        interviewerTable:clearOverhead()
    			    
    			    end
                end
            end
			
			if (self.timer <= 0) then
				if (self.index == 1) then
					eventBar:raiseCurtain()
					self.order:clear()
					for index, value in ipairs(self.products[1]) do
						self.order:addProduct(value)
					end
					self.order:setVisible(true)
					self.order:setScaleX(0)
					self.order:setScaleY(0)
					self.order:popIn()
					self.timerpb = self.timePerProduct
					self.timerpbSuspended = false
					interviewer:animate("IDLE", 0)
					interviewer:playSound("SOUND_EVENT_ATTENTION")
				
				elseif (self.index == 2) then
					self:askQuestion("RESTAURANT2_DAY4_30")
				
				elseif (self.index == 3) then
					eventBar:raiseCurtain()
					self.order:clear()
					for index, value in ipairs(self.products[2]) do
						self.order:addProduct(value)
					end
					self.order:setVisible(true)
					self.order:setScaleX(0)
					self.order:setScaleY(0)					
					self.order:popIn()
					self.timerpb = self.timePerProduct
					self.timerpbSuspended = false
					interviewer:animate("IDLE", 0)
					interviewer:playSound("SOUND_EVENT_ATTENTION")
				
				elseif (self.index == 4) then
					self:askQuestion("RESTAURANT2_DAY4_33")
				
				elseif (self.index == 5) then
					eventBar:raiseCurtain()
					self.order:clear()
					for index, value in ipairs(self.products[3]) do
						self.order:addProduct(value)
					end
					self.order:setVisible(true)
					self.order:setScaleX(0)
					self.order:setScaleY(0)					
					self.order:popIn()
					self.timerpb = self.timePerProduct
					self.timerpbSuspended = false
					interviewer:animate("IDLE", 0)
					interviewer:playSound("SOUND_EVENT_ATTENTION")
				
				elseif (self.index == 6) then
					self:askQuestion("RESTAURANT2_DAY4_36")
				
				else
					warn("day4:onTick - invalid state")				
				
				end			
			end
		end	
	
	elseif (self.state == "leaving") then
		-- do nothing	
	
	end

end

function day4:askQuestion(textId)
	
	scene:qStartMovie(false)
	eventBar:raiseCurtain()
	interviewer:qSayYesNo(textId)
	self.timeraq = self.timePerAnswer
	
end

function day4:gotoNext()

	self.index = self.index + 1
	
	if (self.index == 1) then
		self.state = "interviewing"
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(table.getn(self.timeUntilNext))
		eventBar:setProgress(0)				
		eventBar:setDescriptionText(getText("EVENTBAR"))
		eventBar:setSubjectImage("OBJECT_INTERVIEWER_BAR", player:getCurrentResourceSection())		
		eventBar:animateToActive()
		
	end
	
	if (self.index > table.getn(self.timeUntilNext)) then
		self.state = "leaving"
		eventBar:animateToDeactive()	
		interviewer:clearOverhead()
		
		if (self.mood == 2) then
			incScore(100, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")
			qInsertSequence(self.sequenceWin)
		
		else
			qInsertSequence(self.sequenceLose)
		
		end	
	else
		self.state = "interviewing"
		eventBar:lowerCurtain()
		
		self.timer = self.timeUntilNext[self.index]
			
	end

end

function day4:changeMood(n)

	self.mood = self.mood + n
	self.mood = math.min(self.mood, 2)
	self.mood = math.max(self.mood, -2)
	
	interviewer:setOverheadX(28)
	interviewer:setOverheadY(65)

	if (self.mood == -2) then
		interviewer:createOverhead("INGAME_THUNDER", "ingame")
	
	elseif (self.mood == -1) then
		interviewer:clearOverhead()
	
	elseif (self.mood == 0) then
		interviewer:clearOverhead()
	
	elseif (self.mood == 1) then
		interviewer:clearOverhead()
	
	elseif (self.mood == 2) then
		interviewer:createOverhead("INGAME_HEART", "ingame")
	
	end

end

-- the day's end story
function day4:onDayEnd()

	-- prevent walking out
	autoAllPeopleWalkOut = false

	francois = pm:createPerson("francois")
	francois:setVisible(false)

	self.endSequence =
	{
		{ "scene",		"qStartMovie"									},
		{ "francois",	"qSetPosition",			movieNode				},
		{ "francois",	"qSetAppearance",		"ECSTATIC"				},
		{ "francois",	"qSetVisible",			true					},
		{ "francois",	"qWalkToXY",			30, 23					},
		{ "francois",	"qSetAppearance",		"HAPPY"					},
		{ "francois",	"qSay",					"RESTAURANT2_DAY5_20"	},
		{ "",			"parallel"										},
		{ "cleaner",	"qSetAppearance",		"ANNOYED"				},
		{ "cleaner",	"qWalkToXY",			26, 23					},
		{ "emily",		"qWalkToXY",			22, 23					},
		{ "",			"sequential"									},
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY5_21"	},
		{ "francois",	"qSetAppearance",		"NEUTRAL"				},
		{ "francois",	"qSay",					"RESTAURANT2_DAY5_5"	},
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY5_22"	},
		{ "francois",	"qSetAppearance",		"BLUSH"					},
		{ "francois",	"qSay",					"RESTAURANT2_DAY5_23"	},
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY5_24"	},
		{ "scene",		"qFadeToBlack" 									},
		{ "francois",	"qSetAppearance",		"CHOCO"					},
		{ "cleaner",	"qSetAppearance",		""						},
		{ "cleaner",	"qWait",				1000					},
		{ "scene",		"qFadeOutBlack"									},
		{ "francois",	"qSay",					"RESTAURANT2_DAY5_25"	},
		{ "emily",		"qAnimate",				"LAUGH", -1, 8			},
		{ "emily",		"qSay",					"RESTAURANT2_DAY5_26"	},
		{ "emily",		"qSetAppearance",		"LAUGH"					},
		{ "emily",		"qAnimate",				"IDLE", 0				},
		{ "cleaner",	"qSetAppearance",		"ANNOYED"				},
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY5_27"	},
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY5_28"	},
		{ "scene",		"qFinishMovie" 									},
		{ "scene",		"qFinishGame" 									},
	}
		
	qSequence(self.endSequence)
	
end

-- set day
day = day4()