include("scripts/events/brokenobjectevent.lua")

-- set event
event = brokenObjectEvent()
event.targetType = "Table4"
event.nrTargets = 2

-- day class
class 'day5' (interface)

day5.endSequence = nil

function day5:__init() super()
end

function day5:onLevelGlobals()
	
	autoStartGame = false
	autoAllPeopleWalkIn = false

	cleaner:setPosition(grid:getNode(30, 23))
	entertainer:setPosition(entertainer:getHomeNode())
	
	event.animFix = "FIX"
	event.soundFix = "SOUND_FIXTABLE_LOOP"
	event.overheadY = 33
	event.pbY = 25
	event.timeUntilFixed = 1000 * 40
	event.score = 300
	event.sequenceStart = 
	{
		{ "scene",		"qStartMovie" 									},
		{ "cleaner",	"setAppearance",	"ANNOYED"					},
		{ "emily",		"qSetPosition",		movieNode					},
		{ "emily",		"qWalkToXY",		26, 23						},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY5_1"	},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_2"	},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY5_3"	},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_4"	},
		{ "cleaner",	"qSetAppearance",	""							},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY5_5"	},
		{ "emily",		"qAnimate",			"LAUGH", 1					},
		{ "emily",		"qSetAppearance",	"LAUGH"						},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_6"	},
		{ "emily",		"qAnimate",			"IDLE", 0					},
		{ "emily",		"qSetAppearance",	""							},
		{ "emily",		"qWalkToNode",		grid:getCounterNode()		},
		{ "cleaner",	"qSit",				"workerTable"				},
		{ "cleaner",	"qAnimate",			"WORK", -1					},
		{ "scene",		"qFinishMovie" 									},		
		{ "scene",		"qStartGame" 									},
	}
	event.sequenceWinAfterSwap =
	{
		{ "scene",		"qStartMovie" 									},
		{ "cleaner",	"qNotify",			"chas_look"					},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT2_DAY5_10"	},
		{ "emily",		"qSay",				"TEXT_RESTAURANT2_DAY5_11"	},
		{ "cleaner",	"qNotify",			"chas_idle"					},
		{ "scene",		"qFinishMovie" 									},
	}
	
end



-- set day
day = day5()
