-- day class
class 'day6' (interface)

day6.sequenceStart = nil
day6.sequenceFinish = nil
day6.mailman = nil
day6.boxes = nil
day6.matthew = nil

function day6:__init() super()
end

function day6:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false	

	self.mailman = pm:createPerson("npc")
	self.mailman:setBaseName("INGAME_PERSON_SPECIAL_MAILMAN")
	self.mailman:setType("mailman")
	self.mailman:animate("IDLE", 0)
	
	self.matthew = pm:createPerson("npc")
    self.matthew:setBaseName("INGAME_PERSON_MATTHEW")
    self.matthew:setPosition(exitNode)
	
	self.boxes:setVisible(false)

	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "mailman",		"qSetPosition",		movieNode					},
		{ "mailman",		"qSetAppearance",	"CARRY"						},	
		{ "mailman",		"qWalkToXY",		29, 13						},
		{ "mailman",		"qSay",				"RESTAURANT2_DAY6_0"		},
		{ "cleaner",		"qNotify",			"chas_look"					},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY6_1"		},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY6_2"		},
		{ "mailman",		"qSay",				"RESTAURANT2_DAY6_3"		},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY6_4"		},
		{ "cleaner",		"qNotify",			"chas_idle"					},
		{ "mailman",		"qWalkTo",			"boxes"						},
		{ "mailman",		"qSetAppearance",	""							},
		{ "boxes",			"qSetVisible",		true						},
		{ "boxes",			"qSetCurrentFrame",	1							},
		{ "mailman",		"qWalkToNode",		movieNode					},
		{ "mailman",		"qSetAppearance",	"CARRY"						},
		{ "mailman",		"qWalkTo",			"boxes"						},
		{ "mailman",		"qSetAppearance",	""							},
		{ "boxes",			"qSetCurrentFrame",	3							},
		{ "mailman",		"qWalkToNode",		movieNode					},
		{ "mailman",		"qSetAppearance",	"CARRY"						},
		{ "mailman",		"qWalkTo",			"boxes"						},
		{ "mailman",		"qSetAppearance",	""							},
		{ "boxes",			"qSetCurrentFrame",	5							},
		{ "boxes",			"qAnimate",			"OBJECT_PACKAGES_PILED", 0	},
		{ "mailman",		"qWalkToNode",		movieNode					},
		{ "mailman",		"qDestroy",			"day.mailman"				},
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_5"		},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY6_6"		},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									},	
		{ "boxes",			"qCreateOverhead",	"INGAME_ARROW"				},
	}
	self.sequenceFinish = 
	{
		{ "scene",			"qStartMovie" 									},	
		{ "cleaner",		"qStand"										},
		{ "cleaner",		"qWalkToNode",		movieNode					},
		{ "cleaner",		"qDestroy",			"cleaner"					},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "entertainer",	"qWalkToNode",		entertainer:getHomeNode()	},
		{ "emily",			"qSetAppearance",	"SAD"						},
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_10"		},
		{ "entertainer",	"qSay",				"RESTAURANT2_DAY6_11"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "matthew",		"qSetAppearance",	"STOIC"						},
		{ "matthew",		"qWalkToXY",		18, 28						},
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_12"		},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY6_13"		},
		{ "matthew",		"qSetAppearance",	"SELFPITY"					},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY6_14"		},
		{ "matthew",		"qSetAppearance",	"STOIC"						},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY6_15"		},
		{ "entertainer",	"qSay",				"RESTAURANT2_DAY6_16"		},
		{ "entertainer",	"qSay",				"RESTAURANT2_DAY6_17"		},
		{ "matthew",		"qSay",				"RESTAURANT2_DAY6_18"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_19"		},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},		
	}


	qSequence(self.sequenceStart)

end

function day6:onLevelInited()
	
	emily:setPosition(grid:getCounterNode())
	emily:addChild(self.boxes.bar)	
	cleaner:setPosition(cleaner:getHomeNode())
	workerTable:sitDown(cleaner, 0)
	cleaner:animate("WORK", -1)
	entertainer:setPosition(entertainer:getHomeNode())
	
end

function day6:createObject(desc)

	if (desc:getType() == "Boxes") then
		self.boxes = boxesObject()
		self.boxes:setType(desc:getType())
		return self.boxes
		
	end
	
	return nil
	
end

function day6:onTaskStart(actorType, taskType, p0, p1)

	if (actorType == "emily") then
		if (taskType == "WalkToTask") then
			emily:setDefaultAnimation("IDLE")
			
			if (self.boxes.bar ~= nil) then
				if (self.boxes.bar:isVisible()) then
					self.boxes.bar:setVisible(false)
				end		
			end
		end
	end

end

function day6:onDayEnd()

	autoAllPeopleWalkOut = false
		
	qSequence(self.sequenceFinish)
	    
end

-- set day
day = day6()

-- a set of stackable boxes
class 'boxesObject' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
boxesObject.timer = 0
boxesObject.stacked = false
boxesObject.neededToSave = 6
boxesObject.leftToSave = 6
boxesObject.saveClickMin = 0.30
boxesObject.saveClickMax = 0.70
boxesObject.speedMin = 1.0
boxesObject.speedMax = 2.0
boxesObject.speed = 1.0
boxesObject.score = 500
boxesObject.bar = nil
boxesObject.progress = 0
boxesObject.right = true

function boxesObject:__init() super()
end

function boxesObject:onCreate()

	self.bar = createHeimlichBar()
	self.bar:setX(20)
	self.bar:setY(-5)
	self.bar:setProgress(0)
	self.bar:setVisible(false)	

	self:animate("OBJECT_PACKAGES", 0)
	self:setDefaultAnimation("")
	self:createHighlight()
	self:setOverheadX(-10)
	self:setOverheadY(20)
	
end

function boxesObject:onClick()

	if (self.stacked == false) then
		self:playSound("SOUND_OBJECT_CLICK")	
		if (self:isSelected() == false) then
			self:setSelected(true)
			self:clearOverhead()
			emily:qWorkOn(self)
		
		end
	end
	
end

function boxesObject:onSuccess()

	self:removeHighlight()
	self.stacked = true
	self.bar:getCounter():setCurrentFrame(self.leftToSave)
	self.bar:setVisible(false)
	self.bar = nil
	emily:playSound("SOUND_EVENT_COMPLETE_ALL")
	emily:setDefaultAnimation("IDLE")
	emily:animate("IDLE", 0)
	
	incScore(self.score, self:getScreenX() + 35, self:getScreenY())
	
	local sequenceComplete =
	{
		{ "scene",			"qStartMovie" 									},	
		{ "emily",			"qAnimate",			"JUMP", 1					},
		{ "emily",			"qWait",			500							},
		{ "emily",			"qSetAppearance",	"HAPPY"						},
		{ "emily",			"qAnimate",			"IDLE", 0					},		
		{ "emily",			"qSay",				"RESTAURANT2_DAY6_25"		},
		{ "cleaner",		"qNotify",			"chas_look"					},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY6_26"		},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY6_27"		},
		{ "cleaner",		"qNotify",			"chas_idle"					},
		{ "scene",			"qFinishMovie" 									},
	}	
	qInsertSequence(sequenceComplete)
	
end

function boxesObject:onTick(time)

	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			if (self.leftToSave == 0) then
				self:onSuccess()
				
			else
				self.bar:getCursor():setVisible(true)
				self.bar:setBackImage(self.bar.back, self.bar.section)			
			
			end		
		end	
	end
	
	if (self.bar ~= nil) then
		if (self.bar:isVisible() and self.bar:getCursor():isVisible()) then
	
			if (self.right == true) then
				self.progress = self.progress + self.speed * (time / 1000)
			else
				self.progress = self.progress - self.speed * (time / 1000)
			end
		
			if (self.progress >= 1) then
				self.progress = 1
				self.right = false
				
			end
			
			if (self.progress <= 0) then
				self.progress = 0
				self.right = true
				
			end	
		
			self.bar:setProgress(self.progress)	
		
		end
	end	

end

function boxesObject:onWorkStart(task)

	self:setSelected(false)
	
	if (self.stacked == false) then
		-- yes/no image is currently showing
		-- ignore clicks until it goes away
		if (self.timer > 0) then
			return false
			
		end
	
		if (self.bar:isVisible()) then
			
			local hit = false
			if (self.progress >= self.saveClickMin) then
				if (self.progress <= self.saveClickMax) then
					hit = true
				end
			end
			
			if (hit == true) then
				self.leftToSave = self.leftToSave - 1
				self.bar:setBackImage(self.bar.yes, self.bar.section)
				self.speed = self.speedMin + ((self.neededToSave - self.leftToSave) / self.neededToSave) * (self.speedMax - self.speedMin)
				emily:playSound("SOUND_EVENT_COMPLETE_ITEM")
				
			else
				self.leftToSave = self.leftToSave + 1
				if (self.leftToSave > self.neededToSave) then
					self.leftToSave = self.neededToSave
				end
				self.bar:setBackImage(self.bar.no, self.bar.section)
				
			end
			
			self.bar:getCounter():setCurrentFrame(self.leftToSave)			
			self.bar:getCursor():setVisible(false)
			self.progress = 0
			self.timer = 400
			self:setCurrentFrame(self.neededToSave - self.leftToSave)
			
		else
			self.timer = 0
			self.right = true
			self.bar:setVisible(true)
			self.bar:getCounter():setCurrentFrame(self.leftToSave)		
			self.progress = 0
			emily:setDefaultAnimation("WORK")
			emily:animate("WORK", 0)
			
		end

		return true		
	end

	return false
	
end

function boxesObject:onWorkUpdate(task, time)

	return true
	
end