include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"Gumball",
}

-- day class
class 'day7' (interface)

day7.timeUntilSearchingMin = 8000
day7.timeUntilSearchingMax = 16000
day7.timer = 0

function day7:__init() super()
end

function day7:onLevelGlobals()

	-- set event configuration
	event.baseName = "INGAME_CUSTOMER_MALE_CHILD"		-- appearance of the person
	event.baseSection = "customers"
	event.entryX = entryX								-- position person enters from
	event.entryY = entryY
	event.highlightX = 17
	event.highlightY = 16
	event.eventBarImage = "OBJECT_GUMBALL_3_BAR"
	event.timeUntilEnterMin = 25 * 1000					-- minimum time the person waits outside
	event.timeUntilEnterMax = 45 * 1000					-- maximum time the person waits outside
	event.scoreFoundOne	= 25							-- score for finding one item
	event.scoreFoundAll	= 100							-- bonus for finding all items		
	event.sequenceStart	= 								-- text when event starts
	{
		{ "",			"parallel"									},
		{ "person",		"qWalkToXY",		45, 28						},
		{ "person",		"qNotify",			"kid_arrived"				},
	}
	event.sequenceFail = 									-- text when you don't find all the items
	{
		{ "",			"sequential"									},
		{ "scene",		"qStartMovie" 									},
		{ "cleaner",	"qStand"										},
		{ "cleaner",	"qWalkToXY",		45, 23						},
		{ "cleaner", 	"qSay",				"TEXT_RESTAURANT2_DAY7_10"	},
		{ "person",		"qSetAppearance",	"SAD"						},
		{ "person", 	"qSay",				"TEXT_RESTAURANT2_DAY7_21"	},
		{ "cleaner", 	"qSay",				"TEXT_RESTAURANT2_DAY7_22"	},
		{ "person",		"qSetAppearance",	""							},
		{ "",			"parallel"										},
		{ "cleaner",	"qWalkToNode",		cleaner:getHomeNode()		},
		{ "person",		"qWalkToNode",		exitNode					},
		{ "person",		"qDestroy"										},
		{ "scene",		"qFinishMovie" 									},
	}
	event.sequenceDone = 									-- text when you find all items
	{
		{ "",			"sequential"									},
		{ "scene",		"qStartMovie" 									},
		{ "emily",		"qAnimate",			"JUMP", 1					},
		{ "emily",		"qAnimate",			"IDLE", 0					},
		{ "cleaner",	"qStand"										},
		{ "cleaner",	"qWalkToXY",		45, 23						},
		{ "cleaner", 	"qSay",				"TEXT_RESTAURANT2_DAY7_10"	},
		{ "person", 	"qSay",				"TEXT_RESTAURANT2_DAY7_11"	},
		{ "cleaner", 	"qSetAppearance",	"HAPPY"						},
		{ "cleaner", 	"qSay",				"TEXT_RESTAURANT2_DAY7_12"	},
		{ "person", 	"qSay",				"TEXT_RESTAURANT2_DAY7_30"	},
		{ "",			"parallel"										},
		{ "cleaner", 	"qSay",				"TEXT_RESTAURANT2_DAY7_31"	},
		{ "person",		"qWalkToNode",		movieNode					},
		{ "",			"sequential"									},
		{ "emily", 		"qSay",				"TEXT_RESTAURANT2_DAY7_32"	},
		{ "cleaner", 	"qSetAppearance",	"SAD"						},
		{ "cleaner", 	"qSay",				"TEXT_RESTAURANT2_DAY7_33"	},
		{ "cleaner",	"qWalkToNode",		cleaner:getHomeNode()		},
		{ "cleaner", 	"qSetAppearance",	""							},
		{ "person",		"qSetPosition",		exitNode					},
		{ "person",		"qDestroy"										},
		{ "scene",		"qFinishMovie" 									},
	}

end

function day7:onTick(time)

	if (event.completed == true) then
		return
	end
	
	--[[
	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			event.person:animate("SEARCHING", 2, true, -1)		
			self.timer = getRandomRange(self.timeUntilSearchingMin, self.timeUntilSearchingMax)
			
		end		
	end
	--]]

end

function day7:onNotify(notification)

	if (notification == "show bar") then
		self.timer = getRandomRange(self.timeUntilSearchingMin, self.timeUntilSearchingMax)
	
	elseif (notification == "gumball shake") then
		local gumballMachine = getAppliance("rest2_gumball_machine")
		gumballMachine:animate("APP_GUMBALL_MACHINE", 2, 15)
	elseif (notification == "kid_arrived") then
		self:startGumballEvent()
	end
	
end

function day7:startGumballEvent()
	local seq = 
	{
		{ "",			"sequential"									},
		{ "scene",		"qStartMovie" 									},
		{ "emily",		"qWalkToNode",		grid:getCounterNode()		},
		{ "scene",		"qNotify",			"gumball shake"				},
		{ "person",		"qWait",			1000						},
		{ "person",		"qWalkToXY",		48, 24						},	
		{ "person",		"qAnimate",			"IDLE", 0					},
		{ "person",		"qCreateOverhead",	"INGAME_EMPTY_PLATES_SIGN"	},
		{ "person",		"qPlaySound",		"SOUND_EVENT_ATTENTION"		},
		{ "person",		"qWait",			1000						},
		{ "person",		"qRemoveOverhead"								},
		{ "person",		"qNotify",			"ho_arrived"				},
		{ "person", 	"qSay",				"TEXT_RESTAURANT2_DAY7_0"	},
		{ "cleaner",	"qStand"										},
		{ "cleaner",	"qWalkToXY",		45, 24						},
		{ "cleaner", 	"qSay",				"TEXT_RESTAURANT2_DAY7_1"	},
		{ "person", 	"qSay",				"TEXT_RESTAURANT2_DAY7_2"	},
		{ "cleaner", 	"qAnimate",			"IDLE_ANNOYED", 0			},
		{ "cleaner", 	"qSay",				"TEXT_RESTAURANT2_DAY7_3"	},
		{ "cleaner", 	"qSetAppearance",	""							},
		{ "",			"parallel"										},
		{ "cleaner",	"qWalkToNode",		cleaner:getHomeNode()		},
		{ "person",		"qSetAppearance",	"SAD"						},
		{ "person", 	"qSay",				"TEXT_RESTAURANT2_DAY7_4"	},
		{ "",			"sequential"									},
		{ "emily",		"qWalkToXY",		45, 24						},
		{ "emily", 		"qSay",				"TEXT_RESTAURANT2_DAY7_5"	},
		{ "person",		"qSetAppearance",	""							},
		{ "person", 	"qSay",				"TEXT_RESTAURANT2_DAY7_6"	},
		{ "emily", 		"qSay",				"TEXT_RESTAURANT2_DAY7_7"	},
		{ "",			"parallel"										},
		{ "emily",		"qWalkToNode",		grid:getCounterNode()		},
		{ "",			"sequential"									},
		{ "scene",		"qWait",			500							},
		{ "scene",		"qFinishMovie" 									},
		{ "scene",		"qNotify",			"show bar"					},
	}
	
	qSequence(seq)
end

-- set day
day = day7()
