-- day class
class 'day8' (interface)

day8.timesUntilNext = { 20000, 30000, 20000, 30000, 20000, 30000 }
day8.scoreGotOne = 25
day8.scoreGotAll = 100

day8.index = 0
day8.timer = 0
day8.sequenceStart = nil
-- day8.mud = nil
day8.bully = nil

day8.mudballs = {}
day8.mudcount = 0
day8.mudcleaned = 0

function day8:__init() super()
end

function day8:onLevelInited()

	autoStartGame = false
	autoAllPeopleWalkIn = false	

	self.bully = pm:createPerson("npc")
	self.bully:setBaseName("INGAME_PERSON_BULLY")
	self.bully:setPosition(grid:getNode(0, 6))
	self.bully:animate("IDLE", 0)
	self.bully:setWalkTimePerNode(45)
	self.bully:setAppearance("RUN")
			
	emily:setPosition(exitNode)
	entertainer:setPosition(entertainer:getHomeNode())
	cleaner:setPosition(grid:getNode(30, 23))	
	cleaner:setAppearance("ANGRY")
	cleaner:setReturnHome(false)
	for index, value in ipairs(self.mudballs) do
		value:setCurrentFrame(value:getFrameCount() - 1)
		value:setVisible(false)
		value:setClickable(false)
	end
	--self.mud:setCurrentFrame(self.mud:getFrameCount() - 1)
	--self.mud:setVisible(false)
	--self.mud:setClickable(false)

	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(table.getn(self.timesUntilNext))
	eventBar:setProgress(0)	
	eventBar:setDescriptionText(getText("EVENTBAR"))
	eventBar:setSubjectImage("OBJECT_MUD_BAR", player:getCurrentResourceSection())

	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "emily",			"qSetPosition",		movieNode					},
		{ "emily",			"qWalkToXY",		25, 23						},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY8_0"		},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY8_1"		},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY8_2"		},
		{ "emily",			"qSay",				"RESTAURANT2_DAY8_3"		},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY8_4"		},
		{ "cleaner",		"qSetAppearance",	"ANNOYED"					},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY8_5"		},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "",				"parallel"										},
		{ "cleaner",		"qSit",				workerTable					},
		{ "cleaner",		"qAnimate",			"WORK", -1					},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},			
		{ "",				"sequential"									},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									},			
		{ "cleaner",		"qSetReturnHome",	true						},		
		{ "emily",			"qNotify",			"active curtain"			},
	}
	self.sequenceComplete =
	{
		{ "scene",			"qWait",			2000						},
		{ "scene",			"qStartMovie" 									},
		{ "cleaner",		"qWalkToXY",		30, 14						},
		{ "cleaner",		"qAnimate",			"LAUGH", -1, 8				},
		{ "cleaner",		"qWait",			750							},
		{ "cleaner",		"qSetAppearance",	"HAPPY"						},
		{ "cleaner",		"qAnimate",			"IDLE", 0					},		
		{ "emily",			"qWalkToXY",		34, 23						},
		{ "emily",			"qSay",				"RESTAURANT2_DAY8_10"		},						
		{ "cleaner",		"qWalkToXY",		30, 23						},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY8_11"		},
		{ "emily",			"qSetAppearance",	"OFFENDED"					},
		{ "emily",			"qSay",				"RESTAURANT2_DAY8_12"		},
		{ "cleaner",		"qSay",				"RESTAURANT2_DAY8_13"		},
		{ "",				"parallel"										},
		{ "cleaner",		"qSetAppearance",	""							},
		{ "emily",			"qSetAppearance",	""							},
		{ "",				"sequential",									},
		{ "scene",			"qFinishMovie" 									},
	}

	qSequence(self.sequenceStart)

end

function day8:moveBully()
	if (self.index <= self.mudcount) then
		local walkX = self.mudballs[self.index]:getWorkNode():getGridX()
		local walkY = self.mudballs[self.index]:getWorkNode():getGridY()
		local endX = 0
		
		if (self.bully:getPosition():getGridX() == 0) then
			endx = 49
		end
		
		self.bully:qPlaySound("SOUND_BULLY_MUD_RUN_LOOP", true)
		self.bully:qWalkToXY(walkX, walkY)
		self.bully:qStopSound("SOUND_BULLY_MUD_RUN_LOOP")
		self.bully:qAnimate("MUD", 1)
		self.bully:qNotify("show curtain")
		self.bully:qWait(800)
		self.bully:qPlaySound("SOUND_BULLY_MUD_LAUGH")
		self.bully:qPlaySound("SOUND_BULLY_MUD_RUN_LOOP", true)
		self.bully:qWalkToXY(endX, walkY)
		self.bully:qStopSound("SOUND_BULLY_MUD_RUN_LOOP")
	end
end

function day8:onTick(time)

	if (scene:isStartingMovie()) then
		return
	end
	
	if (scene:isPlayingMovie()) then
		return
	end

	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			self:moveBully()
		end	
	end

end

function day8:createObject(desc)

	if (desc:getType() == "Mud") then
		local mud = mudObject()
		mud:setType(desc:getType())
		self.mudcount = self.mudcount + 1
		self.mudballs[self.mudcount] = mud
		return mud
		
	end
	
	return nil
	
end

function day8:gotoNext()

	self.index = self.index + 1
	
	--if (self.index > table.getn(self.timesUntilNext)) then
	if (self.index > self.mudcount) then
		--scene:qWait(1500)
		--scene:qNotify("deactive curtain")
		--incScore(self.scoreGotAll, cleaner:getScreenX(), cleaner:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")
		self.bully:qDestroy()
		self.bully = nil
	
	else
		local timerIndex = self.index % table.getn(self.timesUntilNext)
		timerIndex = timerIndex + 1
		self.timer = self.timesUntilNext[self.index]
	
	end

end

function day8:onNotify(notification)

	if (notification == "active curtain") then
		eventBar:animateToActive()
		self:gotoNext()
		
	elseif (notification == "deactive curtain") then
		eventBar:animateToDeactive()	

	elseif (notification == "show curtain") then
		eventBar:raiseCurtain()	
		local mud = self.mudballs[self.index]
		mud:setVisible(true)
		mud:playSound("SOUND_BULLY_MUD_SPLAT")
		mud:animate("OBJECT_MUD", 1)
		mud:qWait(800)
		mud:qNotify("show mud")		
	
	elseif (notification == "show mud") then
		local mud = self.mudballs[self.index]
		mud:animate("OBJECT_MUD", 0)
		mud:setCurrentFrame(mud:getFrameCount() - 1)
		mud:setClickable(true)
		self:gotoNext()
	
	elseif (notification == "mud cleaned") then
		self:handleMudCleaned()
		
	end

end

function day8:handleMudCleaned()

	self.mudcleaned = self.mudcleaned + 1
	if (self.mudcleaned >= self.mudcount) then
		scene:qWait(1500)
		scene:qNotify("deactive curtain")
		incScore(self.scoreGotAll, cleaner:getScreenX(), cleaner:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")
		emily:playSound("SOUND_EVENT_COMPLETE_ALL")
		qInsertSequence(self.sequenceComplete)
	end
	
	eventBar:setProgress(self.mudcleaned)
end

-- set day
day = day8()

-- mud
class 'mudObject' (D2Object)

-- internal variables
-- don't change unless you know what you're doing

function mudObject:__init() super()
end

function mudObject:onCreate()

	self:createHighlight()
	self:getHighlight():setAlphaHitmaskThreshold(-1)
	self:animate("OBJECT_MUD", 0)

end

function mudObject:onClick()

	self:playSound("SOUND_OBJECT_CLICK")
	if (self:isSelected() == false) then
		self:setSelected(true)
		cleaner:qWorkOn(self)
	
	end

end

function mudObject:onWorkStart(task)

	self:setSelected(false)
	self:setClickable(false)
	
	if (D2Object.onWorkStart(self, task)) then
		task:getPerson():animate("CLEAN_WINDOW", -1)
		task:setDuration(1000 * 10)
		self:playSound("SOUND_CLEAN_LOOP", true)
		return true
	
	end
	
	return false

end

function mudObject:onWorkComplete(task)

    self:stopSound("SOUND_CLEAN_LOOP")
	self:setVisible(false)
	--eventBar:lowerCurtain()
	--day:gotoNext()
	incScore(day.scoreGotOne, cleaner:getScreenX(), cleaner:getScreenY() + scorePersonFloaterOffsetY, 0)
	emily:playSound("SOUND_EVENT_COMPLETE_ITEM")
	scene:qNotify("mud cleaned")

end