include("scripts/events/shoutandmakeevent.lua")

-- 
event = shoutAndMakeEvent()

class 'day9' (interface)

function day9:__init() super()
end

function day9:onLevelGlobals()
	-- First sort out the day's event
	self:initEvent()
	
	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- Now the intro story bizzle
	local introSequence =
	{
		{ "scene",		"qStartMovie" 									},
		{ "entertainer","qSetPosition",			movieNode				},
		{ "emily",		"qSetPosition",			movieNode				},
		{ "emily",		"qWalkToXY",			25, 23					},
		{ "emily",		"qSetAppearance",		"SAD"					},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_0"	},
		{ "cleaner",	"qSetAppearance",		"ANNOYED"				},
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY9_1"	},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_2"	},
		{ "cleaner",	"qSetAppearance",		"SAD"					},
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY9_3"	},
		{ "emily",		"qSay",					"RESTAURANT2_DAY9_4"	},
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY9_5"	},
		{ "cleaner",	"qSetAppearance",		"HAPPY"					},
		{ "cleaner",	"qSay",					"RESTAURANT2_DAY9_6"	},
		{ "",			"parallel"										},
		{ "emily",		"qSetAppearance",		""						},
		{ "cleaner",	"qSetAppearance",		""						},
		{ "cleaner",	"qWalkToNode",			cleaner:getHomeNode()	},
		{ "emily",		"qWalkToNode",			grid:getCounterNode()	},
		{ "entertainer","qWalkToNode",			entertainer:getHomeNode()},
		{ "",			"sequential"									},
		{ "scene",		"qFinishMovie" 									},
		{ "scene",		"qStartGame" 									},
	}
	
	qSequence(introSequence)
	
	-- set up the intro characters
	cleaner:setPosition(grid:getNode(29, 23))
	emily:setPosition(exitNode)
	entertainer:setPosition(exitNode)
	
end

function day9:onNotify(notification)

	if (notification == "hug boy") then
		event.owner:setVisible(false)
		cleaner:animate("HUG_BOY", 0)
	
	elseif (notification == "hug matthew") then
		cleaner:setVisible(false)
		matthew:animate("HUG_CHARLES", 0)
	
	end

end

function day9:initEvent()

	-- Matthew for the outro
    matthew = pm:createPerson("npc")
    matthew:setBaseName("INGAME_PERSON_MATTHEW")
    matthew:setPosition(exitNode)
    
	event.baseName = "INGAME_PERSON_SHOUT_CHILD"
	event.pool =
	{
		"CANDY_CANE",
		"CANDY_KEY",
		"CHOCOLATE",
		"LITTLE_CAKE",
		"LOLLIPOP",
		"MINT_CANDY",
		"SUGAR_HEART",
		"TOFFEE",
		"TUMTUM",
	}
	
	event.chances =
	{ 	
		10, 
		10,
		10,
		10,
		10, 
		10,
		10,
		10,
		10,
	}
	event.timeUntilNextOrder = 8000				-- interval at which the orders come
	event.timeUntilEnd = 150000					-- time allowed to make all products
	event.waitX = 31							-- position the orderer waits inside
	event.waitY = 23
	event.workX = 7								-- position emily will be to deliver the order
	event.workY = 22
	event.numProductsPerOrder = 2				-- number of products ordered each order
	event.numOrders = 10						-- total number of orders
	event.workAnim = "IDLE"						-- animation played by mailman
	event.score = 40
	event.bubbleOffsetX = 0
	event.bubbleOffsetY = -80
	event.barOffsetY = 15
	event.maxBalloonSize = 15
	
	event.timeUntilArrivalMin = 1000 * 	220		-- min time before the customer arrives
	event.timeUntilArrivalMax = 1000 * 	230		-- max time before the customer arrives
	-- the sequences
	event.sequenceStart =
	{
		{ "",			"sequential"								},
		{ "scene",		"qStartMovie"								},
		{ "owner",		"qWalkToXY",		5, 10					},
		{ "owner",		"qAnimate",			"WALK_UP", 0			},
		{ "owner",		"qWait",			1000					},
		{ "owner",		"qWalkToXY",		45, 28					},
		{ "owner",		"qWait",			1000					},
		{ "owner",		"qWalkToXY",		8, 22					},
		{ "owner",		"qWait",			500						},
		{ "emily",		"qWalkToXY",		20, 23					},
		{ "emily",		"qCreateOverhead",	"INGAME_EMPTY_PLATES_SIGN"	},
		{ "emily",		"qWait",			500						},
		{ "emily",		"qRemoveOverhead"							},
		{ "emily",		"qWalkToXY",		12, 22					},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_10"	},
		{ "owner",		"qSay",				"RESTAURANT2_DAY9_11"	},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_12"	},
		{ "owner",		"qSay",				"RESTAURANT2_DAY9_11"	},
		{ "owner",		"qSay",				"RESTAURANT2_DAY9_13"	},
		
		{ "scene",		"qFinishMovie"								},
		{ "scene",		"qNotify",			"start ordering"		},
	}
	
	event.sequenceDayOver =
	{
		{ "scene",		"qStartMovie"									},
		{ "",			"parallel"										},
		{ "entertainer","qWalkToNode",		entertainer:getHomeNode()	},
		{ "emily",		"qWalkToXY",		12, 22						},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_20"		},
		{ "",			"sequential"									},
		{ "cleaner",	"qWalkToXY",		4, 22						},
		{ "owner",		"qSay",				"RESTAURANT2_DAY9_21"		},
		{ "cleaner",	"qWait",			250							},
		{ "cleaner",	"qSetAppearance",	"CRYING"					},
		{ "cleaner",	"qWait",			500							},
		{ "cleaner",	"qSetAppearance",	"SAD"						},
		{ "cleaner",	"qWait",			500							},
		{ "cleaner",	"qSetAppearance",	"CRYING"					},
		{ "cleaner",	"qWait",			750							},
		{ "cleaner",	"qSetAppearance",	"SAD"						},
		{ "cleaner",	"qWait",			250							},
		{ "cleaner",	"qSetAppearance",	"CRYING"					},
		{ "cleaner",	"qWait",			1000						},
		{ "cleaner",	"qAnimate",			"DROPTOKNEE", 1, false, 6, true	},
		{ "owner",		"qSetAppearance",	"SAD"						},
		{ "owner",		"qSay",				"RESTAURANT2_DAY9_22"		},
		{ "emily",		"qSetAppearance",	"NEUTRAL"					},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_23"		},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_24"		},
		{ "owner",		"qWalkToXY",		6, 22						},
		{ "owner",		"qNotify",			"hug boy"					},
		{ "cleaner",	"qWait",			2500						},
		{ "",			"parallel"										},
		{ "cleaner",	"qSetAppearance",	"KNEE", 					},
		{ "cleaner",	"qAnimate",			"IDLE", 0					},
		{ "owner",		"qSetVisible",		true						},
		{ "owner",		"qWalkToXY",		6, 22						},
		{ "owner",		"qWalkToXY",		6, 23						},
		{ "owner",		"qWalkToXY",		29, 23						},
		{ "owner",		"qWalkToNode",		movieNode					},
		{ "owner",		"qDestroy"										},
		{ "emily",      "qWait",            1000                        },
		{ "emily",	    "qWalkToXY",		8, 22						},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_25"		},
		{ "",			"sequential"									},
		{ "cleaner",	"qSetAppearance",	"SAD"						},
		{ "cleaner",	"qSay",				"RESTAURANT2_DAY9_26"		},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_27"		},
		{ "cleaner",	"qSetAppearance",	"CRYING"					},		
		{ "cleaner",	"qSay",				"RESTAURANT2_DAY9_28"		},
		{ "cleaner",	"qSay",				"RESTAURANT2_DAY9_29"		},
		{ "cleaner",	"qSay",				"RESTAURANT2_DAY9_30"		},
		{ "matthew",	"qSetPosition",		movieNode					},
		{ "matthew",	"qSetAppearance",	"STOIC"						},
		{ "matthew",	"qWalkToXY",		29, 23						},
		{ "matthew",	"qSetAppearance",	""							},
		{ "matthew",	"qSay",				"RESTAURANT2_DAY9_31"		},
		{ "cleaner",	"qSetAppearance",	"HAPPY"						},
		{ "cleaner",	"qSay",				"RESTAURANT2_DAY9_32"		},
		{ "cleaner",	"qSetWalkTimePerNode", 35						},
		{ "cleaner",	"qWalkToXY",		4, 24						},
		{ "cleaner",	"qWalkToXY",		29, 24						},
		{ "cleaner",	"qWalkToXY",		29, 23						},
		{ "cleaner",	"qNotify",			"hug matthew"				},
		{ "cleaner",	"qSetWalkTimePerNode", 70						},
		{ "matthew",	"qWait",			2000						},
		{ "matthew",	"qSetAppearance",	"STOIC"						},
		{ "matthew",	"qSay",				"RESTAURANT2_DAY9_33"		},
		{ "matthew",	"qWait",			2000						},
		{ "emily",		"qWalkToXY",		22, 23						},
		{ "",			"sequential"									},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_34"		},
		{ "",			"parallel"										},
		{ "matthew",	"qAnimate",			"IDLE", 0					},
		{ "matthew",	"qSetAppearance",	"HAPPY"						},
		{ "cleaner",	"qSetAppearance",	"HAPPY"						},
		{ "cleaner",	"qSetVisible",		true						},
		{ "cleaner",	"qWalkToXY",		29, 24						},
		{ "cleaner",	"qWalkToXY",		26, 24						},
		{ "cleaner",	"qWalkToXY",		26, 23						},
		{ "",			"sequential"									},
		{ "emily",		"qSetWalkTimePerNode", 200						},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_35"		},
		{ "matthew",	"qSay",				"RESTAURANT2_DAY9_36"		},
		{ "cleaner",	"qSay",				"RESTAURANT2_DAY9_37"		},
		{ "emily",		"qSetAppearance",	""							},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_38"		},
		{ "emily",		"qSay",				"RESTAURANT2_DAY9_39"		},
		{ "entertainer","qSay",				"RESTAURANT2_DAY9_40"		},
		{ "emily",		"qSetWalkTimePerNode", 70						},
		
		{ "",				"parallel"									},
		{ "emily",			"qWalkToNode",		movieNode				},
		{ "entertainer",	"qWalkToNode",		movieNode				},
		{ "",				"sequential"								},
		{ "emily",			"qSetPosition",		exitNode				},
		{ "entertainer",	"qSetPosition",		exitNode				},
		{ "emily",			"qSetVisible",		false					},
		{ "entertainer",	"qSetVisible",		false					},
		
		{ "cleaner",	"qWalkToXY",		26, 24						},
		{ "cleaner",	"qWalkToXY",		29, 24						},
		{ "cleaner",	"qWalkToXY",		29, 23						},
		{ "cleaner",	"qNotify",			"hug matthew"				},
		{ "matthew",	"qWait",			3000						},
		
		{ "scene",		"qFadeToBlack"								},
		{ "scene",		"qFinishMovie"								},
		{ "scene",		"qFinishGame"								},
	}

	
end


-- set the day
day = day9()