include("scripts/products/regularproduct.lua")
include("scripts/appliances/camera.lua")
include("scripts/appliances/stockappliance.lua")
include("scripts/appliances/ovenappliance.lua")
include("scripts/appliances/actiontable.lua")
include("scripts/products/ovenbaseproduct.lua")
include("scripts/products/ovensecondproduct.lua")
include("scripts/products/skilletproduct.lua")
include("scripts/products/herbproduct.lua")

-- entry node
-- npc's and such will be spawned at this location
entryX = 6
entryY = 0
entryNode = nil

-- exit node
exitX = 40
exitY = 0
exitNode =  nil

-- movie node
-- when a movie is playing and an npc's enters or exits (and gets destroyed),
-- it will do so from this node
movieX = 7
movieY = 4
movieNode = nil

-- camera man
cameraMan = nil
cameraManHomeX = 3
cameraManHomeY = 34

spectator = {}
winnerId = i
winnerFlagDuration = 7500

-- restaurant class
class 'restaurant3' (interface)

restaurant3.currentSpectatorId = 1
restaurant3.specCoords = 
{
	{ 27, 126},
	{233, 126},
	{309, 126},
	{396, 126},
	{478, 126},
	{571, 120},
	{785, 126}
}
restaurant3.spectatorTypes =
{
	"INGAME_CUSTOMER_FEMALE_REGULAR",
	"INGAME_CUSTOMER_MALE_REGULAR",
	"INGAME_CUSTOMER_FEMALE_DESIGNER",
	"INGAME_CUSTOMER_MALE_DESIGNER",
	"INGAME_CUSTOMER_FEMALE_YUPPIES",
	"INGAME_CUSTOMER_MALE_YUPPIES",
	"INGAME_CUSTOMER_FEMALE_BIGGIES",
	"INGAME_CUSTOMER_MALE_BIGGIES",
	"INGAME_PERSON_WINNER",
}



function restaurant3:__init() super()
end

function restaurant3:onLevelGlobals()

	cameraMan = pm:createPerson("npc")
	cameraMan:setBaseName("INGAME_PERSON_SPECIAL_CAMERAMAN")
	cameraMan:setType("cameraman")
	cameraMan:setPosition(grid:getNode(cameraManHomeX, cameraManHomeY))
	cameraMan:animate("IDLE", 0)	

	local gridx = 0
	local gridy = 0
	
	for count = 1, 5 do
		gridx = self.specCoords[count][1]
		gridy = self.specCoords[count][2]
		self:placeRandomSpectator(gridx, gridy)
	end
	
	gridx = self.specCoords[6][1]
	gridy = self.specCoords[6][2]
	self:placeWinnerSpectator(gridx, gridy)
	
	gridx = self.specCoords[7][1]
	gridy = self.specCoords[7][2]
	self:placeRandomSpectator(gridx, gridy)
end

function restaurant3:onDayBegin()

    self:clapSpectators()

end

function restaurant3:placeRandomSpectator(xPos, yPos)
	local i = self.currentSpectatorId
	spectator[i] = createActorSprite()
	spectator[i]:setDefaultFrameRate(getRandomRange(10, 15))
	spectator[i]:setDefaultSection("customers")
	
	spectator[i].customerType = getRandom(table.getn(self.spectatorTypes) - 1) + 1
	spectator[i]:animate(self.spectatorTypes[spectator[i].customerType] .. "_IDLE_HAPPY", 0)
	
	spectator[i]:setAnchorPointType(BOTTOMCENTER)
	spectator[i]:setX(xPos)
	spectator[i]:setY(yPos)
	level:getLayer(LAYER_GRID_ELEMENTS):addChild(spectator[i])
	spectator[i]:reposition()
	
	self.currentSpectatorId = self.currentSpectatorId + 1

end

function restaurant3:placeWinnerSpectator(xPos, yPos)
	local i = self.currentSpectatorId
	winnerId = i
	spectator[i] = createActorSprite()
	spectator[i]:setDefaultFrameRate(getRandomRange(10, 15))
	spectator[i]:setDefaultSection("customers")
	
	spectator[i].customerType = 9
	spectator[i]:animate(self.spectatorTypes[spectator[i].customerType] .. "_IDLE_HAPPY", 0)
	
	spectator[i]:setAnchorPointType(BOTTOMCENTER)
	spectator[i]:setX(xPos)
	spectator[i]:setY(yPos)
	level:getLayer(LAYER_GRID_ELEMENTS):addChild(spectator[i])
	spectator[i]:reposition()
	
	self.currentSpectatorId = self.currentSpectatorId + 1

end

function restaurant3:clapSpectators()

	spectator[1]:qPlaySound("SOUND_FIREWORK_CROWD", true)

    for index, spec in ipairs(spectator) do
        spec:qWait(getRandomRange(0, 130))
        spec:qAnimate(self.spectatorTypes[spec.customerType] .. "_CLAP", -1)
        spec:qWait(2000)
        spec:qAnimate(self.spectatorTypes[spec.customerType] .. "_IDLE_HAPPY", -1)
   
    end
    
    spectator[1]:qStopSound("SOUND_FIREWORK_CROWD")

end

function restaurant3:waveSpectators()

	spectator[1]:qPlaySound("SOUND_FIREWORK_CROWD", true)

    for index, spec in ipairs(spectator) do
        spec:qWait(getRandomRange(0, 130))
        spec:qAnimate(self.spectatorTypes[spec.customerType] .. "_WAVE", -1)
        spec:qWait(2000)
        spec:qAnimate(self.spectatorTypes[spec.customerType] .. "_IDLE_HAPPY", -1)
            
    end
    
    spectator[1]:qStopSound("SOUND_FIREWORK_CROWD")

end

function restaurant3:FlagWinner()		
        spectator[winnerId]:qAnimate(self.spectatorTypes[9] .. "_FLAG", -1)
        spectator[winnerId]:qWait(2000)
        spectator[winnerId]:qAnimate(self.spectatorTypes[9] .. "_IDLE_HAPPY", -1)           
		winnerFlagDuration = math.random(5000, 15000)
end

function restaurant3:onTick(time)
	if (level:isDayStarted()) then
		winnerFlagDuration = winnerFlagDuration - time
		if (winnerFlagDuration < 0) then
			self:FlagWinner()
		end
	end
end

function restaurant3:onNotify(notification)

	if (notification == "trigger product table") then
		getAppliance("rest3_producttable_bottom"):doNext()
	
	elseif (notification == "clap spectators") then
	    self:clapSpectators()
	
	elseif (notification == "wave spectators") then
	    self:waveSpectators()
	
	end

end

function restaurant3:createPerson(class)

	local result = nil
	
	if (class == "ludwig") then
		result = npc("INGAME_PERSON_BOSS")
		result:setType(class)
		result:animate("IDLE", 0)
		result:setButtX(20)		
	
	elseif (class == "cleaner") then
		result = d2cleaner("INGAME_PERSON_FRANCOIS")
		result:setType("cleaner")
		result:animate("IDLE", 0)
		result.clean = true

	end
	
	return result

end	
	
function restaurant3:createObject(desc)

	if (desc:getType() == "OriganoAppliance") then
		result = stockAppliance()
		result:setType(desc:getType())
		result.productFillTime = 600
		result.productFillSound = "SOUND_MORTALPESSLE"
		result.productName = "OREGANO"
		return result	
	elseif (desc:getType() == "ChivesAppliance") then
		result = stockAppliance()
		result:setType(desc:getType())
		result.productFillTime = 600
		result.productName = "CHIVES"
		return result	
	elseif (desc:getType() == "OvenAppliance") then
		result = ovenAppliance()
		result:setType(desc:getType())
		return result
	elseif (desc:getType() == "ActionTable") then
		result = actionTable()
		result:setType(desc:getType())
		return result
	elseif (desc:getType() == "Camera") then
		result = Camera()
		result:setType(desc:getType())
		return result
	end
	
	return nil
end

function restaurant3:createProduct(base)

	oreganoMaxStock = 4
	oreganoStartStock = 4

	chivesMaxStock = 5
	chivesStartStock = 5

	if (type(base) == "string")	then
		if (base == "GLASS_CHAMPAGNE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkOffsetX(1)
			p:setWorkSound("SOUND_GRAB_JUICE_GLASS")
			return p
			
		elseif (base == "GLASS_ROSE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkOffsetX(4)
			p:setWorkSound("SOUND_GRAB_JUICE_GLASS")
			return p

		elseif (base == "BOTTLE_CHAMPAGNE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkOffsetX(1)
			p:setWorkSound("SOUND_USE_BUBBLY_WATER")
			return p
			
		elseif (base == "BOTTLE_ROSE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkOffsetX(4)
			p:setWorkSound("SOUND_USE_BUBBLY_WATER")
			return p

		elseif (base == "TIRAMISU") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkOffsetX(-2)
			p:setWorkSound("SOUND_GRAB_TEA")
			return p
			
		elseif (base == "CHEESECAKE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkOffsetX(1)
			p:setWorkSound("SOUND_GRAB_TEA")
			return p

		-- end of regular stuff

		elseif (base == "SALTPEPPER") then
			p = herbProduct(base)
			p:setWorkTime(250)
			p:setWorkAnimation("WORK_RIGHT")
			p:setWorkSound("SOUND_ADD_PEPPER_SALT")
			return p
			
		elseif (base == "CHIVES") then
			p = herbProduct(base)
			p:setWorkTime(250)
			p:setStock(chivesStartStock)
			p:setMaxStock(chivesMaxStock)
			p:setWorkAnimation("WORK_RIGHT")
			p:setWorkSound("SOUND_GRAB_TEA")
			return p

		elseif (base == "OREGANO") then
			p = herbProduct(base)
			p:setWorkTime(250)
			p:setStock(oreganoStartStock)
			p:setMaxStock(oreganoMaxStock)
			p:setWorkAnimation("WORK_RIGHT")
			p:setWorkSound("SOUND_GRAB_TEA")
			return p

		elseif (base == "FISH") then
			p = skilletProduct(base)
			p:setBubbleX(463)
			p:setBubbleY(347)
			p:setBubbleSmall(false)	
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_SQUID_CAVIAR")
			return p

		elseif (base == "MEAT") then
			p = skilletProduct(base)
			p:setBubbleX(463)
			p:setBubbleY(347)
			p:setBubbleSmall(false)		
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_SQUID_CAVIAR")
			return p

		elseif (base == "CARPACCIO") then
			p = regularProduct(base)
			p:setBubbleX(470)
			p:setBubbleY(200)
			p:setBubbleSmall(true)
			p:setWorkTime(0)
			p:setWorkAnimation("WORK")
			return p
		
		elseif (base == "PORTOBELLO") then
			p = ovenbaseProduct(base)
			p:setBubbleX(435)
			p:setBubbleY(200)
			p:setBubbleSmall(true)
			p:setWorkTime(0)
			p:setWorkAnimation("WORK")
			p:setVisibleOnTray(false)
			p:setWorkOffsetX(-1)			
			return p			
			
		elseif (base == "LASAGNE") then
			p = ovenbaseProduct(base)
			p:setBubbleX(435)
			p:setBubbleY(200)
			p:setBubbleSmall(true)
			p:setWorkTime(0)
			p:setWorkAnimation("WORK")
			p:setVisibleOnTray(false)
			p:setWorkOffsetX(2)			
			return p	
					
		elseif (base == "LASAGNE_SALTPEPPER") then
			p = ovenSecondProduct(base)
			p:setBubbleTarget("rest3_oven")
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_TEA")
			return p

		elseif (base == "LASAGNE_CHIVES") then
			p = ovenSecondProduct(base)
			p:setBubbleTarget("rest3_oven")
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_TEA")
			return p

		elseif (base == "LASAGNE_OREGANO") then
			p = ovenSecondProduct(base)
			p:setBubbleTarget("rest3_oven")
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_TEA")
			return p
			
		elseif (base == "PORTOBELLO_SALTPEPPER") then
			p = ovenSecondProduct(base)
			p:setBubbleTarget("rest3_oven")
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_TEA")
			return p

		elseif (base == "PORTOBELLO_CHIVES") then
			p = ovenSecondProduct(base)
			p:setBubbleTarget("rest3_oven")
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_TEA")
			return p

		elseif (base == "PORTOBELLO_OREGANO") then
			p = ovenSecondProduct(base)
			p:setBubbleTarget("rest3_oven")
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_TEA")
			return p			
		end
		
	elseif (type(base) == "userdata") then
		--
		-- attempting to create a copy!
		if (base:getBase() == "LASAGNE_SALTPEPPER") then
			p = ovenSecondProduct(base)
			return p
		
		elseif (base:getBase() == "LASAGNE_CHIVES") then
			p = ovenSecondProduct(base)
			return p

		elseif (base:getBase() == "LASAGNE_OREGANO") then
			p = ovenSecondProduct(base)
			return p

		elseif (base:getBase() == "PORTOBELLO_SALTPEPPER") then
			p = ovenSecondProduct(base)
			return p

		elseif (base:getBase() == "PORTOBELLO_CHIVES") then
			p = ovenSecondProduct(base)
			return p

		elseif (base:getBase() == "PORTOBELLO_OREGANO") then
			p = ovenSecondProduct(base)
			return p

		elseif (base:getBase() == "FISH") then
			p = skilletProduct(base)
			return p

		elseif (base:getBase() == "MEAT") then
			p = skilletProduct(base)
			return p
			
		end
	end
	
	return nil
		
end

-- set restaurant
restaurant = restaurant3()