-- day class
class 'day0' (interface)


function day0:__init() super()
end

function day0:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
		
	ludwig = pm:createPerson("ludwig")
	ludwig:setPosition(grid:getNode(36, 13))
	ludwig:setOverheadFrameTime(750)
	emily:setPosition(exitNode)

end

function day0:onLevelInited()

	local sequenceStart = 
	{
		{ "scene",			"qStartMovie" 										},		
		
		{ "emily",			"qWalkToXY",		40,	13							},
		{ "emily",			"qWait",			500								},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY0_0"		},
		{ "ludwig",			"qWait",			500								},
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY0_1"		},
		
		{ "",				"parallel"											},
		{ "emily",			"qWait",			100								},
		{ "emily",			"qWalkToXY",		14,	19							},
		{ "ludwig",			"qWalkToXY",		10,	19							},
		{ "",				"sequential"										},
		
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY0_2",		},
		{ "ludwig",			"qWalkToXY",		7,	16							},
		{ "emily",			"qSetAppearance",	"SURPRISED"						},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY0_3"		},		
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY0_4"		},
		{ "cameraMan",		"qWalkToXY",		9, cameraManHomeY				},
		{ "cameraMan",		"qWalkToXY",		14, 23							},
		{ "cameraMan",		"qAnimate",			"KNEEL_UP", 0					},		
		{ "ludwig",			"qWait",			500								},

		{ "",				"parallel"											},
		{ "ludwig",			"qCreateScreenOverhead","INGAME_COUNTDOWN_ICON"		},
		{ "ludwig",			"qWait",			3375							},	
		{ "ludwig",			"qClearOverhead"									},	
		{ "ludwig",			"qAnimate",			"CLAPPER", 1, false, -1, true	},
		{ "ludwig",			"qWait",			400								},
		{ "ludwig",			"qWalkToXY",		7, 0							},
		{ "ludwig",			"qDestroy",			"ludwig"						},		
		{ "emily",			"qWait",			5000							},	
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY0_5"		},
		{ "",				"sequential"										},

		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY0_10"		},
		{ "emily",			"qSetAppearance",	"HAPPY"							},		
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY0_11"		},
		{ "emily",			"qAnimate",			"PRESENT", 1, false, -1, true	},
		{ "",				"parallel"											},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY0_12"		},
		{ "scene",			"qWait",			600								},
		{ "",				"sequential"										},
		{ "emily",			"qAnimate",			"IDLE", 0						},

		{ "cameraMan",		"qWait",			500								},
		{ "cameraMan",		"qWalkToXY",		cameraManHomeX, cameraManHomeY	},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qStartGame" 										},
		{ "emily",			"qSetAppearance",	""								},		
	}

	-- play start sequence
	qSequence(sequenceStart)

end

function day0:onDayEnd()

	ludwig = pm:createPerson("ludwig")
	ludwig:setPosition(entryNode)

	-- prevent walking out
	autoAllPeopleWalkOut = false
	
	local sequenceCompleted = 
	{
		{ "scene",			"qStartMovie" 									},
		
		{ "ludwig",			"qWalkToXY",		13,	19						},	
		{ "emily",			"qWalkToXY",		17,	19						},
		{ "ludwig",			"qWait",			500							},
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY0_20"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY0_21"	},
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY0_22"	},
		{ "emily",			"qSetAppearance",	"CONFUSED"					},
		{ "ludwig",			"qWalkToXY",		6, 0						},
		{ "emily",			"qWait",			500							},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY0_23"	},
		
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}	
		
	-- play completed sequence
	qSequence(sequenceCompleted)   

end

-- set day
day = day0()