include("scripts/events/autographevent.lua")

-- set event
event = autographEvent()

-- day class
class 'day1' (interface)

day1.currentFanID = 1
day1.maxFanID = 3
day1.baseNames = ""

function day1:__init() super()
end

function day1:onLevelGlobals()

	self.baseNames =
	{
		"INGAME_CUSTOMER_FEMALE_BIGGIES",
		"INGAME_CUSTOMER_MALE_DESIGNER",
		"INGAME_CUSTOMER_FEMALE_CHILD"
	}

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.ludwig = pm:createPerson("ludwig")
	self.ludwig:setPosition(grid:getNode(28,19))
	self.ludwig:animate("IDLE", 0)
	
	self.francois = pm:createPerson("francois")
	self.francois:setPosition(grid:getNode(7,0))
	self.francois:animate("IDLE", 0)
	self.francois:setVisible(false)
	
	-- position everyone
--	entertainer:setPosition(entertainer:getHomeNode())
--    cleaner:setPosition(cleaner:getHomeNode())
    emily:setPosition(grid:getNode(7,0))

	-- set event configuration
	event.baseName = "INGAME_CUSTOMER_FEMALE_CHILD"
	event.baseSection = "customers"
	event.timeUntilEnterMin = 1000 * 15
	event.timeUntilEnterMax = 1000 * 30
	event.timeUntilAngry = 8000
	event.timeUntilLeave = 2000
	event.numPackages = 6
	event.entryX = 7
	event.entryY = 0
	event.waitX = 35
	event.waitY = 11
	event.workX = 32
	event.workY = 11
	event.waitAnim = "IDLE_WAITING"
	event.waitAnimFPS = 4
	event.angryAnim = "IDLE_WAITING_ANGRY"
	event.angryAnimFPS = 4
	event.workAnim = "IDLE"
	event.workAnimEmily = "AUTOGRAPH"
	event.scoreGotOne = 50
	event.scoreGotAll = 100
	event.package = "OBJECT_PACKAGE"
	
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "emily",			"qWalkToXY",		9, 14						},
		{ "ludwig",			"qSay",				"RESTAURANT3_DAY1_0"		},
		{ "emily",			"qWalkToXY",		24, 19						},
		{ "ludwig",			"qSay",				"RESTAURANT3_DAY1_1"		},
		{ "emily",			"qSay",				"RESTAURANT3_DAY1_2"		},
		{ "ludwig",			"qSay",				"RESTAURANT3_DAY1_3"		},
		{ "ludwig",			"qWalkToNode",		grid:getNode(28,21)			},
		{ "ludwig",			"qWalkToNode",		grid:getNode(20,21)			},
		{ "ludwig",			"qWalkToNode",		grid:getNode(7,0)			},
		{ "ludwig",			"qSetVisible",		false						},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									}
	}

	self.sequenceFinish = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "ludwig",			"qSetVisible",		true						},
		{ "ludwig",			"qWalkToXY",		12, 18						},
		{ "francois",		"qSetAppearance",	""  						},
		{ "francois",		"qSetVisible",		true						},
		{ "francois",		"qWait",			500							},
		{ "francois",		"qWalkToXY",		14, 15						},
		{ "francois",		"qSay",				"RESTAURANT3_DAY1_20"		},
		{ "ludwig",			"qSay",				"RESTAURANT3_DAY1_4"		},
		{ "francois",       "qSetAppearance",   "SAD"                       },
		{ "francois",		"qSay",				"RESTAURANT3_DAY1_5"		},
		{ "ludwig",         "qSetAppearance",   "ANGRY"                     },
		{ "ludwig",			"qSay",				"RESTAURANT3_DAY1_6"		},
		{ "emily",			"qSay",				"RESTAURANT3_DAY1_7"		},
		{ "ludwig",         "qSetAppearance",   ""                          },
		{ "ludwig",			"qSay",				"RESTAURANT3_DAY1_8"		},
		{ "francois",		"qAnimate",			"LAUGH", -1, 8				},
		{ "francois",		"qWait",			500							},
		{ "francois",		"qSetAppearance",	"HAPPY"						},
		{ "francois",		"qAnimate",			"IDLE", 0					},
		{ "francois",		"qSay",				"RESTAURANT3_DAY1_9"		},
		{ "ludwig",			"qSay",				"RESTAURANT3_DAY1_10"		},
		{ "francois",		"qSetAppearance",	""							},
		{ "ludwig",			"qSay",				"RESTAURANT3_DAY1_11"		},
		{ "francois",		"qSetAppearance",	"HAPPY"						},
		{ "francois",		"qSay",				"RESTAURANT3_DAY1_12"		},
		{ "ludwig",			"qSay",				"RESTAURANT3_DAY1_13"		},
		{ "francois",		"qSetAppearance",	"HAPPY"						},
		{ "francois",		"qSay",				"RESTAURANT3_DAY1_14"		},
		{ "scene", 			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									}
	}

end

function day1:onLevelInited()
end

function day1:onNotify(notification)
	
	if (notification == "about to enter") then
		self.currentFanID = self.currentFanID + 1
		
		event.baseName = self.baseNames[self.currentFanID]
		
		if (self.currentFanID == self.maxFanID) then
			self.currentFanID = 0
		end 
	
	end

end

function day1:onDayEnd()

	-- Make sure no new people come in:
	event.completed = true
	
	-- prevent walking out
	autoAllPeopleWalkOut = false
		
	-- play completed sequence
	qSequence(self.sequenceFinish)
	
end

-- set day
day = day1()