include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"Key",
}

-- day class
class 'day2' (interface)

day2.timeUntilSearchingMin = 8000
day2.timeUntilSearchingMax = 16000
day2.timer = 0

function day2:__init() super()
end

function day2:onLevelGlobals()

	-- create ludwig
	ludwig = pm:createPerson("ludwig")
	ludwig:setPosition(entryNode)

	-- position everyone
    cleaner:setPosition(grid:getNode(12, 20))
	cleaner:setAppearance("ANGRY")

	-- set event configuration
	event.baseName = ""
	event.entryX = 6
	event.entryY = 0
	event.highlightX = 17
	event.highlightY = 16
	event.timeUntilEnterMin = 1								-- minimum time the person waits outside
	event.timeUntilEnterMax = 2 							-- maximum time the person waits outside
	event.scoreFoundOne	= 50								-- score for finding one item
	event.scoreFoundAll	= 100								-- bonus for finding all items		
	event.sequenceStart	=
	{
		{ "scene",		"qNotify",				"show bar"						},
	}
	event.sequenceThanks = 
	{
        { "scene",      "qNotify",              "wave spectators"               },	
	}
	
	local sequenceStart	=
	{
		{ "emily",		"qWalkToXY",		15, 20								},
		{ "scene",		"qStartMovie" 											},

		{ "cleaner",	"qSay",				"RESTAURANT3_DAY2_0"				},
		{ "cleaner",	"qSay",				"RESTAURANT3_DAY2_1"				},
		{ "cleaner",	"qWalkToNode",		grid:getCleanerNode()				},
		{ "cleaner",	"qWait",			750									},
		
		{ "ludwig",		"qWalkToXY",		11, 20								},
		{ "ludwig",		"qSay",				"RESTAURANT3_DAY2_2"				},
		{ "ludwig",		"qSay",				"RESTAURANT3_DAY2_3"				},
		{ "ludwig",		"qSay",				"RESTAURANT3_DAY2_4"				},
		{ "emily",		"qSay",				"RESTAURANT3_DAY2_5"				},
		{ "ludwig",		"qAnimate",			"LAUGH", -1, 8						},
		{ "ludwig",		"qWait",			750									},
		{ "ludwig",		"qSetAppearance",	"HAPPY"								},
		{ "ludwig",		"qAnimate",			"IDLE", 0							},
		{ "ludwig",		"qSay",				"RESTAURANT3_DAY2_6"				},
		{ "ludwig",		"qWalkToNode",		entryNode							},
		{ "ludwig",		"qDestroy"												},

		{ "scene",		"qFinishMovie" 											},
		{ "scene",		"qStartGame" 											},
		{ "cleaner",	"qSetAppearance",	""									},		
	}
	
	autoStartGame = false
	autoAllPeopleWalkIn = false

	-- play start sequence
	qSequence(sequenceStart)	
end

function day2:onLevelInited()

    -- show all keys from the start
	event:onNotify("ho_arrived")

end

function day2:onTick(time)
	if (event.completed == true) then
		return
	end
end

function day2:onDayEnd()
	-- prevent walking out
	autoAllPeopleWalkOut = false
	
	local sequenceCompleted = 
	{
		{ "scene",			"qStartMovie" 									},

		{ "emily",			"qWalkToXY",		15, 20						},
		{ "emily",			"qSetAppearance",	"SAD"						},	
		{ "cleaner",		"qWalkToXY",		11, 20						},	
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_10"		},	
		{ "emily",			"qSay",				"RESTAURANT3_DAY2_11"		},	
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_12"		},	
		{ "cleaner",		"qSetAppearance",	"HAPPY"						},
		{ "cleaner",		"qSay",				"RESTAURANT3_DAY2_13"		},	

		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}	
		
	-- play completed sequence
	qSequence(sequenceCompleted)   

end


-- set day
day = day2()
