include("scripts/events/ordertelephoneevent.lua")

event = orderTelephoneEvent()

-- day class
class 'day3' (interface)

function day3:__init() super()
end

function day3:onLevelGlobals()
	
	event.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"
	event.pool = 										-- product pool
	{ 
		"CHEESECAKE",
		"TIRAMISU",
		"MEAT_READY_SALTPEPPER",
		"MEAT_READY_OREGANO",
		"FISH_READY_SALTPEPPER",
		"FISH_READY_OREGANO",
		"LASAGNE_OREGANO_READY",
		"LASAGNE_SALTPEPPER_READY",
		"CARPACCIO_SALTPEPPER",
		"CARPACCIO_OREGANO"
	}					
	event.chances = 									-- product chances
	{ 	
		100,
		100,
		30,
		20,
		30,
		10,
		20,
		30,
		60,
		20
	}						
	event.timeUntilRingMin = 60 * 1000				-- minimum time until the phone rings
	event.timeUntilRingMax = 70 * 1000				-- maximum time until the phone rings
	event.timeUntilNextOrder = 12 * 1000				-- interval at which the orders come
	event.timeUntilEnd = 200 * 1000					-- time allowed to make all products
	event.waitX = 44								-- position the mailman waits inside
	event.waitY = 24
	event.workX = 38								-- position emily will be to deliver the order
	event.workY = 24
	event.workTelephoneOffsetX = -3					-- position emily will be to answer the phone relative to it
	event.workTelephoneOffsetY = 0					
	event.numProductsPerOrder = 2					-- number of products ordered each order
	event.numOrders = 8							-- total number of orders
	event.workAnim = "IDLE"							-- animation played by mailman
	event.score = 40
	event.scoreClient = emily
	event.maxBalloonSize = 5
	event.sequenceRing =
	{
		{ "scene",		"qNotify", 			"start ordering"			},
	}
	
	event.sequenceDone =
	{
		{ "emily",		"qNotify",			"win lose" 					},
	}
	event.sequenceWin =
	{
		{ "emily",		"qAnimate",			"JUMP", 1					},
		{ "emily",		"qWait",			500							},
		{ "emily",		"qAnimate",			"IDLE", 0					},
		{ "mailman",	"qDestroy",			"event.mailman"				},
	}
	event.sequenceLose =
	{	
		{ "scene",		"qStartMovie"									},	
		{ "emily",		"qWorkOn",			"telephone" 				},		
		{ "emily",		"qSetAppearance",	"SAD"						},
		{ "mailman",	"qWalkToNode",		"movieNode" 				},
		{ "mailman",	"qDestroy",			"event.mailman"				},
		{ "scene",		"qFinishMovie" 									},	
	}
	
	event.telephoneBarOffsetX = 30
	event.telephoneBarOffsetY = -155
	
	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	ludwig = pm:createPerson("ludwig")
	ludwig:setPosition(grid:getNode(45, 24))
	emily:setPosition(entryNode)
	cleaner:setPosition(cleaner:getHomeNode())
	
	local sequenceStart =
	{
		{ "scene",		"qStartMovie"									},
		{ "emily",		"qWalkToXY",		38, 24						},
		{ "emily",		"qSay",				"RESTAURANT3_DAY3_0"		},
		{ "ludwig",		"qSetAppearance",	"CONFUSED"					},
		{ "ludwig",		"qSay",				"RESTAURANT3_DAY3_1"		},
		{ "ludwig",		"qSetAppearance",	""							},
		{ "emily",		"qSetAppearance",   "OFFENDED"					},
		{ "emily",		"qSay",				"RESTAURANT3_DAY3_2"		},
		{ "emily",		"qSetAppearance",   ""							},
		{ "emily",		"qSay",				"RESTAURANT3_DAY3_3"		},
		{ "ludwig",		"qSay",				"RESTAURANT3_DAY3_4"		},
		{ "emily",		"qSay",				"RESTAURANT3_DAY3_5"		},
		{ "ludwig",		"qSay",				"RESTAURANT3_DAY3_6"		},
		{ "ludwig",		"qSay",				"RESTAURANT3_DAY3_7"		},
		{ "emily",		"qSetAppearance",   "OFFENDED"					},
		{ "emily",		"qSay",				"RESTAURANT3_DAY3_8"		},
		{ "ludwig",		"qSetAppearance",   "HAPPY"						},
		{ "ludwig",		"qSay",				"RESTAURANT3_DAY3_9"		},
		{ "",			"parallel"										},
		{ "emily",		"qWalkToNode",		grid:getCounterNode()		},
		{ "emily",		"qSetAppearance",   ""							},
		{ "ludwig",		"qWalkToNode",		exitNode					},
		{ "ludwig",		"qDestroy"										},
		{ "",			"sequential"									},
		{ "scene",		"qFinishMovie"									},
		{ "scene",		"qStartGame"									},
	}
	
	qSequence(sequenceStart)
	
end

-- set the day
day = day3()
