include("scripts/events/npcchaseevent.lua")

-- set event
event = npcChaseEvent()
-- day class
class 'day4' (interface)

day4.timmeh = nil
day4.ludwig = nil

function day4:__init() super()
end

function day4:onLevelGlobals()
	
	self.ludwig = pm:createPerson("ludwig")
	self.ludwig:setAppearance("ANGRY")
	self.timmeh = pm:createPerson("timmeh")
	self.timmeh:setAppearance("STALKER")
	self.timmeh.coordinates =
		{
			{  7, 12, 10, 12, "WORK_LEFT" },
			{  9, 30,  6, 30, "WORK_RIGHT" },
			{ 38, 12, 35, 12, "WORK_RIGHT" },
			{ 37, 30, 34, 30, "WORK_RIGHT" },
			{ 29, 12, 32, 12, "WORK_LEFT" },
			{ 38, 12, 35, 12, "WORK_RIGHT" },
			{  7, 12, 10, 12, "WORK_LEFT" },
			{  9, 30,  6, 30, "WORK_RIGHT" },
			{ 38, 12, 35, 12, "WORK_RIGHT" },
			{ 37, 30, 40, 30, "WORK_RIGHT" }
		}
		
	self.timmeh.arrivalAnim = "IDLE"
	self.timmeh.sequenceCaught = 
	{
		{ "",			"sequential"								},
		{ "scene",		"qStartMovie" 								},
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_10"	},
		{ "timmeh",		"qSay",				"RESTAURANT3_DAY4_11"	},
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_12"	},
		{ "timmeh",		"qWalkToNode",		entryNode				},
		{ "timmeh",		"qSetVisible",		false					},
		{ "scene",		"qFinishMovie" 								},
	}
	
	event:addChaseNpc(self.timmeh)
	
	event.timeUntilEnterMin = 5 * 1000
	event.timeUntilEnterMax = 10 * 1000
	event.scoreGotOne = 25
	event.scoreGotAll = 50
	event.actionDuration = 0
	event.timerReturn = 1000 * 8
	event.caughtSounds = {"SOUND_EVENT_COMPLETE_ITEM"}
	event.overheadY = 31
	
	event.sequenceStart = 
	{
		{ "scene",		"qStartMovie" 									},
    	{ "",			"sequential"									},
    	{ "timmeh",		"qSetPosition",		entryNode					},
    	{ "ludwig",		"qSetPosition",		entryNode					},
    	{ "timmeh",		"qWalkToXY",		28, 13						},
    	{ "",			"parallel"										},
    	{ "timmeh",		"qSay",				"RESTAURANT3_DAY4_0"		},
    	{ "emily",		"qWalkToNode",		grid:getCounterNode()		},
    	{ "",			"sequential"									},
    	{ "emily",		"qAnimate",			"LAUGH", 3					},
    	{ "emily",		"qSetAppearance",	"LAUGH"						},
    	{ "emily",		"qSay",				"RESTAURANT3_DAY4_1"		},
    	{ "ludwig",		"qWalkToXY",		6, 13						},
    	{ "ludwig",		"qSay",				"RESTAURANT3_DAY4_2"		},
    	{ "emily",		"qAnimate",			"IDLE",	 0					},
    	{ "emily",		"qSetAppearance",	""							},
    	{ "emily",		"qSay",				"RESTAURANT3_DAY4_3"		},
    	{ "ludwig",		"qSetAppearance",	"ANGRY"						},
    	{ "ludwig",		"qSay",				"RESTAURANT3_DAY4_4"		},
    	{ "emily",		"qSetAppearance",	"SAD"						},
    	{ "emily",		"qSay",				"RESTAURANT3_DAY4_5"		},
    	{ "ludwig",		"qWalkToNode",		entryNode					},
    	{ "ludwig",		"qSetVisible",		false						},
    	{ "ludwig",     "qDestroy",         "day.ludwig"                },
    	{ "emily",		"qSetAppearance",	""							},
    	{ "scene",		"qFinishMovie" 									},
    	{ "scene",		"qNotify",			"chase start"				},
    }
    
    event.sequenceDayEnd = 
	{
		{ "",			"sequential"								},
		{ "scene",		"qStartMovie" 								},
		{ "timmeh",		"qSetVisible",		true					},
		{ "",			"parallel"									},
		{ "timmeh",		"qWalkToXY",		28, 13					},
		{ "emily",		"qWalkToXY",		24, 13					},
		{ "",			"sequential"								},
		
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_20"	},
		{ "timmeh",		"qSay",				"RESTAURANT3_DAY4_21"	},
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_22"	},
		{ "timmeh",		"qSay",				"RESTAURANT3_DAY4_23"	},
		{ "emily",      "qSetAppearance",	"NEUTRAL"				},
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_24"	},
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_40"	},
		{ "timmeh",		"qSay",				"RESTAURANT3_DAY4_25"	},
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_26"	},
		{ "emily",      "qSetAppearance",	""			        	},
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_27"	},
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_28"	},
		{ "timmeh",		"qSay",				"RESTAURANT3_DAY4_29"	},
		{ "emily",      "qSetAppearance",	"NEUTRAL"				},
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_30"	},
		{ "timmeh",		"qSay",				"RESTAURANT3_DAY4_31"	},
		{ "emily",		"qSetAppearance",	"SAD"					},
		{ "emily",		"qSay",				"RESTAURANT3_DAY4_32"	},
		{ "timmeh",		"qWalkToNode",		entryNode				},

		{ "scene",		"qFinishMovie" 								},
		{ "scene",		"qFinishGame" 								},
	}
	
end

function day4:createPerson(class)

	local result = nil
	if (class == "timmeh") then
		result = chaseNpc("INGAME_CUSTOMER_MALE_REGULAR")
		result:setType(class)
		result:setDefaultSection("customers")
		
	end
	
	return result
end

-- set the day
day = day4()
