-- day class
class 'day5' (interface)

day5.sequenceStart = nil
day5.sequenceFinish = nil
day5.ludwig = nil
day5.choices = { "LAUGH", "THROW", "TASTE", "SHOW" }
day5.questions = { "RESTAURANT3_DAY5_21", "RESTAURANT3_DAY5_22", "RESTAURANT3_DAY5_23", "RESTAURANT3_DAY5_24", "RESTAURANT3_DAY5_25" }
day5.answers = { "SHOW", "TASTE", "THROW", "SHOW", "LAUGH" }
day5.reverts = { "RESTAURANT3_DAY5_31", "RESTAURANT3_DAY5_32", "RESTAURANT3_DAY5_33", "RESTAURANT3_DAY5_34", "RESTAURANT3_DAY5_35" }
day5.index = 0
day5.heighest = 1
day5.scoreInc = 100
day5.scoreDec = -50

function day5:__init() super()
end

function day5:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.ludwig = pm:createPerson("ludwig")
	self.ludwig:setAppearance("HAPPY")
	self.ludwig:animate("HANDSHAKE_RIGHT", 0)
	entertainer:animate("HANDSHAKE_LFT", 0)	
	
	self.sequenceStart =
	{
		{ "scene",		"qStartMovie" 											},
		{ "",			"parallel"												},
		{ "ludwig",		"qWait",					500							},
		{ "ludwig",		"qAnimate",					"HANDSHAKE_RIGHT", 1		},
		{ "ludwig",		"qWait",					1500						},
		{ "ludwig",		"qAnimate",					"IDLE", 0					},
		{ "entertainer","qWait",					500							},
		{ "entertainer","qAnimate",					"HANDSHAKE_LFT", 1			},
		{ "entertainer","qWait",					1500						},
		{ "entertainer","qAnimate",					"IDLE", 0					},		
		{ "emily",		"qWalkToNode",				grid:getCounterNode()		},		
		{ "",			"sequential"											},
		{ "emily",		"qSay",						"RESTAURANT3_DAY5_0"		},
		{ "entertainer","qSay",						"RESTAURANT3_DAY5_1"		},
		{ "entertainer","qSay",						"RESTAURANT3_DAY5_2"		},
		{ "ludwig",		"qSay",						"RESTAURANT3_DAY5_3"		},
		{ "ludwig",		"qSay",						"RESTAURANT3_DAY5_4"		},
		{ "emily",		"qSetAppearance",			"CONFUSED"					},
		{ "emily",		"qSay",						"RESTAURANT3_DAY5_5"		},
		{ "emily",		"qSetAppearance",			""							},
		{ "ludwig",		"qSay",						"RESTAURANT3_DAY5_6"		},
		{ "ludwig",		"qWalkToXY",				8, 14						},
		{ "ludwig",		"qSay",						"RESTAURANT3_DAY5_7"		},		
		{ "ludwig",		"qSay",						"RESTAURANT3_DAY5_8"		},
		{ "ludwig",		"qWalkToXY",				8, 0						},
		{ "ludwig",		"qSetVisible",				false						},
		{ "entertainer","qWalkToNode",				entertainer:getHomeNode()	},
		{ "emily",		"qWalkToNode",				grid:getCounterNode()		},
		{ "scene",		"qFinishMovie" 											},
		{ "scene",		"qStartGame" 											},
	}
	
	self.sequenceFinish =
	{
		{ "scene",		"qStartMovie",				false						},
		{ "emily",		"qWalkToXY",				14,	19						},
		{ "ludwig",		"qSetAppearance",			""							},
		{ "ludwig",		"qSetVisible",				true						},
		{ "ludwig",		"qWalkToXY",				8, 14						},
		{ "ludwig",		"qSay",						"RESTAURANT3_DAY5_10"		},
		{ "ludwig",		"qSay",						"RESTAURANT3_DAY5_11"		},
		{ "ludwig",		"qSay",						"RESTAURANT3_DAY5_12"		},
		{ "emily",		"qSetAppearance",			"CONFUSED"					},
		{ "emily",		"qSay",						"RESTAURANT3_DAY5_14"		},
		{ "emily",		"qSetAppearance",			""							},
		{ "cameraMan",	"qWalkToXY",				3, 32						},
		{ "cameraMan",	"qWalkToXY",				9, 32						},
		{ "cameraMan",	"qWalkToXY",				14, 23						},
		{ "cameraMan",	"qAnimate",					"KNEEL_UP", 0				},	
		{ "ludwig",		"qSay",						"RESTAURANT3_DAY5_15"		},		
		{ "ludwig",		"qAnimate",					"CLAPPER", 1, false, -1, true	},
		{ "ludwig",		"qWait",					400								},		
		{ "ludwig",		"qAnimate",					"IDLE", 0						},
		{ "scene",		"qFinishMovie" 											},
		{ "emily",		"qSay",						"RESTAURANT3_DAY5_16"		},				
		{ "scene",		"qNotify",					"next question"				},
	}
	
	self.sequenceComplete =
	{
		{ "scene",		"qStartMovie" 											},
		{ "emily",		"qAnimate",					"IDLE", 0					},
		{ "cameraMan",	"qWalkToXY",				cameraManHomeX, cameraManHomeY	},		
		{ "ludwig",		"qSay",						"RESTAURANT3_DAY5_40"		},
		{ "emily",		"qSetAppearance",			"NEUTRAL"					},
		{ "emily",		"qSay",						"RESTAURANT3_DAY5_41"		},
		{ "scene",		"qFinishMovie" 											},
		{ "scene",		"qFinishGame" 											},
	}
	
end

function day5:onLevelInited()

	cleaner:setPosition(cleaner:getHomeNode())
	entertainer:setPosition(grid:getNode(15, 21))
	self.ludwig:setPosition(grid:getNode(12, 21))
	emily:setPosition(entryNode)
	
	entertainer:setAnchorBotY(entertainer:getAnchorBotY() - 1)
	entertainer:reposition(entertainer:getScreenX(), entertainer:getScreenY() - 1)		

	qSequence(self.sequenceStart)

end

function day5:onDayBegin()
end

function day5:onDayEnd()

	autoAllPeopleWalkOut = false
	qSequence(self.sequenceFinish)

end

function day5:onNotify(notification)

	if (notification == "next question") then
		self:gotoNext()
	
	end
	
	if (notification == "prev question") then
		self:gotoPrev()
	
	end

end

function day5:onClickMessage(text, result)

	if (text == self.questions[self.index]) then
		if (result == self.answers[self.index]) then
			-- correct
			emily:qPlaySound("SOUND_EVENT_COMPLETE_ITEM")
			emily:qAnimate(self.answers[self.index], 1, false, -1, true)
			emily:qWait(1000)
			emily:qNotify("next question")
		
		else
			incScore(self.scoreDec, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)		
		
			-- incorrect
			emily:qPlaySound("SOUND_EVENT_BAD")			
			emily:qAnimate("IDLE", 0)
			self.ludwig:qSetAppearance("ANGRY")
			self.ludwig:qSay("RESTAURANT3_DAY5_30")
			self.ludwig:qSetAppearance("")
			self.ludwig:qSay(self.reverts[self.index])
			self.ludwig:qNotify("prev question")
		
		end	
	end

end

function day5:gotoNext()

	self.index = self.index + 1
	
	if (self.index > self.heighest) then
		incScore(self.scoreInc, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)
		self.heighest = self.index
			
	end
	
	if (self.index == 1) then
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(table.getn(self.questions))
		eventBar:setProgress(0)		
		eventBar:setDescriptionText(getText("EVENTBAR"))
		eventBar:setSubjectImage("OBJECT_CLAPPER_BAR", player:getCurrentResourceSection())
		eventBar:animateToActive()
		
	end
	
	eventBar:setProgress(self.index - 1)
	
	if (self.index > table.getn(self.questions)) then
		eventBar:animateToDeactive()
		emily:playSound("SOUND_EVENT_COMPLETE_ALL")
		qSequence(self.sequenceComplete)
		
	else
		self:askQuestion()
		
	end

end

function day5:gotoPrev()

	if (self.index > 1) then
		self.index = self.index - 1
	
	end
	
	eventBar:setProgress(self.index - 1)
	
	self:askQuestion()

end

function day5:askQuestion()

	local choice0 = self.answers[self.index]
	
	-- get random choice1
	local choice1 = self.answers[self.index]		
	while (choice1 == choice0) do
		local n = getRandom(table.getn(self.answers)) + 1
		choice1 = self.answers[n]
	
	end
	
	-- get random choice2
	local choice2 = self.answers[self.index]
	while ((choice2 == choice0) or (choice2 == choice1)) do
		local n = getRandom(table.getn(self.answers)) + 1
		choice2 = self.answers[n]
	
	end		
	
	-- get random choice3
	local choice3 = ""
	
	emily:qSayChoice(self.questions[self.index], choice0, choice1, choice2, choice3, choice0)	

end

-- set day
day = day5()