include("scripts/events/brokenobjectevent.lua")


class 'curtainBack' (D2Object)

function curtainBack:__init() super()
end

function curtainBack:onCreate()

	self:setDefaultSection(player:getCurrentResourceSection())
	self:animate(self:getBaseName(), 0)

end



-- set event
event = brokenObjectEvent()
event.targetType = "Curtain"
event.workAnimationFrameRate = 6
event.replaceWhenReady = false


-- day class
class 'day6' (interface)

day6.backCurtain = nil
day6.sequenceFinishUp = nil

function day6:__init() super()
end

function day6:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
		
	self.ludwig = pm:createPerson("npc")
	self.ludwig:setPosition(grid:getNode(28,19))
	self.ludwig:setBaseName("INGAME_PERSON_BOSS")
	self.ludwig:setName("LUDWIG")
	self.ludwig:animate("IDLE", 0)

	-- set initial positions
	emily:setPosition(grid:getNode(24,19))
	emily:setAppearance("LAUGH")
	self.ludwig:animate("IDLE", 0)
	

	event.brokenObject.readyTime = 1000
	
	-- set event configuration
	event.animFix = "FIX_L"
	event.soundFix = "SOUND_PREPARING_DESSERT_LOOP"
	event.sequenceStart = nil
	event.timeUntilFixed = 1000 * 90
	event.score = 300

	event.pbY = -10
	event.brokenObject.pbY = -10

	self.curtainUp = createSprite()
	self.curtainUp:setDefaultSection(player:getCurrentResourceSection())
	self.curtainUp:animate("EVENT_CURTAIN", 0)
	self.curtainUp:setAlpha(0)
	self.curtainUp:setX(16)
	self.curtainUp:setY(0)
	level:getLayer(LAYER_FEATURES):addChild(self.curtainUp)
	
	self.raiseCurtain = false				-- Should the curtain be raised? (Only when event is finished)
	self.curtainRaiseSpeed = 0.07			-- factor number: twice as high means twice as fast.

	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 											},
		{ "emily",			"qSay",						"RESTAURANT3_DAY6_0"		},
		{ "ludwig",	 		"qAnimate",					"NOD", -1, 4				},
		{ "ludwig",	 		"qSay",						"RESTAURANT3_DAY6_YES"		},
		{ "ludwig",	 		"qAnimate",					"IDLE", 0					},
		{ "emily", 			"qSetAppearance",			"IDLE"				 		},
		{ "emily",			"qSay",						"RESTAURANT3_DAY6_1"		},
		{ "ludwig",	 		"qAnimate",					"NOD", -1, 4				},
		{ "ludwig",	 		"qSay",						"RESTAURANT3_DAY6_YES"		},
		{ "ludwig",	 		"qAnimate",					"IDLE", 0					},
		{ "emily", 			"qSetAppearance",			"IDLE_NEUTRAL"		 		},
		{ "emily",			"qSay",						"RESTAURANT3_DAY6_2"		},
		{ "ludwig",	 		"qAnimate",					"NOD", -1, 4				},
		{ "ludwig",	 		"qSay",						"RESTAURANT3_DAY6_YES"		},
		{ "ludwig",	 		"qAnimate",					"IDLE", 0					},
		{ "emily", 			"qSetAppearance",			"SURPRISED"			 		},
		{ "emily",			"qSay",						"RESTAURANT3_DAY6_3"		},
		{ "ludwig",	 		"qAnimate",					"NOD", -1, 4				},
		{ "ludwig",			"qSay",						"RESTAURANT3_DAY6_4"		},
		{ "ludwig",	 		"qAnimate",					"IDLE", 0					},
		{ "emily", 			"qSetAppearance",			"SAD"			 			},
		{ "emily",			"qSay",						"RESTAURANT3_DAY6_5"		},
		{ "ludwig",			"qSetAppearance",			"HAPPY"						},
		{ "ludwig",			"qSay",						"RESTAURANT3_DAY6_6"		},
		{ "ludwig",			"qWait",					500							},
		{ "ludwig",			"qWalkToNode",				grid:getNode(28,21)			},
		{ "ludwig",			"qWalkToNode",				grid:getNode(20,21)			},
		{ "ludwig",			"qWalkToNode",				"movieNode"					},
		{ "ludwig",			"qDestroy",					"day.ludwig"				},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qStartGame" 											},
		{ "brokenObject", 	"setOverheadY", 			250							},
		{ "brokenObject", 	"qCreateOverhead", 			"INGAME_ARROW"				},
		{ "emily", 			"qSetAppearance",			""				 			}
	}

	event.sequenceWin =
	{
		{ "scene",			"qStartMovie" 											},
		{ "", 				"parallel"												},
		{ "emily",			"qWalkToXY",				14, 20						},
		{ "entertainer", 	"qWalkToXY",				38, 18						},
		{ "",	 			"sequential"											},
		{ "brokenObject",	"setAlpha",					0							},
		{ "backCurtain",	"setAlpha",					0							},
		{ "curtainUp",		"setAlpha",					1							},
		{ "scene",			"qNotify",					"raise curtain"				}
	}
	
	self.sequenceFinishUp = 
	{
		{ "emily",			"qAnimate",					"JUMP", 1					},
		{ "emily",			"qWait",					500							},
		{ "emily",			"qAnimate",					"IDLE", 0					},
		{ "entertainer", 	"qSay",						"RESTAURANT3_DAY6_7"		},
		{ "entertainer", 	"qSay",						"RESTAURANT3_DAY6_8"		},
		{ "entertainer", 	"qSay",						"RESTAURANT3_DAY6_9"		},
		{ "scene",			"qFinishMovie" 											}
	}
	
end

function day6:onNotify(notification)
	if (notification == "raise curtain") then
		self.raiseCurtain = true
	end

end


function day6:onTick(time)

	if (self.raiseCurtain) then
		local currentY = self.curtainUp:getY()
		local newY = currentY - ( self.curtainRaiseSpeed * time )
		
		if (newY > -300) then
			self.curtainUp:setY(newY) 
		else 
			self.raiseCurtain = false
			qSequence(self.sequenceFinishUp)
		end
		
	end

end

function day6:createObject(desc)

	if (desc:getType() == "CurtainBack") then
		result = curtainBack()
		result:setType(desc:getType())
		self.backCurtain = result
		return result
	end
	
	return nil
	
end

-- set day
day = day6()