include("scripts/events/droppedobjectevent.lua")

-- set event
event = droppedObjectEvent()

-- day class
class 'day7' (interface)

day7.entertainerIdleCheck = true

day7.idleWaitTimeMin = 1000
day7.idleWaitTimeMax = 5000
day7.idleWaitTimer = 0
day7.idleLoopsMin = 1
day7.idleLoopsMax = 3
day7.ludwig = nil

function day7:__init() super()
end

function day7:onLevelGlobals()
	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	entertainer:setPosition(entertainer:getHomeNode())
	entertainer:setAppearance("DRUNK")
	entertainer:setDefaultFrameRate(8)
	entertainer:animate("TWIZZLE", -1)
	entertainer:setWalkTimePerNode(120)
	
	emily:setPosition(entryNode)
	cleaner:setPosition(cleaner:getHomeNode())
	
	self.ludwig = pm:createPerson("ludwig")
	self.ludwig:setVisible(false)
	self.ludwig:setPosition(entryNode)
	self.ludwig:setOverheadFrameTime(1000)	
	
	event.hookType = "EntertainTask"
	event.person = entertainer
	event.timeUntilDropMin = 200
	event.timeUntilDropMax = 800
	event.timeUntilDropInt = 300
	event.dropChance = 90
	event.dropIgnore = 2	
	event.preset = "rest3_microphone.d2p"	
	event.areas = 
	{
		{  1, 11, 10, 13 },
		{ 15, 29, 21, 33 },
		{  9, 18, 15, 20 },
		{ 37, 11, 41, 13 },
		{ 31, 29, 38, 30 },
	}
	
	event.sequenceDroppedFirst = 
	{
		{ "entertainer",	"qSay",				"RESTAURANT3_DAY7_10" 		},
		{ "entertainer",	"qWait",			100							},
		{ "entertainer",	"qAnimate",			"TWIZZLE", -1				},
		{ "entertainer",	"qWait",			500							},
	}	
	event.sequenceDropped = 
	{
		{ "entertainer",	"qWait",			300							},
		{ "entertainer",	"qAnimate",			"TWIZZLE", -1				},
		{ "entertainer",	"qWait",			500							},
	}
	
	
	local storySequence = 
	{
		{ "scene",			"qStartMovie"										},
		
		{ "entertainer",	"qSetWalkTimePerNode",		120						},
		{ "entertainer",	"qWalkToXY",				16, 30					},
		{ "entertainer",	"qAnimate",					"TWIZZLE", -1			},
		{ "entertainer",	"qWait",					750						},
		{ "entertainer",	"qWalkToXY",				26, 29					},
		{ "entertainer",	"qAnimate",					"TWIZZLE", -1			},
		{ "entertainer",	"qWait",					750						},
		
		{ "",				"parallel"											},
		{ "emily",			"qWalkToXY",				16, 18					},
		{ "cleaner",		"qWait",					1000					},
		{ "cleaner",		"qWalkToXY",				12, 18					},
		{ "entertainer",	"qWalkToXY",				33, 31					},
		{ "entertainer",	"qAnimate",					"TWIZZLE", -1			},
		{ "entertainer",	"qWait",					750						},
		{ "entertainer",	"qWalkToXY",				38, 27					},
		{ "entertainer",	"qAnimate",					"TWIZZLE", -1			},
		{ "entertainer",	"qWait",					750						},
		
		{ "",				"sequential"										},
		{ "entertainer",	"qWalkToXY",				42, 29					},
		{ "entertainer",	"qAnimate",					"TWIZZLE", -1			},
		{ "cleaner",		"qSay",						"RESTAURANT3_DAY7_0"	},
		{ "entertainer",	"qWait",					750						},
		{ "entertainer",	"qWalkToXY",				22, 29					},
		{ "entertainer",	"qAnimate",					"TWIZZLE", -1			},
		{ "cleaner",		"qSay",						"RESTAURANT3_DAY7_1"	},
		{ "entertainer",	"qWait",					750						},
		{ "entertainer",	"qWalkToNode",				entertainer:getHomeNode() },
		{ "entertainer",	"qAnimate",					"TWIZZLE", 2			},
		{ "cleaner",		"qSay",						"RESTAURANT3_DAY7_2"	},
		{ "entertainer",	"qWait",					750						},
		
		
		{ "emily",			"qWalkToXY",				15, 34					},
		{ "emily",          "qSetAppearance",           "NEUTRAL"               },
		{ "emily",			"qSay",						"RESTAURANT3_DAY7_3"	},
		{ "entertainer",	"qSay",						"RESTAURANT3_DAY7_4"	},
		{ "emily",			"qSay",						"RESTAURANT3_DAY7_5"	},
		{ "entertainer",	"qSay",						"RESTAURANT3_DAY7_6"	},
		{ "emily",			"qSay",						"RESTAURANT3_DAY7_7"	},
		
		{ "ludwig",         "qSetVisible",              true                    },
		{ "ludwig",         "qWalkToXY",                9,	16                  },
		{ "ludwig",			"qSay",						"RESTAURANT3_DAY7_8"	},
        
        { "",               "parallel"                                          },						
		{ "ludwig",			"qCreateOverhead",			"INGAME_COUNTDOWN_ICON"	},
		{ "ludwig",			"qWait",					4000					},	
		{ "ludwig",			"qClearOverhead"									},
		{ "ludwig",			"qAnimate",					"CLAPPER", 1, false, -1, true	},
		{ "ludwig",			"qWait",					400								},		
		{ "ludwig",			"qAnimate",					"IDLE", 0						},
		{ "emily",			"qWalkToNode",				grid:getCounterNode()	},		
		{ "emily",          "qSetAppearance",           ""                      },		
		{ "cleaner",		"qWait",					1000					},
		{ "cleaner",		"qWalkToNode",				cleaner:getHomeNode()	},
		{ "",				"sequential"										},

        { "ludwig",         "qWait",                    500                     },		
		{ "ludwig",         "qWalkToNode",              entryNode               },
		{ "ludwig",         "qDestroy",                 "day.ludwig"            },
		{ "scene",			"qFinishMovie"										},
		{ "scene",			"qStartGame"										},
	}
	
	qSequence(storySequence)
end

function day7:onDayEnd()
	
	autoAllPeopleWalkOut = false
	
	local endSequence =
	{
		{ "scene",			"qStartMovie"										},
		
		{ "",				"parallel"											},
		{ "entertainer",	"qSetAppearance",			"SAD"					},
		{ "entertainer",	"qAnimate",					"IDLE", 0				},
		{ "entertainer",	"qWalkToXY",				19, 30					},
		{ "emily",			"qWalkToXY",				15, 30					},
		
		{ "",				"sequential"										},
		{ "emily",          "qSetAppearance",			"NEUTRAL"				},
		{ "emily",			"qSay",						"RESTAURANT3_DAY7_20"	},
		{ "entertainer",	"qSetAppearance",			"ASHAMED"				},
		{ "entertainer",	"qSay",						"RESTAURANT3_DAY7_21"	},
		{ "emily",			"qSay",						"RESTAURANT3_DAY7_35"   },
		{ "entertainer",	"qSetAppearance",			"SAD"					},
		{ "entertainer",	"qSay",						"RESTAURANT3_DAY7_22"	},
		{ "entertainer",	"qSay",						"RESTAURANT3_DAY7_23"	},
		{ "emily",			"qSetAppearance",			"SURPRISED"				},		
		{ "entertainer",	"qSay",						"RESTAURANT3_DAY7_24"	},
		{ "entertainer",	"qSay",						"RESTAURANT3_DAY7_25"	},
		{ "entertainer",	"qSay",						"RESTAURANT3_DAY7_26"	},
		{ "entertainer",	"qSay",						"RESTAURANT3_DAY7_27"	},
		{ "emily",			"qSetAppearance",			"NEUTRAL"				},
		{ "emily",			"qSay",						"RESTAURANT3_DAY7_28"	},
		{ "emily",			"qAnimate",					"LAUGH", 1				},
		{ "emily",			"qSetAppearance",			"LAUGH"					},
		{ "emily",			"qSay",						"RESTAURANT3_DAY7_29"	},
		{ "cleaner",		"qSetAppearance",			"ANGRY"					},
		{ "cleaner",		"qSay",						"RESTAURANT3_DAY7_30"	},
		{ "entertainer",	"qSetAppearance",			""						},
		{ "entertainer",	"qAnimate",					"LAUGH", 1				},
		{ "entertainer",	"qSay",						"RESTAURANT3_DAY7_31"	},
		{ "cleaner",		"qSetAppearance",			""						},
		{ "emily",			"qSetAppearance",			""						},
		{ "emily",			"qSay",						"RESTAURANT3_DAY7_32"	},
		
		{ "scene",			"qFinishMovie"										},
		{ "scene",			"qFinishGame"										},
	}
	
	qSequence(endSequence)
end

function day7:onTick(time)
	
	-- Hack to make sure the entertainer plays the right idle animation
	if (entertainer ~= nil) then
	
		if (entertainer:isBusy()) then
			
			self.entertainerIdleCheck = true
		
		else
			self.idleWaitTimer = self.idleWaitTimer - time
			
			if (self.idleWaitTimer < 0 or self.entertainerIdleCheck == true) then
				entertainer:animate("TWIZZLE", getRandomRange(self.idleLoopsMin, self.idleLoopsMax))
				self.entertainerIdleCheck = false
				self.idleWaitTimer = getRandomRange(self.idleWaitTimeMin, self.idleWaitTimeMax)
			end
			
		end
		
	end
	
end

-- set the day
day = day7()
