-- day class
class 'day8' (interface)

day8.yardsTotal = 2000	-- textual number (gui / dialogs)
day8.nodesTotal = 6400	-- internal number 
day8.sequenceStart = nil
day8.sequenceWin = nil
day8.sequenceFinish = nil
day8.nodesLeft = 0
day8.started = false
day8.completed = false
day8.score = 100


function day8:__init() super()
end

function day8:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	self.nodesLeft = self.nodesTotal
	
	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(cleaner:getHomeNode())
	entertainer:setPosition(entertainer:getHomeNode())
		
	ludwig = pm:createPerson("ludwig")	
	ludwig:setAppearance("ECSTATIC")
	ludwig:setPosition(exitNode)

	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 										},		

		{ "ludwig",			"qWalkToXY",		12,	18							},		
		{ "ludwig",			"qWait",			500								},		
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY8_0"		},		
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_1"		},
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY8_2"		},		
		{ "emily",          "qSetAppearance",   "CONFUSED"                      },
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_3"		},
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY8_4"		},		
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_5"		},
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY8_6"		},		
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_7"		},
		{ "ludwig",			"qSetAppearance",	""								},	
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY8_8"		},		
		{ "ludwig",			"qSetAppearance",	"HAPPY"							},	
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY8_9"		},	
		{ "emily",          "qSetAppearance",   "NEUTRAL"                       },	
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY8_10"		},		
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY8_11"		},		
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY8_12"		},		
		{ "ludwig",			"qSetAppearance",	""								},	
		{ "ludwig",			"qSay",				"TEXT_RESTAURANT3_DAY8_13"		},		
		{ "ludwig",			"qWalkToXY",		entryX, entryY					},
		{ "ludwig",			"qDestroy"											},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qStartGame" 										},
		{ "emily",          "qSetAppearance",   ""                              },	
	}
	
	self.sequenceWin = 
	{
		{ "scene",			"qStartMovie" 										},		
		
		{ "entertainer",	"qSetAppearance",	"HAPPY"							},
		{ "entertainer",	"qSay",				"TEXT_RESTAURANT3_DAY8_20"		},		
		{ "entertainer",	"qSay",				"TEXT_RESTAURANT3_DAY8_21"		},
		{ "entertainer",	"qSetAppearance",	""								},
				
		{ "scene",			"qFinishMovie" 										},
	}

	-- play start sequence
	qSequence(self.sequenceStart)
end

function day8:onDayBegin()
	eventBar:setSubjectImage("EVENT_PANDAS_BAR", player:getCurrentResourceSection())
	eventBar:setDescriptionText(getText("EVENTBAR"))
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(self.yardsTotal)
	eventBar:setProgress(0)	
	eventBar:animateToActive()
	eventBar:raiseCurtain()
	self.started = true

end

function day8:onDayEnd()

	emily:setAppearance("SAD")

	-- prevent walking out
	autoAllPeopleWalkOut = false
	
	local sequenceCompleted = 
	{
		{ "scene",			"qStartMovie" 									},
		
		{ "emily",			"qWalkToXY",		17,	19						},
		{ "cleaner",		"qWalkToXY",		13,	19						},		
		{ "cleaner",		"qWait",			500							},
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT3_DAY8_30"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_31"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_32"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_33"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_34"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_35"	},
		{ "cleaner",        "qSetAppearance",   "HAPPY"                     },
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT3_DAY8_36"	},
		{ "emily",          "qSetAppearance",   "NEUTRAL"                   },
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_37"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT3_DAY8_38"	},
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT3_DAY8_39"	},
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT3_DAY8_40"	},
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT3_DAY8_41"	},
		
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}	
		
	-- play completed sequence
	qSequence(sequenceCompleted)   

end

function day8:onLockToNode(actor, node)

	if (self.started and not self.completed) then
		if ((actor:getType() == "emily") or (actor:getType() == "cleaner") or (actor:getType() == "entertainer")) then
			self.nodesLeft = self.nodesLeft - 1
			
			local progress = 1 - (self.nodesLeft / self.nodesTotal)
			eventBar:setProgress(progress * self.yardsTotal)
			
			if (self.nodesLeft == 0) then
				eventBar:animateToDeactive()
				emily:playSound("SOUND_EVENT_COMPLETE_ALL")
				incScore(self.score, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)
				qInsertSequence(self.sequenceWin)
				self.completed = true
			
			end	
		end
	end
	
end

-- set day
day = day8()