-- just for hiddenObject class
-- event not used!
include("scripts/events/hiddenobjectevent.lua")

-- set event
-- just use 
event = interface()

-- day class
class 'day9' (interface)

day9.timeUntilEnterMin = 45000
day9.timeUntilEnterMax = 45001
day9.timeUntilPacked = 1000 * 45
day9.scoreFoundOne = 25
day9.scoreFoundAll = 100

day9.registeredTypes =
{
	"Clothing",
}
day9.sequenceDayBegin = nil
day9.sequenceEventStart = nil
day9.sequenceThanks = nil
day9.sequenceDone = nil
day9.sequenceWin = nil
day9.sequenceLose = nil
day9.items = {}
day9.countItems = 0
day9.countFound = 0
day9.started = false
day9.completed = false
day9.timer = 0
day9.highlightX = -1
day9.highlightY = -1
day9.suitcase = nil

function day9:__init() super()
end

function day9:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	entertainer:setPosition(entryNode)

	ludwig = pm:createPerson("ludwig")
	ludwig:setPosition(entryNode)
	ludwig:animate("IDLE", 0)
	ludwig:setVisible(false)

	cleaner:setPosition(grid:getNode(20, 18))	
	cleaner:setReturnHome(false)
	cleaner.clean = false
	emily:setPosition(grid:getCounterNode())
	
	self.timer = getRandomRange(self.timeUntilEnterMin, self.timeUntilEnterMax)
	self.sequenceDayBegin =
	{
		{ "scene",		"qStartMovie" 										},
		{ "cleaner",	"qSay",					"RESTAURANT3_DAY9_0",		},
		{ "",			"parallel"											},
		{ "entertainer","qWalkToXY",			12, 18						},
		{ "cleaner",	"qWait",				1500						},
		{ "cleaner",	"qSay",					"RESTAURANT3_DAY9_1",		},
		{ "",			"sequential"										},
		{ "entertainer","qSetAppearance",		"SAD"						},	
		{ "entertainer","qSay",					"RESTAURANT3_DAY9_2",		},
		{ "emily",      "qSetAppearance",		"NEUTRAL"					},	
		{ "emily",		"qSay",					"RESTAURANT3_DAY9_3",		},
		{ "entertainer","qCreateOverhead",		"INGAME_THINK_ICON"			},
		{ "entertainer","qWait",				2000						},
		{ "entertainer","qSetAppearance",		""							},
		{ "entertainer","qCreateOverhead",		"INGAME_LIGHT_ICON"			},
		{ "entertainer","qWait",				1500						},
		{ "entertainer","qRemoveOverhead"									},
		{ "entertainer","qSay",					"RESTAURANT3_DAY9_4",		},
		{ "emily",      "qSetAppearance",		""	        				},	
		{ "emily",		"qSay",					"RESTAURANT3_DAY9_5",		},
		{ "entertainer","qSetAppearance",		"HAPPY"						},
		{ "entertainer","qSay",					"RESTAURANT3_DAY9_6",		},
		{ "ludwig",		"qSetVisible",			true						},
		{ "ludwig",		"qWalkToXY",			14, 13						},
		{ "ludwig",		"qSay",					"RESTAURANT3_DAY9_7",		},
		{ "entertainer","qSay",					"RESTAURANT3_DAY9_8",		},
		{ "emily",      "qSetAppearance",		"NEUTRAL"	      			},	
		{ "emily",		"qSay",					"RESTAURANT3_DAY9_9",		},
		{ "entertainer","qSetAppearance",		""							},
		{ "ludwig",		"qSetAppearance",		"CONFUSED"					},
		{ "ludwig",		"qSay",					"RESTAURANT3_DAY9_10",		},
		{ "ludwig",		"qWalkToXY",			8, 13						},
		{ "ludwig",		"qSay",					"RESTAURANT3_DAY9_11",		},
		{ "ludwig",		"qWalkToXY",			8, 0						},
		{ "ludwig",		"qSetVisible",			false						},
		{ "ludwig",		"qSetAppearance",		""							},
		{ "cleaner",	"qSay",					"RESTAURANT3_DAY9_12",		},
		{ "cleaner",	"qWalkToXY",			9, 19						},
		{ "cleaner",	"qWalkToNode",			entryNode					},
		{ "cleaner",	"qSetVisible",			false						},
		{ "entertainer","qWalkToNode",			entertainer:getHomeNode()	},
		{ "emily",      "qSetAppearance",		""	         				},	
		{ "scene",		"qFinishMovie" 										},
		{ "scene",		"qStartGame" 										},
	}
	
	self.sequenceEventStart =
	{
		{ "scene",		"qStartMovie" 										},
		{ "cleaner",	"qSetAppearance",		"SUITCASE"					},
		{ "cleaner",	"qSetVisible",			true						},
		{ "cleaner",	"qWalkToXY",			8, 12						},
		{ "cleaner",	"qWait",				1000						},
		{ "cleaner",	"qSetAppearance",		""							},
		{ "suitcase",	"qSetVisible",			true						},		
		{ "cleaner",	"qAnimate",				"IDLE_WAVE", -1, 8      	},
		{ "cleaner",	"qWait",				1500						},
		{ "cleaner",	"qAnimate",				"IDLE", 0					},
		{ "cleaner",	"qSay",					"RESTAURANT3_DAY9_20",		},
		{ "cleaner",	"qNotify",				"show items"				},
		{ "cleaner",	"qSay",					"RESTAURANT3_DAY9_21",		},
		{ "cleaner",	"qNotify",				"show bar"					},
		{ "scene",		"qFinishMovie" 										},
	}
	self.sequenceDone = 
	{
	    { "scene",		"qStartMovie" 										},
	    { "emily",		"qWalkToNode",			grid:getCounterNode()		},
	    { "emily",		"qSay",					"RESTAURANT3_DAY9_50",		},
	    { "scene",		"qFinishMovie" 										},
		{ "scene",		"qNotify",				"found all"					},
	}
	self.sequenceWin = 
	{
		{ "scene",		"qStartMovie" 										},
		{ "emily",		"qWalkToNode",			grid:getCounterNode()		},
		{ "cleaner",	"qSay",					"RESTAURANT3_DAY9_30",		},
		{ "ludwig",		"qSetPosition",			exitNode					},
		{ "ludwig",		"qSetVisible",			true						},
		{ "ludwig",		"qWalkToXY",			34, 13						},
		{ "emily",		"qSay",					"RESTAURANT3_DAY9_31",		},
		{ "entertainer","qSay",					"RESTAURANT3_DAY9_32",		},
		{ "entertainer","qWalkToXY",			38, 28						},
		{ "entertainer","qWalkToXY",			38, 13						},
		{ "entertainer","qWait",				500							},
		{ "entertainer","qAnimate",				"IDLE_LEFT", 0				},
		{ "entertainer","qSay",					"RESTAURANT3_DAY9_40",		},		

		{ "",			"parallel"											},		
		{ "ludwig",		"qAnimate",				"IDLE_RIGHT", 0				},
		{ "ludwig",		"qSay",					"RESTAURANT3_DAY9_41"		},
		{ "suitcase",	"qSetVisible",			false						},
		{ "cleaner",	"qSetAppearance",		"SUITCASE"					},
		{ "cleaner",	"qWalkToNode",			entryNode					},
		{ "emily",		"qWalkToNode",			entryNode					},
		{ "",			"sequential"										},
		{ "ludwig",		"qAnimate",				"IDLE", 0					},
		{ "ludwig",		"qSay",					"RESTAURANT3_DAY9_42",		},
		{ "ludwig",     "qSetAppearance",       "CONFUSED"                  },
		{ "ludwig",     "qWait",                1500                        },
		{ "ludwig",		"qSay",					"RESTAURANT3_DAY9_43",		},	
		
		{ "scene",		"qFadeToBlack"										},
		{ "scene",		"qFinishMovie" 										},
		{ "scene",		"qFinishGame"										},
	}
	self.sequenceLose =
	{
		{ "scene",		"qStartMovie" 										},
		{ "emily",		"qWalkToNode",			grid:getCounterNode()		},
		{ "ludwig",		"qSetPosition",			exitNode					},
		{ "ludwig",		"qSetVisible",			true						},
		{ "ludwig",		"qWalkToXY",			34, 13						},		
		{ "emily",		"qSay",					"RESTAURANT3_DAY9_35",		},
		{ "cleaner",	"qSay",					"RESTAURANT3_DAY9_36",		},
		{ "entertainer","qSay",					"RESTAURANT3_DAY9_37",		},
		{ "entertainer","qWalkToXY",			38, 28						},
		{ "entertainer","qWalkToXY",			38, 13						},
		{ "entertainer","qWait",				500							},
		{ "entertainer","qAnimate",				"IDLE_LEFT", 0				},
		{ "entertainer","qSay",					"RESTAURANT3_DAY9_40",		},		
		{ "",			"parallel"											},		
		{ "ludwig",		"qAnimate",				"IDLE_RIGHT", 0				},
		{ "ludwig",		"qSay",					"RESTAURANT3_DAY9_41"		},
		{ "emily",		"qWalkTo",				"suitcase"					},
		{ "emily",		"qAnimate",				"FIX", -1					},
		{ "emily",		"qWait",				3000						},
		{ "emily",		"qNotify",				"packed suitcase"			},		
		{ "emily",		"qWalkToXY",			12, 12						},
		{ "",			"sequential"										},
		{ "",			"parallel"											},
		{ "suitcase",	"qSetVisible",			false						},
		{ "cleaner",	"qSetAppearance",		"SUITCASE"					},
		{ "cleaner",	"qWalkToNode",			entryNode					},
		{ "cleaner",    "qWait",                500                         },
		{ "emily",		"qWalkToNode",			entryNode					},
		{ "emily",      "qWait",                500                         },
		{ "",			"sequential"										},
		{ "ludwig",		"qAnimate",				"IDLE", 0					},
		{ "ludwig",		"qSay",					"RESTAURANT3_DAY9_42",		},
		{ "ludwig",     "qSetAppearance",       "CONFUSED"                  },
		{ "ludwig",     "qWait",                1500                        },		
		{ "entertainer","qSetAppearance",       "HAPPY"                     },
		{ "entertainer","qAnimate",             "IDLE", 0                   },
		{ "ludwig",		"qSay",					"RESTAURANT3_DAY9_43",		},		
		
		{ "scene",		"qFadeToBlack"										},
		{ "scene",		"qFinishMovie" 										},
		{ "scene",		"qFinishGame"										},
	}

end

function day9:onLevelInited()

	if (self.suitcase ~= nil) then
		self.suitcase:createHighlight()
		self.suitcase:setClickable(false)
		self.suitcase:setVisible(false)		
		
		self.suitcase.pb = createDefaultFillProgressBar();
		self.suitcase.pb:setProgress(0)	
		self.suitcase.pb:setY(23)
		self.suitcase.pb:setVisible(false)
		self.suitcase:addChild(self.suitcase.pb)		
	
	else
		warn("day9 - no suitcase found")
	
	end

	if (self.countItems > 0) then
		
	    -- hide all hidden items
		for index, value in ipairs(self.items) do
			value:setVisible(false)
		end
		
		-- initialize event bar
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(math.max(1, self.countItems))
		eventBar:setProgress(0)
		eventBar:setDescriptionText(getText("EVENTBAR0"))
		eventBar:setSubjectImage("OBJECT_SUITCASE_BAR", self.items[1]:getDefaultSection())

	else
		warn("day9 - no hidden object(s) found")
	
	end
	
	qSequence(self.sequenceDayBegin)

end

function day9:onNotify(notification)
	
	if (notification == "show items") then

	    -- show all hidden items
		for index, value in ipairs(self.items) do
			value:setVisible(true)
			
			if (value:getPosition():getGridX() == self.highlightX) then
				if (value:getPosition():getGridY() == self.highlightY) then
					value:createOverhead("INGAME_ARROW")
					
				end
			end
		end
	
	elseif (notification == "show bar") then

		-- show bar
		eventBar:animateToActive()
		eventBar:raiseCurtain()
	
	elseif (notification == "found all") then
	
		self.suitcase:setClickable(true)
		self.suitcase.timer = self.timeUntilPacked
		self.suitcase.state = "open"
		self.suitcase:createOverhead("INGAME_ARROW")
		self.suitcase.pb:setVisible(true)
	
		-- found all clothes
		-- initialize eventbar for suitcase fixing
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(100)
		eventBar:setProgress(0)
		eventBar:setDescriptionText(getText("EVENTBAR1"))
		eventBar:setSubjectImage("OBJECT_SUITCASE_BAR", self.items[1]:getDefaultSection())
		eventBar:animateToActive()
		eventBar:raiseCurtain()
	
	elseif (notification == "packed suitcase") then
	
	    -- hide all hidden items
--		for index, value in ipairs(self.items) do
--			value:setVisible(false)	
--		
--		end
		
		-- hide all packed items
		for index, value in ipairs(self.suitcase.packed) do
			value:setVisible(false)
		
		end
		
		-- hide all stacked items
		for index, value in ipairs(self.suitcase.stack) do
			value:setVisible(false)
		
		end
		
		-- close suitcase
		self.suitcase.front:setVisible(false)
		self.suitcase:animate("OBJECT_SUITCASE_CLOSED", 0)
		self.suitcase:playSound("SOUND_EVENT_COMPLETE_ALL")
	
	end

end

function day9:onDayBegin()
	
	self.started = true

end

function day9:onDayEnd()
	
	autoAllPeopleWalkOut = false
		
	if (self.completed) then
		qSequence(self.sequenceWin)
	
	else
		qSequence(self.sequenceLose)
	
	end

end

function day9:onTick(time)

	if (not self.started) then
		return
		
	end
	
	if (self.completed) then
		return
		
	end
	
	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
		    cleaner.clean = true
		    cleaner:setReturnHome(true)
			qSequence(self.sequenceEventStart)				
		
		end	
	end

end

function day9:onDone()

	self.completed = true
	eventBar:animateToDeactive()

end

function day9:createObject(desc)
  
  	result = nil
  
	for index, value in ipairs(self.registeredTypes) do
		if (value == desc:getType()) then
			result = hiddenObject()
			result.event = self
			result:setType(desc:getType())
			break;
		
		end
	end  	
  
	if (result ~= nil) then
		self.items[ self.countItems+1 ] = result;
		self.countItems = self.countItems + 1  
  
	elseif (desc:getType() == "Suitcase") then
		result = suitcaseObject()
		result.event = self
		result:setType(desc:getType())
		self.suitcase = result
	
	end
  
  	return result

end

function day9:onClickObject(object)

	if (object:getType() == "Clothing") then
		local baseName = object:getBaseName() .. "_FOLDED"
		local objectFolded = createSprite()
		
		objectFolded:setDefaultSection(player:getCurrentResourceSection())
		objectFolded:animate(baseName, 0)
		
		self.suitcase:addToStack(objectFolded)
	
	end

end

-- set day
day = day9()

-- a suitcase
class 'suitcaseObject' (D2Object)

suitcaseObject.front = nil
suitcaseObject.event = nil
suitcaseObject.state = "idle"
suitcaseObject.timer = 0
suitcaseObject.pb = nil
suitcaseObject.stack = {}
suitcaseObject.stackX = 30
suitcaseObject.stackY = -25
suitcaseObject.stackDX = 0
suitcaseObject.stackDY = -5
suitcaseObject.packed = {}
suitcaseObject.packedX = -31
suitcaseObject.packedY = -30
suitcaseObject.packedDX = 28
suitcaseObject.packedDY = -5

function suitcaseObject:__init() super()
end

function suitcaseObject:onCreate()

	self:animate(self:getBaseName(), 0)
	self.front = createSprite()
	self.front:setDefaultSection(player:getCurrentResourceSection())
	self.front:animate("OBJECT_SUITCASE_FRONT", 0)
	self.front:setX(-32)
	self.front:setY(-16)
	self:addChild(self.front)

end

function suitcaseObject:addToStack(object)

	-- add object
	table.insert(self.stack, object)
	self:addChild(object)
	
	-- position object
	object:setX(self.stackX + self.stackDX * (table.getn(self.stack)-1))
	object:setY(self.stackY + self.stackDY * (table.getn(self.stack)-1))
	
end

function suitcaseObject:takeFromStack()

	if (table.getn(self.stack) > 0) then
		return table.remove(self.stack)
		
	end
	
	return nil

end

function suitcaseObject:addToSuitcase(object)

	-- add object
	table.insert(self.packed, object)
	self:addChild(object)
	self:addChild(self.front)
	
	-- count
	local count = table.getn(self.packed)
	
	if (count == 1) then
		object:setX(self.packedX + (self.packedDX * 0))
		object:setY(self.packedY + (self.packedDY * 0))	
	
	elseif (count == 2) then
		object:setX(self.packedX + (self.packedDX * 1))
		object:setY(self.packedY + (self.packedDY * 0))	
	
	elseif (count == 3) then
		object:setX(self.packedX + (self.packedDX * 0))
		object:setY(self.packedY + (self.packedDY * 1))		
	
	elseif (count == 4) then
		object:setX(self.packedX + (self.packedDX * 1))
		object:setY(self.packedY + (self.packedDY * 1))			
	
	elseif (count == 5) then
		object:setX(self.packedX + (self.packedDX * 0))
		object:setY(self.packedY + (self.packedDY * 2))		
		
	end	

end

function suitcaseObject:onClick()

	self:playSound("SOUND_OBJECT_CLICK")
	if (self:isSelected() == false) then
		if (self.state == "open") then
			self:setSelected(true)
			self:clearOverhead()
			emily:qWorkOn(self)
	
		end
	end

end

function suitcaseObject:onWorkStart(task)

	self:setSelected(false)
	self:playSound("SOUND_PREPARING_SUITCASE_LOOP", true)
	emily:animate("FIX", -1)
	
	return (self.state == "open")

end

function suitcaseObject:onWorkUpdate(task, time)

	self.timer = self.timer - time
	
	local progressOld = self.pb:getProgress()
	
	eventBar:setProgress((self.event.timeUntilPacked - self.timer) / self.event.timeUntilPacked * 100)
	self.pb:setProgress((self.event.timeUntilPacked - self.timer) / self.event.timeUntilPacked)	
	
	local progressCur = self.pb:getProgress()
	
	for i = 1,5 do
		if (progressOld < (0.2 * i)) then
			if (progressCur >= (0.2 * i)) then
				local object = self:takeFromStack()
				self:addToSuitcase(object)
				emily:playSound("SOUND_EVENT_COMPLETE_ITEM")
			
			end		
		end			
	end			


	if (self.timer <= 0) then
	
		self.timer = 0
		self.state = "packed"
		self.event:onDone()
		
		self:setSelected(false)
		self:setClickable(false)
		self.front:setVisible(false)
		self.pb:setVisible(false)
		self:animate("OBJECT_SUITCASE_CLOSED", 0)
		
		for index, value in ipairs(self.stack) do
			value:setVisible(false)
		end			
		for index, value in ipairs(self.packed) do
			value:setVisible(false)
		end	
		
		incScore(150, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)
		emily:playSound("SOUND_EVENT_COMPLETE_ALL")
				
		return true
	
	end
	
	return emily:hasTasksToDo()

end

function suitcaseObject:onWorkComplete(task)

	self:stopSound("SOUND_PREPARING_SUITCASE_LOOP")

end