include("scripts/appliances/popcornmachine.lua")
include("scripts/appliances/cottoncandyappliance.lua")
include("scripts/appliances/karaoke.lua")
include("scripts/appliances/hammerpole.lua")
include("scripts/products/regularproduct.lua")
include("scripts/products/popcornproduct.lua")
include("scripts/products/pancakeproduct.lua")
include("scripts/products/balloonproduct.lua")
include("scripts/persons/wanderer.lua")

-- entry node
-- npc's and such will be spawned at this location
entryX = 0
entryY = 15
entryNode = nil

-- exit node
exitX = 49
exitY = 15
exitNode =  nil

-- movie node
-- when a movie is playing and an npc's enters or exits (and gets destroyed),
-- it will do so from this node
movieX = entryX
movieY = entryY
movieNode = nil

-- restaurant class
class 'restaurant4' (interface)

restaurant4.wandererTimer = 0
restaurant4.timeUntilFirstWandererMin = 5000
restaurant4.timeUntilFirstWandererMax = 10000
restaurant4.timeUntilCheckWanderersMin = 7500
restaurant4.timeUntilCheckWanderersMax = 15000

function restaurant4:__init() super()
end

function restaurant4:onLevelInited()
	
	self.wandererTimer = getRandomRange(self.timeUntilFirstWandererMin, self.timeUntilFirstWandererMax)
	
	local dayIndex = player:getCurrentDayIndex()
	if (um:isProductLocked(dayIndex, "POPCORN")) then
		local object = getObject("rest4_pop_app")
		if (object ~= nil) then
			object:setVisible(false)
		end
	end
		
	if (um:isProductLocked(dayIndex, "BALLOON_BLUE")) then
		--cout("BALLOON_BLUE locked\n")
		local object = getAppliance("rest4_balloon_stand")
		if (object ~= nil) then
			local prod = object:getProduct("BALLOON_SWITCH_BLUE")
			prod:setVisible(false)
		end
	end
		
	if (um:isProductLocked(dayIndex, "BALLOON_ORANGE")) then
		--cout("BALLOON_ORANGE locked\n")
		local object = getAppliance("rest4_balloon_stand")
		if (object ~= nil) then
			local prod = object:getProduct("BALLOON_SWITCH_ORANGE")
			prod:setVisible(false)
		end	
	end
	
	local pancakeAppliance = getAppliance("rest4_pancake_stove")
	if (pancakeAppliance) then
		pancakeAppliance:getSlot(0):setName("slot1")
		pancakeAppliance:getSlot(1):setName("slot2")
	
	end
	
end

function restaurant4:onNotify(notification)

	if (notification == "trigger hammerpole") then
		getAppliance("rest4_hammerpole"):doNext()
	
	end

end

function restaurant4:createObject(desc)

	local result = nil
	if (desc:getType() == "PopcornMachine") then
		result = popcornMachine()
		result:createHighlight()
		result:getHighlight():setAlphaHitmaskThreshold(-1)
		result:setType(desc:getType())

	elseif (desc:getType() == "Karaoke") then
		result = karaoke()
		result:createHighlight()
		result:setType(desc:getType())
		result:setOverheadX(40)		
		
	elseif (desc:getType() == "CottonCandyPink") then
		result = cottonCandyAppliance("COTTON_CANDY_PINK")
		result:createHighlight()
		result:setType(desc:getType())
		result:setOverheadX(3)
		result:setOverheadY(38)
		
	elseif (desc:getType() == "CottonCandyBlue") then
		result = cottonCandyAppliance("COTTON_CANDY_BLUE")
		result:createHighlight()
		result:setType(desc:getType())
	
	elseif (desc:getType() == "HammerPole") then
		result = hammerPole()
		result:setType(desc:getType())
		result:createHighlight()
		
	end
	
	return result

end

function restaurant4:createProduct(base)

	local bubblePopX = 440
	local bubblePopY = 125
	
	local bubblePancakeX = 300
	local bubblePancakeY = 125

	local prod = nil
	
	if (type(base) == "string")	then
		if (base == "BERRY_JUICE") then
			prod = regularProduct(base)
			prod:setWorkTime(800)
			prod:setWorkAnimation("WORK")
			prod:setWorkSound("SOUND_POUR_FLUID")
			prod:setWorkOffsetX(-1)
		
		elseif (base == "ORANGE_JUICE") then
			prod = regularProduct(base)
			prod:setWorkTime(800)
			prod:setWorkAnimation("WORK")
			prod:setWorkSound("SOUND_POUR_FLUID")
			prod:setWorkOffsetX(1)
				
		elseif (base == "BEAR") then
			prod = regularProduct(base)
			prod:setWorkTime(800)
			prod:setWorkAnimation("WORK")
			prod:setWorkSound("SOUND_TEDDYBEAR")
			
		elseif (base == "ROSES") then
			prod = regularProduct(base)
			prod:setWorkTime(800)
			prod:setWorkAnimation("WORK")
			prod:setWorkSound("SOUND_PICK_TEA_GARDEN")
			
		elseif (base == "POPCORN") then
			prod = popcornProduct(base)
			prod:setWorkTime(0)
			prod:setWorkAnimation("WORK")
			prod:setWorkOffsetX(-1)
			prod:setWorkSound("SOUND_POPCORN_SCOOP")
			prod:setBubbleX(bubblePopX)
			prod:setBubbleY(bubblePopY)
			prod:setMachineName("rest4_popcorn_app")
			
		elseif (base == "SWEET") then
			prod = regularProduct(base)
			prod:setWorkTime(800)
			prod:setWorkAnimation("WORK")
			prod:setWorkOffsetX(-6)
			prod:setWorkSound("SOUND_ADD_PEPPER_SALT")
			prod:setBubbleX(bubblePopX)
			prod:setBubbleY(bubblePopY)
			
		elseif (base == "SALT") then
			prod = regularProduct(base)
			prod:setWorkTime(800)
			prod:setWorkAnimation("WORK")
			prod:setWorkOffsetX(-4)
			prod:setWorkSound("SOUND_ADD_PEPPER_SALT")
			prod:setBubbleX(bubblePopX)
			prod:setBubbleY(bubblePopY)
			
		elseif (base == "PANCAKEMIX") then
			prod = pancakeProduct(base)
			prod:setWorkTime(800)
			prod:setWorkAnimation("WORK")
			prod:setWorkOffsetX(1)
			prod:setWorkSound("SOUND_GRAB_SQUID_CAVIAR")
			prod.applianceName = "rest4_pancake_stove"
			prod:setBubbleX(bubblePancakeX)
			prod:setBubbleY(bubblePancakeY)
			
		elseif (base == "POWDER") then
			prod = regularProduct(base)
			prod:setWorkTime(800)
			prod:setWorkAnimation("WORK")
			prod:setWorkOffsetX(6)
			prod:setWorkSound("SOUND_ADD_PEPPER_SALT")
			prod:setBubbleX(bubblePancakeX)
			prod:setBubbleY(bubblePancakeY)
			
		elseif (base == "SYRUP") then
			prod = regularProduct(base)
			prod:setWorkTime(800)
			prod:setWorkAnimation("WORK")
			prod:setWorkOffsetX(5)
			prod:setWorkSound("SOUND_SQUIRT_SAUCE_ON_RIBS")
			prod:setBubbleX(bubblePancakeX)
			prod:setBubbleY(bubblePancakeY)
			
		elseif (base == "COTTON_CANDY_PINK") then
			prod = cottonCandyProduct(base)
			prod:setWorkTime(400)
			prod:setWorkAnimation("WORK_FRONT")
			
		elseif (base == "COTTON_CANDY_BLUE") then
			prod = cottonCandyProduct(base)
			prod:setWorkTime(400)
			prod:setWorkAnimation("WORK_FRONT")
			
		elseif (base == "BALLOON_BLUE") then
			prod = regularProduct(base)
			prod:setWorkTime(600)
			prod:setWorkAnimation("WORK_FRONT")
			
		elseif (base == "BALLOON_ORANGE") then
			prod = regularProduct(base)
			prod:setWorkTime(600)
			prod:setWorkAnimation("WORK_FRONT")
			
		elseif (base == "BALLOON_SWITCH_ORANGE") then
			prod = balloonButton(base)
			prod:setWorkTime(1800)
			prod:setBalloonColor("ORANGE")
			prod:setWorkAnimation("WORK")
			prod:getTimer():setCircleImage("TIMER_CIRCLE_BALLOON")
			prod:getTimer():setX(31)
			prod:getTimer():setY(-40)
			prod:setWorkOffsetX(2)
			
		elseif (base == "BALLOON_SWITCH_BLUE") then
			prod = balloonButton(base)
			prod:setWorkTime(1800)
			prod:setBalloonColor("BLUE")
			prod:setWorkAnimation("WORK")
			prod:getTimer():setCircleImage("TIMER_CIRCLE_BALLOON")
			prod:getTimer():setX(70)
			prod:getTimer():setY(-40)
			prod:setWorkOffsetX(0)
			
		end
		
	elseif (type(base) == "userdata") then
		
		if (base:getBase() == "PANCAKEMIX") then
			prod = pancakeProduct(base)
		end
	
	end
	
	return prod
	
end

function restaurant4:createPerson(class)

	local result = nil
	
	if (class == "cleaner") then
		local baseName = "INGAME_PERSON_FRANCOIS"
		if (player:getCurrentDayIndex() > 6) then
			baseName = "INGAME_PERSON_BULLY"
		end
		result = d2cleaner(baseName)
		result:setType(class)
		result:animate("IDLE", 0)
		result.clean = true

	elseif (class == "mayor") then
		result = npc("INGAME_PERSON_MAYOR")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "charles") then
		result = npc("INGAME_PERSON_CHARLES")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "tashi") then
		result = npc("INGAME_PERSON_TASHI")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "matthew") then
		result = npc("INGAME_PERSON_MATTHEW")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "betty") then
		result = npc("INGAME_PERSON_BETTY")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "elvis") then
		result = npc("INGAME_PERSON_ELVIS")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "beagle") then
		result = npc("INGAME_PERSON_BEAGLE")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "ted") then
		result = npc("INGAME_PERSON_SPECIAL_SHOWMASTER")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "mailman") then
		result = npc("INGAME_PERSON_SPECIAL_MAILMAN")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "francois") then
		local baseName = "INGAME_PERSON_FRANCOIS"
		if (player:getCurrentDayIndex() == 9) then
			baseName = "INGAME_PERSON_FRANCOISWHEELCHAIR"
		end	
		result = npc(baseName)
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "cameraman") then
		result = npc("INGAME_PERSON_SPECIAL_CAMERAMAN")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "mo") then
		result = npc("INGAME_PERSON_SPECIAL_MECHANIC")
		result:setType(class)
		result:animate("IDLE", 0)
	
	elseif (class == "wanderer") then
		local baseNames =
		{
			"INGAME_CUSTOMER_FEMALE_CHILD",
			"INGAME_CUSTOMER_MALE_CHILD",
			"INGAME_CUSTOMER_FEMALE_REGULAR",
			"INGAME_CUSTOMER_MALE_REGULAR",	
			"INGAME_CUSTOMER_FEMALE_ELDERLY",
			"INGAME_CUSTOMER_MALE_ELDERLY",				
		}
		local singSounds = 
		{
			"SOUND_SINGING_CHILD_LOOP",
			"SOUND_SINGING_CHILD_LOOP",
			"SOUND_SINGING_FEMALE_LOOP",
			"SOUND_SINGING_MALE_LOOP",
			"SOUND_SINGING_FEMALE_LOOP",
			"SOUND_SINGING_MALE_LOOP",
		}
		local random = getRandom(table.getn(baseNames)) + 1
		result = wanderer(baseNames[random])
		result.singSound = singSounds[random]
		result:setType(class)
		result:animate("IDLE", 0)
		
	end
	
	return result

end	

function restaurant4:onTick(time)

	if (scene:isClosed()) then
		return
		
	end
	

	if (scene:isPlayingMovie()) then
		return
	
	end
	
	if (scene:isStartingMovie()) then
		return
		
	end

	if (self.wandererTimer > 0) then
		self.wandererTimer = self.wandererTimer - time
		if (self.wandererTimer <= 0) then
			if (wandererPersonsCount < 3) then
				pm:createPerson("wanderer")
				
			end
			
			self.wandererTimer = getRandomRange(self.timeUntilCheckWanderersMin, self.timeUntilCheckWanderersMax)
		end
	end

end

function restaurant4:onDayEnd()

	if (player:getCurrentDayIndex() >= 2) then
		local karaokeAppliance = getAppliance("rest4_karaoke")
		if (karaokeAppliance) then
			karaokeAppliance:setClickable(false)
			karaokeAppliance:setSelected(false)
	
		end
	end

end

-- set restaurant
restaurant = restaurant4()