-- day class
class 'day1' (interface)

day1.mayor = nil
day1.charles = nil
day1.update = false
day1.karaoke = nil
day1.pb = nil
day1.completed = false

function day1:__init() super()
end

function day1:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.mayor = pm:createPerson("mayor")
	self.mayor:setVisible(false)
	self.mayor:setPosition(entryNode)
	self.charles = pm:createPerson("charles")
	self.charles:setVisible(false)
	self.charles:setPosition(entryNode)
	
	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(cleaner:getHomeNode())

	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 											},
		{ "mayor",			"qSetVisible",				true						},
		{ "mayor",			"qWalkToXY",				20, 30						},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_0"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_1"		},
		{ "mayor",			"qSetAppearance",			"SAD"						},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY1_2"		},
		{ "emily",			"qSetAppearance",			"CONFUSED"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_3"		},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY1_4"		},
		{ "emily",			"qSetAppearance",			"SHOCK"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_5"		},
		{ "emily",			"qWait",					300							},
		{ "emily",			"qCreateOverhead",			"INGAME_THINK_ICON"			},
		{ "emily",			"qWait",					2000						},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qCreateOverhead",			"INGAME_LIGHT_ICON"			},
		{ "emily",			"qWait",					1500						},
		{ "emily",			"qRemoveOverhead"										},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_6"		},
		{ "mayor",			"qSetAppearance",			""							},		
		{ "cleaner",		"qSetAppearance",			"HAPPY"						},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY1_7"		},
		{ "emily",			"qSetAppearance",			"BLUSH"						},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY1_8"		},
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "mayor",			"qWalkToNode",				exitNode					},
		{ "mayor",			"qDestroy",					"day.mayor"					},
		{ "emily",			"qSetAppearance",			"OFFENDED"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_9"		},
		{ "cleaner",		"qAnimate",					"LAUGH", -1, 8				},
		{ "cleaner",		"qWait",					750							},
		{ "cleaner",		"qAnimate",					"LAUGH", 0					},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY1_10"		},
		{ "cleaner",		"qAnimate",					"IDLE", 0					},
		{ "emily",			"qSetAppearance",			""							},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qStartGame" 											},		
		{ "karaoke",		"qCreateOverhead",			"INGAME_ARROW"				},
	}
	self.sequenceWin = 
	{
		{ "scene",			"qStartMovie" 											},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qAnimate",					"JUMP", 1, false, -1, true	},
		{ "emily",			"qWait",					500							},
		{ "emily",			"qAnimate",					"IDLE", 0					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_20"		},
		{ "cleaner",		"qSetAppearance",			"HAPPY"						},
		{ "cleaner",		"qWalkToXY",				20, 18						},
		{ "cleaner",		"qAnimate",					"CLAP", -1					},
		{ "cleaner",		"qWait",					1000						},
		{ "cleaner",		"qAnimate",					"IDLE", 0					},		
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY1_21"		},
		{ "cleaner",		"qWalkToNode",				cleaner:getHomeNode()		},
		{ "scene", 			"qFinishMovie" 											},
		{ "charles",		"qDestroy",					"day.charles"				},
	}
	self.sequenceLose =
	{
		{ "scene",			"qStartMovie" 											},
		{ "emily",			"qWalkToNode",				grid:getCounterNode()		},
		{ "emily",			"qSetAppearance",			"SAD"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_30"		},
		{ "charles",		"qSetAppearance",			"RUN"						},
		{ "charles",		"qSetWalkTimePerNode",		35							},
		{ "charles",		"qSetVisible",				true						},
		{ "charles",		"qWalkToXY",				20, 30						},
		{ "charles",		"qSay",						"RESTAURANT4_DAY1_31"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_32"		},
		{ "charles",		"qSetAppearance",			"HAPPY"						},
		{ "charles",		"qSay",						"RESTAURANT4_DAY1_33"		},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_34"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_35"		},
		{ "charles",		"qSay",						"RESTAURANT4_DAY1_36"		},
		{ "emily",			"qSetAppearance",			"LAUGH"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY1_37"		},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qFinishGame" 											},
	}
	
	self.karaoke = getAppliance("rest4_karaoke")
	if (self.karaoke) then
		self.karaoke.event = true
			
		-- initialize event bar
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(self.karaoke.eventEarnTarget)
		eventBar:setProgress(0)	
		eventBar:setSubjectImage("EVENT_MICROPHONE_BAR", player:getCurrentResourceSection())
		eventBar:setDescriptionText(getText("EVENTBAR"))
		
		-- initialize progress bar
		self.pb = createDefaultKaraokeProgressBar();
		self.pb:setProgress(0)	
		self.pb:setX(-18)
		self.pb:setY(-53)
		self.pb:setVisible(false)
		self.karaoke:addChild(self.pb)		
	end
	
end

function day1:onLevelInited()

	qSequence(self.sequenceStart)

end

function day1:onDayBegin()

	eventBar:animateToActive()
	eventBar:raiseCurtain()
	self.pb:setVisible(true)

end

function day1:onDayEnd()

	if (not self.completed) then
		-- prevent walking out
		autoAllPeopleWalkOut = false
		
		-- play completed sequence
		qSequence(self.sequenceLose)
	    
	end

end

function day1:onTick(time)

	if (self.update) then
		self:updateEventBar()
		
	end

end

function day1:onTaskStart(actorType, taskType, p0, p1)

	if (actorType == "emily") then
		if (taskType == "ActorTask") then
			if (p0:getType() == "Karaoke") then
				self.update = true
			
			end		
		end	
	end

end

function day1:onTaskComplete(actorType, taskType, p0, p1)

	if (actorType == "emily") then
		if (taskType == "ActorTask") then
			if (p0:getType() == "Karaoke") then
				self:updateEventBar()
				self.update = false
			
			end		
		end	
	end

end

function day1:updateEventBar()

	eventBar:setProgress(self.karaoke.eventEarned)
	self.pb:setProgress(self.karaoke.eventEarned / self.karaoke.eventEarnTarget)
		
	if (self.karaoke.eventEarned == self.karaoke.eventEarnTarget) then
		eventBar:animateToDeactive()
		self.pb:setVisible(false)
		self.completed = true
		self.karaoke:removeHighlight()
		qInsertSequence(self.sequenceWin)
	
	end

end

-- set day
day = day1()