include("scripts/events/mailmanevent.lua")

-- set event
event = mailmanEvent()

-- day class
class 'day2' (interface)

function day2:__init() super()
end

function day2:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.mayor = pm:createPerson("mayor")
	self.mayor:setPosition(grid:getNode(0,15))
	self.mayor:setName("MAYOR")
	self.mayor:setVisible(false)
	
	-- position everyone
    emily:setPosition(grid:getCounterNode())
    cleaner:setPosition(cleaner:getHomeNode())

	-- set event configuration
	event.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"
	event.timeUntilEnterMin = 1000 * 15
	event.timeUntilEnterMax = 1000 * 20
	event.timeUntilAngry = 8000
	event.timeUntilLeave = 6000
	event.numPackages = 12
	event.entryX = 49
	event.entryY = 14
	event.waitX = 39
	event.waitY = 17
	event.workX = 35
	event.workY = 17
	event.angryAnim = "IDLE_WAITING"
	event.workAnim = "GIVE_LEFT"
	event.workAnimEmily = "WORK_RIGHT"
	event.scoreGotOne = 25
	event.scoreGotAll = 100
	event.package = "OBJECT_PACKAGE"
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "mayor",			"qSetVisible",		true						},
		{ "mayor",			"qWalkToXY",		24, 24						},
		{ "mayor",			"qSetAppearance",	"HAPPY"						},
		{ "mayor",			"qSay",				"RESTAURANT4_DAY2_0"		},
		{ "emily",			"qSetAppearance",	"CONFUSED"					},
		{ "emily",			"qWalkToXY",		28, 27						},
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_1"		},
		{ "mayor",			"qSay",				"RESTAURANT4_DAY2_2"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "mayor",			"qSay",				"RESTAURANT4_DAY2_3"		},
		{ "emily",			"qSetAppearance",	"SURPRISED"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_4"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_5"		},
		{ "mayor",			"qSay",				"RESTAURANT4_DAY2_6"		},
		{ "mayor",			"qSay",				"RESTAURANT4_DAY2_7"		},
		{ "emily",			"qSetAppearance",	"CONFUSED"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_8"		},
		{ "mayor",			"qSetAppearance",	""							},
		{ "emily",			"qSetAppearance",	""							},
		{ "mayor",			"qSay",				"RESTAURANT4_DAY2_9"		},
		{ "mayor",			"qSay",				"RESTAURANT4_DAY2_10"		},
		{ "emily",			"qSetAppearance",	"SURPRISED"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_11"		},
		{ "mayor",			"qSetAppearance",	"HAPPY"						},
		{ "emily",			"qSetAppearance",	""							},
		{ "mayor",			"qSay",				"RESTAURANT4_DAY2_12"		},
		{ "mayor",			"qSetAppearance",	""							},
		{ "mayor",			"qSay",				"RESTAURANT4_DAY2_13"		},
		{ "emily",			"qSay",				"RESTAURANT4_DAY2_14"		},
		{ "mayor",			"qWalkToXY",		 0, 15						},
		{ "mayor",			"qDestroy"										},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									}
	}
	event.sequenceComplete = 
	{
		{ "emily",			"qWait",			2000						},
		{ "emily",			"qAnimate",			"JUMP", 1					},
		{ "emily",			"qWait",			500							},
		{ "emily",			"qAnimate",			"IDLE", 0					},	
	}

end

-- set day
day = day2()