include("scripts/events/ordertableevent.lua")

-- set event
event = orderTableEvent()

-- day class
class 'day3' (interface)

day3.contestant1 = nil -- Arty Farty
day3.contestant2 = nil -- Biggie
day3.contestant3 = nil -- Elvis
day3.contestant4 = nil -- Betty

day3.table1 = nil
day3.shouldOrder = true

function day3:__init() super()
end

function day3:onLevelGlobals()

	-- set tables
	self.table1 = om:getTable(1)
	self.table1:setReserved(true)

	-- create contestants
	self.contestants = {}
	
	self.contestant1 = pm:createPerson("fakecustomer")
	self.contestant1:setPosition(grid:getNode(0,15))
	self.contestant1.state = "READ"
	self.contestant1.timer = 1
	self.contestant1:setBaseName("INGAME_CUSTOMER_MALE_DESIGNER")
	self.contestant1:setVisible(false)
	
	self.contestant2 = pm:createPerson("fakecustomer")
	self.contestant2:setPosition(grid:getNode(0,15))
	self.contestant2.state = "READ"
	self.contestant2.timer = 1
	self.contestant2:setBaseName("INGAME_CUSTOMER_MALE_BIGGIES")
	self.contestant2:setVisible(false)
	
	self.contestant3 = pm:createPerson("elvis")
	self.contestant3:setPosition(grid:getNode(0,15))
	self.contestant3.state = "READ"
	self.contestant3.timer = 1
	self.contestant3:setBaseName("INGAME_PERSON_ELVIS")
	self.contestant3:setVisible(false)
	
	self.contestant4 = pm:createPerson("betty")
	self.contestant4:setPosition(grid:getNode(0,15))
	self.contestant4.state = "READ"
	self.contestant4.timer = 1
	self.contestant4:setBaseName("INGAME_PERSON_BETTY")
	self.contestant4:setVisible(false)
	
	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(grid:getCleanerNode())

	-- set event configuration
	event.pool = 										-- product pool
	{ 
		"BERRY_JUICE", 
		"ORANGE_JUICE",
		"COTTON_CANDY_BLUE",
		"COTTON_CANDY_PINK",
		"POPCORN_SALT",
		"PANCAKEMIX_READY_SYRUP",
		"PANCAKEMIX_READY_POWDER"
	}					
	event.chances = 									-- product chances
	{ 	
		10, 
		10,
		30,
		30,
		70,
		60,
		60
	}
	event.timeUntilEnterMin = 1000
	event.timeUntilEnterMax = 3000		
	event.timeUntilNextOrder = 27000						-- interval at which the orders come
	event.timeUntilEnd = 330000							-- time allowed to make all products
	event.timeTransfer = 400							-- time it takes to transfer the order	
	event.numProductsPerOrder = 2						-- number of products ordered each order
	event.numOrders = 10								-- total number of orders
	event.score = 40
	event.maxBalloonSize = 15
	event.table = self.table1
	event.subjectImage = "EVENT_EATING_CONTEST_BAR"
	event.sequenceStart = 
	{
		{ "scene",				"qNotify",			"start"						},	
		{ "scene",				"qStartMovie" 									},
		{ "",					"parallel"										},
		{ "contestant1",		"qSetPosition",		"entryNode" 				},
		{ "contestant1",		"qWait",			200							},
		{ "contestant1",		"qSetVisible",		true		 				},
		{ "contestant1",		"qSitAt",			"table1", 0					},
		{ "contestant2",		"qSetPosition",		"entryNode" 				},
		{ "contestant2",		"qWait",			500							},
		{ "contestant2",		"qSetVisible",		true		 				},
		{ "contestant2",		"qSitAt",			"table1", 1					},
		
		{ "contestant3",		"qSetPosition",		"entryNode" 				},
		{ "contestant3",		"qWait",			700							},
		{ "contestant3",		"qSetVisible",		true		 				},
		{ "contestant3",		"qWalkToXY",		11, 26						},
		{ "contestant4",		"qSetPosition",		"entryNode" 				},
		{ "contestant4",		"qWait",			1100						},
		{ "contestant4",		"qSetVisible",		true		 				},
		{ "contestant4",		"qWalkToXY",		15, 26						},
		{ "",					"sequential"									},

		{ "contestant4",		"qSetAppearance",	"HAPPY"						},
		{ "contestant4",		"qSay",				"RESTAURANT4_DAY3_0"		},
		{ "emily",				"qWalkToNode",		grid:getCounterNode()		},
		{ "emily",				"qSetAppearance",	"LAUGH"						},
		{ "emily",				"qSay",				"RESTAURANT4_DAY3_1"		},
		{ "emily",				"qSetAppearance",	""							},
		{ "contestant4",		"qSetAppearance",	"LOVE"						},
		{ "contestant4",		"qSay",				"RESTAURANT4_DAY3_2"		},
		{ "contestant3", 		"qAnimate",			"ENTERTAIN", -1				},
		{ "contestant3", 		"qWait",			1000						},
		{ "contestant3", 		"qAnimate",			"IDLE", 0					},
		{ "emily",				"qSetAppearance",	"LAUGH"						},
		{ "emily",				"qSay",				"RESTAURANT4_DAY3_3"		},
		{ "contestant4",		"qSetAppearance",	"HAPPY"						},
		{ "emily",				"qSetAppearance",	"HAPPY"						},
		{ "contestant4",		"qSay",				"RESTAURANT4_DAY3_4"		},
		{ "contestant4",		"qSay",				"RESTAURANT4_DAY3_5"		},
		{ "contestant4",		"qSay",				"RESTAURANT4_DAY3_6"		},
		{ "emily",				"qSay",				"RESTAURANT4_DAY3_7"		},
		{ "contestant4",		"qSay",				"RESTAURANT4_DAY3_8"		},
		{ "emily",				"qSetAppearance",	"SHOCK"						},
		{ "emily",				"qSay",				"RESTAURANT4_DAY3_9"		},
		{ "cleaner",			"qSetAppearance",	"DIRTY_SHOE"				},
		{ "cleaner",			"qSay",				"RESTAURANT4_DAY3_10"		},
		{ "emily",				"qSetAppearance",	""							},
		{ "cleaner",			"qSetAppearance",	""							},
		{ "contestant4",		"qSay",				"RESTAURANT4_DAY3_11"		},
		{ "contestant4",		"qSetAppearance",	""							},
		{ "",					"parallel"										},
		{ "contestant3",		"qSitAt",			"table1", 2					},
		{ "contestant4",		"qSitAt",			"table1", 3					},
		{ "",					"sequential"									},
		{ "scene",				"qFinishMovie" 									},		
		{ "scene",				"qNotify",			"start ordering"			}
	}	
	event.sequenceWin = 
	{
		{ "scene",				"qStartMovie" 									},
		{ "emily",				"qSetAppearance",	"HAPPY"						},
		{ "cleaner",			"qSetAppearance",	"HAPPY"						},
		{ "contestant1", 		"qAnimate",			"IDLE", 0					},
		{ "contestant2", 		"qAnimate",			"IDLE", 0					},
		{ "contestant3", 		"qAnimate",			"IDLE", 0					},
		{ "contestant4", 		"qAnimate",			"IDLE", 0					},
		{ "",					"parallel"										},
		{ "emily",				"qWalkToXY",		 9, 18						},
		{ "emily",				"qWalkToXY",		17, 18						},
		{ "",					"sequential"									},
		{ "emily",				"qSay",				"RESTAURANT4_DAY3_20"		},
		{ "contestant1",		"qSetAppearance",	"SAD"						},
		{ "contestant2",		"qSetAppearance",	"SAD"						},
		{ "contestant3",		"qSetAppearance",	"HAPPY"						},
		{ "contestant4",		"qSetAppearance",	"LAUGH"						},
		{ "contestant4",		"qSay",				"RESTAURANT4_DAY3_21"		},
		{ "emily",				"qSay",				"RESTAURANT4_DAY3_22"		},
		{ "contestant4",		"qSetAppearance",	"SURPRISED"					},
		{ "contestant4",		"qSay",				"RESTAURANT4_DAY3_23"		},
		{ "contestant1",		"qSetAppearance",	""							},
		{ "contestant2",		"qSetAppearance",	""							},
		{ "contestant4",		"qSay",				"RESTAURANT4_DAY3_24"		},
		{ "contestant3",		"qStand"										},
		{ "contestant3",		"qWalkToXY",		14, 25						},
		{ "contestant3",		"qAnimate",			"ENTERTAIN", -1				},
		{ "contestant3",		"qWait",			1000						},
		{ "contestant3",		"qAnimate",			"IDLE", 0					},
		{ "emily",				"qSetAppearance",	""							},
		{ "",					"qSequence",		"sequenceExit" 				}
	}
	event.sequenceLose = 
	{
		{ "",					"qSequence",		"sequenceWin" 				}	
	}
	event.sequenceExit = 
	{
		{ "scene",				"qNotify",			"stop ordering"				},
		{ "",					"parallel"										},
		{ "contestant1",		"qWait",			200							},
		{ "contestant1",		"qStand"										},				
		{ "contestant1",		"qWalkToNode",		exitNode					},
		{ "contestant1",		"qDestroy",			"day.contestant1"			},
		{ "contestant2",		"qWait",			500							},
		{ "contestant2",		"qStand"										},				
		{ "contestant2",		"qWalkToNode",		entryNode					},
		{ "contestant2",		"qDestroy",			"day.contestant2"			},
		{ "",					"sequential"									},
		{ "contestant3",		"qWait",			700							},
		
		{ "contestant4",		"qWait",			700							},
		{ "contestant4",		"qStand"										},				
		{ "contestant4",		"qWalkToXY",		18, 25						},
		{ "", 					"parallel"										},
		{ "contestant3",		"qWalkToNode",		exitNode					},
		{ "contestant3",		"qDestroy",			"day.contestant3"			},		
		{ "contestant4",		"qWalkToNode",		exitNode					},
		{ "contestant4",		"qDestroy",			"day.contestant4"			},		
		{ "", 					"sequential"									},
		{ "scene",				"qFinishMovie" 									},
		{ "scene",				"qNotify",			"all left"					}
	}

end

function day3:onNotify(notification)

	if (notification == "start ordering") then
		for i = 1,4  do    
			self["contestant" .. i].state = "ORDER"
		
		end
		
	elseif (notification == "start eating") then
		for i = 1,4  do    
			if (getRandom(2) == 0) then	self["contestant" .. i].state = "DRINK"
			else						self["contestant" .. i].state = "EAT"
			end
		
		end
		
	elseif (notification == "stop eating") then
		for i = 1,4  do    
			self["contestant" .. i].state = "ORDER"
		
		end		
		
	elseif (notification == "stop ordering") then
		self.shouldOrder = false
	
	elseif (notification == "all left") then
		self.table1:setReserved(false)	
	
	end

end

function day3:onTick(time)

	-- the group customers have to do other stuff
	if (event.started == true) and (self.shouldOrder) then
		for i = 1,4  do    
			local contestant = self["contestant" .. i]
			if (contestant and contestant:isSitting()) then
				if (contestant.state == "READ") then
					if (contestant.timer > 0) then
						contestant.timer = contestant.timer - time
						if (contestant.timer <= 0) then
							contestant:animate(contestant.state, 1)
							contestant.timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)
						
						end
					end			
				
				elseif (contestant.state == "ORDER") then
					if (contestant.timer > 0) then
						contestant.timer = contestant.timer - time
						if (contestant.timer <= 0) then
							contestant:animate(contestant.state, 1)
							contestant.timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
						
						end
					end				
				
				elseif (contestant.state == "DRINK" or contestant.state == "EAT") then
					if (contestant.timer > 0) then
						contestant.timer = contestant.timer - time
						if (contestant.timer <= 0) then
							contestant:animate(contestant.state, 1)
							contestant.timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
						
							if (getRandom(2) == 0) then	contestant.state = "DRINK"
							else						contestant.state = "EAT"
							end					
						
						end
					end
				
				end
			end
		end
	end
	
end

-- set day
day = day3()