-- day class
class 'day4' (interface)

day4.sequenceStart = nil
day4.sequenceMoTashi = nil
day4.sequenceMailmanMayor = nil
day4.sequenceCharlesMatthew = nil
day4.sequenceWin = nil
day4.sequenceLose = nil
day4.timeWait = 3000
day4.timeUntilNext = { 30000, 45000, 60000 }
day4.scoreGotOne = 25
day4.scoreGotAll = 100

day4.ted = nil
day4.cameraman = nil
day4.mo = nil
day4.tashi = nil
day4.beagle = nil
day4.mayor = nil
day4.mailman = nil
day4.charles = nil
day4.matthew = nil
day4.completed = false
day4.state = "idle"
day4.index = 0
day4.count = 0
day4.points = 
{
	{
		{14, 15, 10, 15, 7,  14},
		{16, 28, 12, 28, 14, 30},
		{36, 15, 32, 15, 30, 17},	
		{exitX, exitY, exitX, exitY, exitX, exitY},
	},
	{
		{36, 15, 32, 15},	
		{16, 28, 12, 28},
		{14, 15, 10, 15},		
		{entryX, entryY, entryX, entryY},
	},
	{
		{14, 15, 10, 15},
		{16, 28, 12, 28},
		{36, 15, 32, 15},
		{exitX, exitY, exitX, exitY},
	},
}
day4.pointsIndex = 0
day4.started = false
day4.completed = false
day4.persons =
{
}
day4.cameraManX = 39
day4.cameraManY = 33
day4.tedX = 35
day4.tedY = 33

function day4:__init() super()
end

function day4:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	self.ted = pm:createPerson("ted")
	self.ted:setVisible(false)
	self.ted:setPosition(entryNode)	
	self.cameraman = pm:createPerson("cameraman")
	self.cameraman:setVisible(false)
	self.cameraman:setPosition(entryNode)
	self.mo = pm:createPerson("mo")
	self.mo:setVisible(false)
	self.mo:setPosition(entryNode)
	self.mo:createHighlight()
	self.mo:setClickable(false)	
	self.tashi = pm:createPerson("tashi")
	self.tashi:setVisible(false)
	self.tashi:setPosition(entryNode)
	self.tashi:createHighlight()
	self.tashi:setClickable(false)	
	self.beagle = pm:createPerson("beagle")
	self.beagle:setVisible(false)
	self.beagle:setPosition(entryNode)
	self.beagle:createHighlight()
	self.beagle:setClickable(false)
	self.mayor = pm:createPerson("mayor")
	self.mayor:setVisible(false)
	self.mayor:setPosition(exitNode)
	self.mayor:createHighlight()
	self.mayor:setClickable(false)	
	self.mailman = pm:createPerson("mailman")
	self.mailman:setVisible(false)
	self.mailman:setPosition(exitNode)
	self.mailman:createHighlight()
	self.mailman:setClickable(false)	
	self.charles = pm:createPerson("charles")
	self.charles:setVisible(false)
	self.charles:setPosition(entryNode)
	self.charles:createHighlight()
	self.charles:setClickable(false)	
	self.matthew = pm:createPerson("matthew")
	self.matthew:setVisible(false)	
	self.matthew:setPosition(entryNode)
	self.matthew:createHighlight()
	self.matthew:setClickable(false)
	
	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(cleaner:getHomeNode())
	
	self.sequenceStart =
	{
		{ "scene",			"qStartMovie" 											},
		{ "ted",			"qSetVisible",				true						},
		{ "ted",			"qWalkToXY",				14, 17						},
		{ "cameraman",		"qSetVisible",				true						},
		{ "cameraman",		"qWalkToXY",				10, 17						},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_0"		},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_1"		},
		{ "emily",			"qWalkToXY",				18, 17						},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_2"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY4_3"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY4_4"		},
		{ "ted",			"qAnimate",					"LAUGH", -1, 8				},
		{ "ted",			"qWait",					750							},
		{ "ted",			"qAnimate",					"LAUGH", 0					},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_5"		},
		{ "ted",			"qAnimate",					"IDLE", 0					},		
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_6"		},
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY4_7"		},
		{ "cameraman",		"qWalkToXY",				16, 20						},
		{ "cameraman",		"qAnimate",					"KNEEL_UP", 0				},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_8"		},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY4_9"		},
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY4_10"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY4_11"		},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_12"		},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY4_13"		},		
		{ "emily",			"qSetAppearance",			""							},
		{ "emily",			"qWalkToNode",				grid:getCounterNode()		},
		{ "cameraman",		"qWalkToXY",				39, 28						},
		{ "cameraman",		"qWalkToXY",				"cameraManX", "cameraManY"	},
		{ "ted",			"qWalkToXY",				35, 28						},
		{ "ted",			"qWalkToXY",				"tedX", "tedY"				},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qStartGame" 											},
		{ "scene",			"qNotify",					"next npc"					},
	}
	
	self.sequenceMoTashi =
	{
		{ "scene",			"qStartMovie" 											},
		{ "emily",			"qWalkToNode",				grid:getCounterNode()		},
		{ "beagle",			"qWalkToXY",				20, 33						},
		{ "beagle",			"qAnimate",					"ENTERTAIN", -1				},
		{ "beagle",			"qPlaySound",				"SOUND_ENTERTAINER_1", true },
		{ "beagle",			"qWait",					2500						},
		{ "beagle",			"qStopSound",				"SOUND_ENTERTAINER_1"		},
		{ "beagle",			"qAnimate",					"IDLE", 0					},
		{ "",				"parallel"												},
		{ "tashi",			"qWalkToXY",				36, 15						},
		{ "mo",				"qWalkToXY",				32, 15						},
		{ "ted",			"qWalkToXY",				40, 15						},
		{ "cameraman",		"qWalkToXY",				38, 18						},
		{ "cameraman",		"qAnimate",					"KNEEL_UP", 0				},
		{ "",				"sequential"											},
		{ "cameraman",		"qWait",					500							},
		{ "ted",			"qAnimate",					"ENTERTAIN", 1, false, 8	},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_20"		},
		{ "ted",			"qAnimate",					"IDLE", 0					},
		{ "mo",				"qSay",						"RESTAURANT4_DAY4_21"		},
		{ "mo",				"qSetAppearance",			"HAPPY"						},
		{ "mo",				"qSay",						"RESTAURANT4_DAY4_22"		},
		{ "tashi",			"qSetAppearance",			"BLUSH"						},
		{ "tashi",			"qSay",						"RESTAURANT4_DAY4_23"		},
		{ "tashi",			"qSetAppearance",			""							},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_24"		},
		{ "",				"parallel"												},
		{ "ted",			"qWalkToXY",				"tedX", "tedY"				},
		{ "cameraman",		"qWait",					600							},
		{ "cameraman",		"qWalkToXY",				"cameraManX", "cameraManY"	},
		{ "",				"sequential"											},
		{ "",				"parallel"												},
		{ "tashi",			"qWalkToXY",				exitX, exitY				},
		{ "tashi",			"qSetVisible",				false						},
		{ "tashi",			"qDestroy",					"day.tashi"					},
		{ "mo",				"qWait",					300							},
		{ "mo",				"qWalkToXY",				exitX, exitY				},
		{ "mo",				"qSetVisible",				false						},
		{ "mo",				"qDestroy",					"day.mo"					},
		{ "beagle",			"qWait",					600							},
		{ "beagle",			"qWalkToXY",				exitX, exitY				},
		{ "beagle",			"qSetVisible",				false						},
		{ "beagle",			"qDestroy",					"day.beagle"				},		
		{ "",				"sequential"											},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene",			"qNotify",					"next npc"					},
	}
	
	self.sequenceMailmanMayor =
	{
		{ "scene",			"qStartMovie" 											},
		{ "",				"parallel"												},
		{ "mayor",			"qWalkToXY",				36, 15						},
		{ "mailman",		"qWalkToXY",				32, 15						},
		{ "ted",			"qWalkToXY",				40, 15						},
		{ "cameraman",		"qWalkToXY",				38, 18						},
		{ "cameraman",		"qAnimate",					"KNEEL_UP", 0				},
		{ "",				"sequential"											},
		{ "cameraman",		"qWait",					500							},
		{ "ted",			"qAnimate",					"ENTERTAIN", 1, false, 8	},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_30"		},	
		{ "ted",			"qAnimate",					"IDLE", 0					},
		{ "mayor",			"qSetAppearance",			"HAPPY"						},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY4_31"		},	
		{ "mayor",			"qSay",						"RESTAURANT4_DAY4_32"		},	
		{ "mayor",			"qSay",						"RESTAURANT4_DAY4_33"		},	
		{ "mailman",		"qSetAppearance",			"HAPPY"						},
		{ "mailman",		"qSay",						"RESTAURANT4_DAY4_34"		},	
		{ "mayor",			"qSetAppearance",			"SHOCK"						},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY4_70"		},	
		{ "mailman",		"qSetAppearance",			"NEUTRAL"					},
		{ "mailman",		"qSay",						"RESTAURANT4_DAY4_71"		},	
		{ "mailman",		"qSay",						"RESTAURANT4_DAY4_72"		},	
		{ "mayor",			"qSetAppearance",			"SAD"						},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY4_73"		},	
		{ "ted",			"qAnimate",					"ENTERTAIN", 1, false, 8	},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_35"		},
		{ "ted",			"qAnimate",					"IDLE", 0					},
		{ "",				"parallel"												},	
		{ "mayor",			"qSetAppearance",			"HAPPY"						},
		{ "mailman",		"qSetAppearance",			"HAPPY"						},
		{ "",				"sequential"											},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY4_36"		},	
		{ "",				"parallel"												},
		{ "ted",			"qWalkToXY",				"tedX", "tedY"				},
		{ "cameraman",		"qWait",					600							},
		{ "cameraman",		"qWalkToXY",				"cameraManX", "cameraManY"	},
		{ "",				"sequential"											},
		{ "",				"parallel"												},
		{ "mailman",		"qWalkToXY",				entryX, entryY				},
		{ "mailman",		"qSetVisible",				false						},
		{ "mailman",		"qDestroy",					"day.mailman"				},
		{ "mayor",			"qWait",					300							},		
		{ "mayor",			"qWalkToXY",				entryX, entryY				},
		{ "mayor",			"qSetVisible",				false						},
		{ "mayor",			"qDestroy",					"day.mayor"					},		
		{ "",				"sequential"											},		
		{ "scene", 			"qFinishMovie" 											},
		{ "scene",			"qNotify",					"next npc"					},
	}	

	self.sequenceCharlesMatthew =
	{
		{ "scene",			"qStartMovie" 											},
		{ "",				"parallel"												},
		{ "matthew",		"qWalkToXY",				36, 15						},
		{ "charles",		"qWalkToXY",				32, 15						},
		{ "ted",			"qWalkToXY",				40, 15						},
		{ "cameraman",		"qWalkToXY",				38, 18						},
		{ "cameraman",		"qAnimate",					"KNEEL_UP", 0				},
		{ "",				"sequential"											},	
		{ "ted",			"qAnimate",					"ENTERTAIN", 1, false, 8	},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_40"		},	
		{ "ted",			"qAnimate",					"IDLE", 0					},
		{ "charles",		"qSetAppearance",			"HAPPY"						},
		{ "charles",		"qSay",						"RESTAURANT4_DAY4_41"		},	
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_42"		},	
		{ "matthew",		"qSetAppearance",			"HAPPY"						},
		{ "matthew",		"qSay",						"RESTAURANT4_DAY4_43"		},	
		{ "",				"parallel"												},
		{ "ted",			"qWalkToXY",				"tedX", "tedY"				},
		{ "cameraman",		"qWait",					600							},
		{ "cameraman",		"qWalkToXY",				"cameraManX", "cameraManY"	},
		{ "",				"sequential"											},		
		{ "",				"parallel"												},
		{ "matthew",		"qWalkToXY",				exitX, exitY				},
		{ "matthew",		"qSetVisible",				false						},
		{ "matthew",		"qDestroy",					"day.matthew"				},
		{ "charles",		"qWait",					300							},
		{ "charles",		"qWalkToXY",				exitX, exitY				},
		{ "charles",		"qSetVisible",				false						},
		{ "charles",		"qDestroy",					"day.charles"				},
		{ "",				"sequential"											},		
		{ "scene",			"qNotify",					"next npc"					},
	}	
	
	self.sequenceWin =
	{
		{ "emily",			"qWalkToXY",				31, 33						},
		{ "ted",			"qSetAppearance",			"HAPPY"						},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_50"		},	
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_51"		},	
		{ "emily",			"qSetAppearance",			"BLUSH"						},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_52"		},
		{ "emily",			"qSetAppearance",			""							},	
		{ "",				"qSequence",				"sequenceBoth"				},
	}		
	
	self.sequenceLose =
	{
		{ "emily",			"qWalkToXY",				31, 33						},
		{ "ted",			"qSetAppearance",			"NEUTRAL"					},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_55"		},	
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_56"		},	
		{ "ted",			"qSetAppearance",			""							},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_57"		},	
		{ "",				"qSequence",				"sequenceBoth"				},
	}
	
	self.sequenceBoth =
	{
		{ "ted",			"qSetAppearance",			"NEUTRAL"					},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_60"		},	
		{ "ted",			"qSetAppearance",			"HAPPY"						},
		{ "ted",			"qSay",						"RESTAURANT4_DAY4_61"		},	
		{ "emily",			"qSetAppearance",			"HAPPY"						},	
		{ "emily",			"qSay",						"RESTAURANT4_DAY4_62"		},	
		{ "",				"parallel"												},
		{ "cameraman",		"qWalkToNode",				exitNode					},
		{ "cameraman",		"qDestroy",					"day.cameraman"				},
		{ "ted",			"qWait",					300							},
		{ "ted",			"qWalkToNode",				exitNode					},
		{ "ted",			"qDestroy",					"day.ted"					},		
		{ "",				"sequential"											},		
		{ "emily",			"qSetAppearance",			""							},	
		{ "scene", 			"qFinishMovie" 											},	
		{ "scene",          "qNotify",                  "deactivate eventbar"       },
	}
	
	self.sequenceSetup =
	{
		{ "scene",			"qStartMovie" 											},
		{ "",				"parallel"												},
		{ "ted",			"qWalkToXY",				"tedX", "tedY"				},
		{ "cameraman",		"qWait",					600							},
		{ "cameraman",		"qWalkToXY",				"cameraManX", "cameraManY"	},
		{ "",				"sequential"											},			
	}
	
	-- initialize event bar
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(table.getn(self.timeUntilNext))
	eventBar:setProgress(0)	
	eventBar:setSubjectImage("EVENT_CAMERA_BAR", player:getCurrentResourceSection())
	eventBar:setDescriptionText(getText("EVENTBAR"))		

end

function day4:onLevelInited()

	qSequence(self.sequenceStart)

end

function day4:onDayBegin()

	eventBar:animateToActive()

end

function day4:onNotify(notification) 

	if (notification == "arrived") then
	
 		if (self.pointsIndex == table.getn(self.points[self.index])) then
			-- they left
			for i = 1, table.getn(self.persons) do
				self.persons[i]:setVisible(false)
				self.persons[i]:qDestroy("day." .. self.persons[i]:getType())				
			
			end					
			
			self:gotoNextNPC()

		else
			-- they'll wait
			self.timer = self.timeWait
			self.state = "waiting to move"
					
			for i = 1, table.getn(self.persons) do
				self.persons[i]:setClickable(true)
			
			end			
		
		end
	elseif (notification == "next npc") then
		self:gotoNextNPC()
	
	elseif (notification == "deactivate eventbar") then
	    eventBar:animateToDeactive()
	
	end

end

function day4:onTick(time)

	if (not self.started) then
		return
	end
	
	if (self.completed) then
		return
	end	

	if (self.state == "idle") then
		-- do nothing

	elseif (self.state == "waiting to move") then
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self.state = "walking"
				self.timer = 0
				self:gotoNextPoint()
		
			end		
		end
	end

end

function day4:onClickPerson(person)

	if (self.completed) then
		return
	end
	
	local type = person:getType()
	if (type == "mo" or type == "tashi" or type == "beagle") then
		self.mo:setClickable(false)
		self.tashi:setClickable(false)	
		self.beagle:setClickable(false)
		self.state = "interviewing"
		self.timer = 0
		self.count = self.count + 1
		qInsertSequence(self.sequenceMoTashi)
		incScore(self.scoreGotOne, self.tashi:getScreenX(), self.tashi:getScreenY() + scorePersonFloaterOffsetY, 0)
		emily:playSound("SOUND_EVENT_COMPLETE_ITEM")
		eventBar:lowerCurtain()
		eventBar:setProgress(self.count)
	
	elseif (type == "mailman" or type == "mayor") then
		self.mailman:setClickable(false)
		self.mayor:setClickable(false)	
		self.state = "interviewing"
		self.timer = 0		
		self.count = self.count + 1
		qInsertSequence(self.sequenceMailmanMayor)
		incScore(self.scoreGotOne, self.mayor:getScreenX(), self.mayor:getScreenY() + scorePersonFloaterOffsetY, 0)
		emily:playSound("SOUND_EVENT_COMPLETE_ITEM")
		eventBar:lowerCurtain()
		eventBar:setProgress(self.count)
	
	elseif (type == "charles" or type == "matthew") then
		self.charles:setClickable(false)
		self.matthew:setClickable(false)
		self.state = "interviewing"
		self.timer = 0		
		self.count = self.count + 1
		qInsertSequence(self.sequenceCharlesMatthew)
		incScore(self.scoreGotOne, self.matthew:getScreenX(), self.matthew:getScreenY() + scorePersonFloaterOffsetY, 0)
		emily:playSound("SOUND_EVENT_COMPLETE_ITEM")
		eventBar:lowerCurtain()
		eventBar:setProgress(self.count)

	end
	
	if (self.count == table.getn(self.timeUntilNext)) then
		incScore(self.scoreGotAll, self.matthew:getScreenX(), self.matthew:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")
		emily:playSound("SOUND_EVENT_COMPLETE_ALL")
	
	end
	
end

function day4:gotoNextNPC()

	self.index = self.index + 1
	
	if (self.index > table.getn(self.timeUntilNext)) then
		self.completed = true
		self.state = "idle"
		if (self.count == table.getn(self.timeUntilNext)) then
			qInsertSequence(self.sequenceWin)
		
		else
			qInsertSequence(self.sequenceLose)
		
		end		
		
		if (not scene:isPlayingMovie()) then
			qInsertSequence(self.sequenceSetup)
		
		end
	else
		if (self.index == 1) then
			self.started = true
			
		end	
		
		self.state = "waiting to move"
		self.timer = self.timeUntilNext[self.index]
		self.persons = {}
		self.pointsIndex = 0
		
		if (self.index == 1) then
			table.insert(self.persons, self.tashi)
			table.insert(self.persons, self.mo)
			table.insert(self.persons, self.beagle)
		
		elseif (self.index == 2) then
			table.insert(self.persons, self.mayor)
			table.insert(self.persons, self.mailman)
		
		elseif (self.index == 3) then
			table.insert(self.persons, self.matthew)
			table.insert(self.persons, self.charles)
		
		end
	
	end

end

function day4:gotoNextPoint()

	self.pointsIndex = self.pointsIndex + 1
	
	if (self.points[self.index] == nil) then
		warn("gotoNextPoint() - self.index out of bounds")
		return
	end
	
	if (self.points[self.index][self.pointsIndex]) then
		for i = 1, table.getn(self.persons) do
			local gridX = self.points[self.index][self.pointsIndex][i*2-1]
			local gridY = self.points[self.index][self.pointsIndex][i*2-0]

			if (self.pointsIndex == 1) then
				eventBar:raiseCurtain()
							
			end
			
			self.persons[i]:getHighlight():setSelected(false)
			self.persons[i]:getHighlight():setHighlighted(false)
			self.persons[i]:setClickable(false)
			self.persons[i]:qWait(i*300)
			self.persons[i]:qSetVisible(true)
			self.persons[i]:qWalkToXY(gridX, gridY)
			
			if (self.pointsIndex == table.getn(self.points[self.index])) then
			    self.persons[i]:removeHighlight()
				self.persons[i]:qSetVisible(false)
				eventBar:lowerCurtain()
				
			end
		end
		
		self.persons[table.getn(self.persons)]:qNotify("arrived")
		
		if (self.pointsIndex == 1) then
			self.persons[table.getn(self.persons)]:qPlaySound("SOUND_EVENT_ATTENTION")
		end
		
	else
	
	end

end

-- set day
day = day4()
