-- day class
class 'day5' (interface)

day5.sequenceStart = nil
day5.danceTimes = {90000, 90000, 90000}
day5.danceMoves =
{
	{1, 2},
	{3, 4},
	{5},
}
day5.danceSteps = nil
day5.scoreGotOne = 25
day5.scoreGotAll = 100

day5.timer = 0
day5.indexDance = 0
day5.indexMove = 0
day5.clicked = {}
day5.right = 0

function day5:__init() super()

	local choices =
	{
		"STEP",
		"TWIRL",
		"DIP",
	}
	local choicesCount =
	{
		0,
		0,
		0,
	}
	local picked =
	{
	}
	
	for i = 1,6 do
		local random = getRandom(table.getn(choicesCount)) + 1
		while (choicesCount[random] >= 3) do
			random = getRandom(table.getn(choicesCount)) + 1
			
		end
		
		table.insert(picked, choices[random])	
		choicesCount[random] = choicesCount[random] + 1
		-- cout(choices[random] .. "\n")
	end
	
	self.danceSteps =
	{
		{ picked[1], picked[2] },
		{ picked[1], picked[2], picked[3] },
		{ picked[1], picked[2], picked[3], picked[4] },
		{ picked[1], picked[2], picked[3], picked[4], picked[5] },
		{ picked[1], picked[2], picked[3], picked[4], picked[5], picked[6] },
	}

end

function day5:onLevelGlobals()

	if (self.danceSteps == nil) then
		return
		
	end

	autoStartGame = false
	autoAllPeopleWalkIn = false

	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(cleaner:getHomeNode())
	
	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie"											},
		{ "cleaner",		"qWalkToXY",				20, 33						},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_0"		},
		{ "emily",			"qSetAppearance",			"CONFUSED"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_1"		},		
		{ "emily",			"qSetAppearance",			""							},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_2"		},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_3"		},
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_4"		},		
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_5"		},
		{ "cleaner",		"qSetAppearance",			"HAPPY"						},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_6"		},
		{ "emily",			"qSetAppearance",			""							},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_7"		},		
		{ "cleaner",		"qAnimate",					"LAUGH", -1, 8				},
		{ "cleaner",		"qWait",					750							},
		{ "cleaner",		"qAnimate",					"LAUGH", 0					},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_8"		},		
		{ "cleaner",		"qWalkToNode",				cleaner:getHomeNode()		},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qStartGame" 											},		
		{ "scene",			"qNotify",					"next dance"				},
	}
	
	self.sequenceWin =
	{
		{ "cleaner",		"qSetAppearance",			"HAPPY"						},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_10"		},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_11"		},
		{ "",				"qSequence",				"sequenceBoth"				},
	}
	
	self.sequenceLose =
	{
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_15"		},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_16"		},
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_17"		},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_18"		},	
		{ "",				"qSequence",				"sequenceBoth"				},
	}
	
	self.sequenceBoth =
	{
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_20"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY5_21"		},
		{ "cleaner",		"qAnimate",					"LAUGH", -1, 8				},
		{ "cleaner",		"qWait",					750							},
		{ "cleaner",		"qAnimate",					"LAUGH", 0					},		
		{ "cleaner",		"qSay",						"RESTAURANT4_DAY5_22"		},
		{ "cleaner",		"qWalkToNode",				cleaner:getHomeNode()		},
		{ "cleaner",		"qSetAppearance",			""							},
		{ "scene", 			"qFinishMovie" 											},
	}
	
	self.sequenceDance =
	{
		{ "scene",			"qStartMovie",				false						},
		{ "cleaner",		"qWalkToXY",				32, 15						},
		{ "emily",			"qWalkToXY",				36, 15						},
		{ "cleaner",		"qSetAppearance",			"HAPPY"						},
		{ "cleaner",		"qNotify",					"arrived"					},
		{ "cleaner",		"qButtonAction",			"new", "DIP", -50, -50		},
		{ "cleaner",		"qButtonAction",			"popin", "DIP"				},
		{ "cleaner",		"qWait",					500							},
		{ "cleaner",		"qButtonAction",			"new", "TWIRL", 30, 20		},
		{ "cleaner",		"qButtonAction",			"popin", "TWIRL"			},
		{ "cleaner",		"qWait",					500							},
		{ "cleaner",		"qButtonAction",			"new", "STEP", 110, -50		},
		{ "cleaner",		"qButtonAction",			"popin", "STEP"				},		
		{ "cleaner",		"qWait",					1000						},
		{ "cleaner",		"qNotify",					"next move"					},	
	}
	
	-- initialize event bar
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(table.getn(self.danceTimes))
	eventBar:setProgress(0)	
	eventBar:setSubjectImage("EVENT_STEPS_BAR", player:getCurrentResourceSection())
	eventBar:setDescriptionText(getText("EVENTBAR"))	

end

function day5:onLevelInited()

	qSequence(self.sequenceStart)

end

function day5:onDayBegin()

	eventBar:animateToActive()
	eventBar:raiseCurtain()

end

function day5:onNotify(notification)

	if (notification == "next dance") then
		self:gotoNextDance()	
	
	elseif (notification == "next move") then
		self:gotoNextMove()

	elseif (notification == "enable buttons") then
		cleaner:buttonAction("enable", "DIP")
		cleaner:buttonAction("enable", "TWIRL")
		cleaner:buttonAction("enable", "STEP")
	
	elseif (notification == "disable buttons") then
		cleaner:buttonAction("disable", "DIP")
		cleaner:buttonAction("disable", "TWIRL")
		cleaner:buttonAction("disable", "STEP")	
	
	elseif (notification == "delete buttons") then
		cleaner:buttonAction("popout", "DIP")
		cleaner:buttonAction("popout", "TWIRL")
		cleaner:buttonAction("popout", "STEP")
	
	elseif (notification == "inc score") then
		incScore(self.scoreGotOne, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, 0)	
		emily:playSound("SOUND_EVENT_COMPLETE_ITEM")
	
	elseif (notification == "inc score bonus") then
		incScore(self.scoreGotAll, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")		
		emily:playSound("SOUND_EVENT_COMPLETE_ALL")
	
	elseif (notification == "arrived") then
		if (self.indexDance == 1) then
			insert()
			for i = 1,6 do
				local value = self.danceSteps[5][i]
				cleaner:qAnimate(value, 1, false, -1, true)
				if (value == "STEP") then cleaner:qWait(1100) end
				if (value == "TWIRL") then cleaner:qWait(800) end
				if (value == "DIP") then cleaner:qWait(600) end				
				cleaner:qWait(250)	
			end
			cleaner:qAnimate("IDLE", 0)
			cleaner:qSay("RESTAURANT4_DAY5_30")	
			append()
		
		end	
	end

end

function day5:onTick(time)

	if (scene:isPlayingMovie()) then
		return
	end
	
	if (scene:isStartingMovie()) then
		return
	end
	
	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			qSequence(self.sequenceDance)
		
		end	
	end

end

function day5:gotoNextDance()

	self.indexDance = self.indexDance + 1
	self.indexMove = 0
	
	if (self.danceTimes[self.indexDance]) then
		self.timer = self.danceTimes[self.indexDance]
	
	else
		eventBar:animateToDeactive()	
	
	end

end

function day5:gotoNextMove()

	self.indexMove = self.indexMove + 1
	self.clicked = {}
	
	if (self.danceMoves[self.indexDance][self.indexMove]) then
		-- francois shows next move
		for index, value in ipairs(self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]]) do
			cleaner:qAnimate(value, 1, false, -1, true)
			cleaner:qButtonAction("highlight", value)
			cleaner:qButtonAction("pop", value)
			if (value == "STEP") then cleaner:qWait(1100) end
			if (value == "TWIRL") then cleaner:qWait(800) end
			if (value == "DIP") then cleaner:qWait(600) end
			cleaner:qWait(500)
			
		end
		
		cleaner:qAnimate("IDLE", 0)
		cleaner:qNotify("enable buttons")		
	
	else
		-- we did all moves correct
		
		-- eventbar
		self.right = self.right + 1
		eventBar:setProgress(self.right)		
		
		if (self.indexDance == table.getn(self.danceTimes)) then
			-- we did the final dance right: win + bonus
			cleaner:qNotify("inc score bonus")
			cleaner:qNotify("delete buttons")
			cleaner:qWait(1000)
			
			-- francois / emily dance together
			for i = 1,6 do
				local value = self.danceSteps[5][i]

				parallel()

				cleaner:qAnimate(value, 1, false, -1, true)
				if (value == "STEP") then cleaner:qWait(1100) end
				if (value == "TWIRL") then cleaner:qWait(800) end
				if (value == "DIP") then cleaner:qWait(600) end
				
				emily:qAnimate(value, 1, false, -1, true)
				if (value == "STEP") then emily:qWait(1100) end
				if (value == "TWIRL") then emily:qWait(800) end
				if (value == "DIP") then emily:qWait(600) end
				
				cleaner:qWait(250)
				emily:qWait(250)
				
				sequential()
			end
			cleaner:qAnimate("IDLE", 0)
			emily:qAnimate("IDLE", 0)
			
			-- end
			qSequence(self.sequenceWin)
			scene:qNotify("next dance")	
		
		else
			-- there's dances left
			cleaner:qNotify("delete buttons")
			cleaner:qWait(500)
			cleaner:qWalkToNode(cleaner:getHomeNode())
			cleaner:qSetAppearance("")
			scene:qFinishMovie()
			scene:qNotify("next dance")		
		
		end
	end

end

function day5:onClickButton(button)

	table.insert(self.clicked, button)
	
	for index, value in ipairs(self.clicked) do
		if (self.clicked[index] ~= self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]][index]) then
			-- clicked wrong
			self:onNotify("disable buttons")

            emily:qPlaySound("SOUND_EVENT_BAD")
			emily:qAnimate(button, 1, false, -1, true)
			if (button == "STEP") then emily:qWait(1100) end
			if (button == "TWIRL") then emily:qWait(800) end
			if (button == "DIP") then emily:qWait(600) end
			emily:qAnimate("IDLE", 0)
			emily:qWait(250)
			emily:qNotify("delete buttons")
			cleaner:qAnimate("SHAKENO", 2, 12)

			if (self.indexDance == table.getn(self.danceTimes)) then
				-- we did the final dance wrong: lose
				qSequence(self.sequenceLose)
			
			else
				scene:qFinishMovie()
				scene:qNotify("next dance")
				
			end

			return			
		end	
	end
	
	-- clicked right
	emily:qAnimate(button, 1, false, -1, true)
	if (button == "STEP") then emily:qWait(1100) end
	if (button == "TWIRL") then emily:qWait(800) end
	if (button == "DIP") then emily:qWait(600) end
	emily:qWait(250)
	
	if (table.getn(self.clicked) == table.getn(self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]])) then
		-- all good
		-- immediate effect
		self:onNotify("disable buttons")
		
		-- queue next
		emily:qAnimate("IDLE", 0)
		emily:qNotify("inc score")		
		emily:qWait(250)		
		emily:qNotify("next move")
	
	end
end

-- set day
day = day5()
