include("scripts/events/cprevent.lua")

-- set event
event = cprEvent()

-- day class
class 'day6' (interface)

day6.fireworksPackage = nil
day6.fireworksSmoke = nil
day6.fireworksExplosion = nil
day6.timerCpr = 0
day6.timerReset = 0
day6.timeUntilCpr = 1200
day6.ambulanceLights = nil
day6.ambulanceOverlay = nil
day6.spritenode = nil

function day6:__init() super()
end

function day6:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	dayEndTick = true
	
	self.spritenode1 = createSprite()
	self.spritenode1:setX(0)
	self.spritenode1:setY(0)
	level:getLayer(LAYER_GRID_ELEMENTS):addChild(self.spritenode1)
	self.spritenode1:reposition()
	
	self.spritenode2 = createSprite()
	self.spritenode2:setX(0)
	self.spritenode2:setY(600)
	level:getLayer(LAYER_GRID_ELEMENTS):addChild(self.spritenode2)
	self.spritenode2:reposition()	

	self.ambulanceLights = createActorSprite()
	self.ambulanceLights:setDefaultSection(player:getCurrentResourceSection())
	self.ambulanceLights:setX(566)
	self.ambulanceLights:setY(39)
	self.ambulanceLights:animate("OBJECT_AMBULANCE_LIGHTS", 0)
	self.ambulanceLights:setVisible(false)
	self.spritenode1:addChild(self.ambulanceLights)
	
	self.ambulanceOverlay = createActorSprite()
	self.ambulanceOverlay:setDefaultSection(player:getCurrentResourceSection())
	self.ambulanceOverlay:setX(567)
	self.ambulanceOverlay:setY(-480)
	self.ambulanceOverlay:animate("OBJECT_AMBULANCE_LIGHTS_OVERLAY", 0)
	self.ambulanceOverlay:setVisible(false)
	self.spritenode2:addChild(self.ambulanceOverlay)	

	self.bully = pm:createPerson("fakecustomer")
	self.bully:setPosition(entryNode)
	self.bully:setDefaultSection("characters")
	self.bully:setBaseName("INGAME_PERSON_BULLY")
	self.bully:setVisible(false)
	
	self.charles = pm:createPerson("charles")
	self.charles:setPosition(exitNode)
	self.charles:setVisible(false)
	
	self.matthew = pm:createPerson("matthew")
	self.matthew:setPosition(exitNode)
	self.matthew:setVisible(false)
	
	self.betty = pm:createPerson("betty")
	self.betty:setPosition(entryNode)
	self.betty:setVisible(false)
	
	self.fireworksSmoke = createSprite()
	self.fireworksSmoke:setDefaultSection(player:getCurrentResourceSection())
	self.fireworksSmoke:setDefaultFrameRate(15)
	self.fireworksSmoke:setAnchorPointType(BOTTOMCENTER)
	self.fireworksSmoke:animate("ANIM_SMOKE", 0)
	self.fireworksSmoke:setVisible(false)
	self.fireworksSmoke:setX(4)
	self.fireworksSmoke:setY(-18)	
	self.fireworksPackage:addChild(self.fireworksSmoke)

	self.fireworksExplosion = createSprite()
	self.fireworksExplosion:setDefaultSection(player:getCurrentResourceSection())
	self.fireworksExplosion:setDefaultFrameRate(15)
	self.fireworksExplosion:setAnchorPointType(CENTER)
	self.fireworksExplosion:animate("ANIM_EXPLOSION", 0)
	self.fireworksExplosion:setVisible(false)
	self.fireworksExplosion:setScaleX(2.0)
	self.fireworksExplosion:setScaleY(2.0)
	self.fireworksExplosion:setX(34)
	self.fireworksExplosion:setY(-108)
	self.fireworksPackage:addChild(self.fireworksExplosion)
	
	-- set initial positions
	cleaner:setPosition(entryNode)
	cleaner:setAppearance("FIREWORKS")
	cleaner:setName("CLEANER")
	cleaner:setVisible(false)
	emily:setPosition(grid:getCounterNode())
	
	-- set event configuration
	event.baseName = "INGAME_PERSON_FRANCOIS"
	event.neededToSave = 6
	event.saveClickMin = 0.30
	event.saveClickMax = 0.70
	event.speedMin = 1.0
	event.speedMax = 2.0
	event.score = 0
	event.sequenceStart =
	{
		{ "scene",			"qStartMovie" 									},
		{ "cleaner",		"qSetAppearance",	"FIREWORKS"					},
		{ "cleaner",		"qSetVisible",		true						},
		{ "cleaner",		"qWalkToXY", 		21, 27						},
		{ "emily", 			"qSay", 			"RESTAURANT4_DAY6_0"		},
		{ "cleaner",		"qSay", 			"RESTAURANT4_DAY6_1"		},
		{ "cleaner",		"qSay", 			"RESTAURANT4_DAY6_2"		},
		{ "cleaner",		"qSay", 			"RESTAURANT4_DAY6_3"		},
		{ "emily",			"qSay", 			"RESTAURANT4_DAY6_4"		},
		{ "cleaner",		"qWalkToXY", 		9, 20						},
		{ "cleaner",		"qAnimate", 		"PUTDOWNFIREWORKS_LEFT", 1, false, 6, true },
		{ "cleaner",		"qSetAppearance",	""							},
		{ "cleaner",		"qWait", 			1000						},
		{ "fireworksPackage", "qSetVisible",	true						},		
		{ "cleaner",		"qAnimate", 		"IDLE", 0					},
		{ "cleaner",		"qWalkToNode",	 	cleaner:getHomeNode()		},
		{ "scene", 			"qFinishMovie" 									},
		{ "scene", 			"qStartGame" 									}
	}
	
	event.dayEnded = 
	{
		{ "scene",			"qStartMovie", 		false						},	-- unskippable to prevent spawning during event
		{ "bully", 			"qSetVisible",		true						},
		{ "", 				"parallel"										},
		{ "bully", 			"qWalkToXY",		6, 18						},
		{ "emily", 			"qWalkToNode",		grid:getCounterNode()		},
		{ "emily",			"qAnimate",			"CLEAN", -1					},
		{ "cleaner", 		"qWalkToNode",		cleaner:getHomeNode()		},
		{ "", 				"sequential"									},
		{ "",				"parallel"										},
		{ "cleaner",		"qSetVisible", 		false						},
		{ "choker",			"qSetVisible", 		true						},
		{ "", 				"sequential"									},
		{ "choker",			"qSetClickable",	true						},
		{ "bully",			"qAnimate", 		"FIDDLE", -1, 6				},
		{ "bully",			"qPlaySound",		"SOUND_BOOM1"				},
		{ "bully",			"qWait", 			2000						},
		{ "bully",			"qAnimate", 		"IDLE", 0					},
		{ "bully",			"qPlaySound",		"SOUND_BOOM2", true			},
		-- TODO fireworksPackage starts sizzling
		{ "choker",			"qSay", 			"RESTAURANT4_DAY6_10"		},
		{ "", 				"parallel"										},
		{ "choker",			"qWait",			1000						},
		{ "choker",			"qWalkToXY", 		9, 19						},
		{ "bully",			"qSetAppearance",	"RUN"						},
		{ "bully",			"qSetWalkTimePerNode", 35						},
		{ "bully",			"qNotify",			"smoke"						},
		{ "bully",          "qPlaySound",       "SOUND_BULLY_MUD_RUN_LOOP", true},
		{ "bully", 			"qWalkToXY",		49, 12						},
		{ "bully",          "qStopSound",       "SOUND_BULLY_MUD_RUN_LOOP"  },
		{ "bully",			"qSetVisible",		false						},
		{ "bully",			"qDestroy",			"day.bully"					},
		{ "", 				"sequential"									},
		{ "choker",			"qStopSound",		"SOUND_BOOM2"				},
		{ "choker",			"qWait", 			200							},
		{ "choker",			"qPlaySound",		"SOUND_BOOM3"				},
		{ "choker",			"qNotify",			"explode"					},
		{ "choker",			"qWait",			165							},
		{ "choker",			"qSetAppearance", 	"EXPLOSION"					},		
		{ "choker",			"qSetWalkTimePerNode", 17						},
		{ "choker",			"qWalkToXY", 		38, 19						},	-- fly through air
		{ "choker",			"qSetAppearance", 	"BLOWN_UP"					},		
		{ "choker",			"qSetWalkTimePerNode", 35						},
		{ "emily", 			"qSetAppearance",	"PANIC"						},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "emily", 			"qSay",				"RESTAURANT4_DAY6_11"		},
		{ "emily", 			"qSetAppearance",	"RUN"						},
		{ "emily", 			"qSetWalkTimePerNode",	35						},
		{ "emily", 			"qWalkToXY",		38, 18						},
		{ "emily", 			"qSetAppearance",	"PANIC"						},
		{ "emily",			"qAnimate",			"CPR", 0					},
		{ "emily",			"qSetBalloonX",		15							},
		{ "emily",			"qSetBalloonY",		50							},
		{ "emily", 			"qSay",				"RESTAURANT4_DAY6_13"		},
		{ "scene",			"qHideBars",		true						},
		{ "scene",			"qWait",			1000						},
		{ "scene",			"qNotify",			"start dying"				}
	}
	
	event.sequenceTwoDone = 
	{
		{ "betty", 			"qSetVisible", 		true						},
		{ "betty", 			"qSetAppearance", 	"SHOCK"						},
		{ "betty",			"qWalkToXY",		40, 15						},
	}
	
	event.sequenceFourDone = 
	{
		
		{ "charles", 		"qSetVisible", 		true						},
		{ "charles", 		"qSetAppearance", 	"SHOCK"						},
		{ "charles",		"qWalkToXY",		32, 13						},
		{ "matthew", 		"qWait",	 		300							},
		{ "matthew", 		"qSetVisible", 		true						},
		{ "matthew", 		"qSetAppearance", 	"SHOCK"						},
		{ "matthew",		"qWalkToXY",		28, 13						},
	}
	
	event.sequenceChoke =
	{
		{ "input", 			"setInputActive", 	true						},
		{ "emily",			"qSetAppearance",	""							},
		{ "choker",			"qCreateOverhead",	"INGAME_ARROW"				},
		{ "",				"parallel"										},
	}
	event.sequenceSaved =
	{
		{ "scene",			"qStartMovie",		false						},
		{ "emily",			"qNotify",			"start auto cpr"			},		
		{ "betty", 			"qSetAppearance", 	"SAD"						},
		{ "betty",			"qSay",				"RESTAURANT4_DAY6_20"		},
		{ "betty",			"qSay",				"RESTAURANT4_DAY6_21"		},
		{ "emily",			"qSay",				"RESTAURANT4_DAY6_22"		},
		{ "matthew",		"qSetAppearance",	"SAD"						},	
		{ "matthew",		"qWalkToXY",		36, 15						},	
--		{ "matthew",		"qSetAppearance",	"KNEEL"						},	
--		{ "matthew",		"qAnimate", 		"LAY_ARM", 1, 6				},
--		{ "matthew",		"qWait", 			1000						},
--		{ "matthew",		"qSetAppearance", 	"KNEEL_ARM"					},
--		{ "matthew",		"qAnimate", 		"IDLE", 0					},
		{ "matthew",		"qSay",				"RESTAURANT4_DAY6_23"		},
		{ "emily",			"qNotify",			"stop auto cpr"				},
		{ "emily",			"qAnimate",			"CPR_CRY", -1, false, 8		},				
		{ "choker",			"qWait",			5000						},	-- must be uncomfortably long
		{ "choker",			"qSetAppearance",	"RECOVERING"				},
		{ "choker",			"qAnimate", 		"COUGH", 1, 6				},
		{ "emily",			"qAnimate",			"CPR", 0					},		
		{ "choker",			"qWait", 			2500						},
		{ "choker",			"qAnimate", 		"IDLE", 0					},
		{ "choker",			"qSetBalloonX",		50							},
		{ "choker",			"qSetBalloonY",		110							},		
		{ "choker",			"qSay", 			"RESTAURANT4_DAY6_24"		},
		{ "choker",			"qSay", 			"RESTAURANT4_DAY6_25"		},
		{ "emily",			"qSetAppearance",	"HAPPY"						},
		{ "matthew",		"qSetAppearance",	"HAPPY"						},
		{ "betty",			"qSetAppearance",	"HAPPY"						},
		{ "charles",		"qSetAppearance",	"HAPPY"						},
		{ "emily",			"qSay", 			"RESTAURANT4_DAY6_26"		},
		{ "emily",			"qSay", 			"RESTAURANT4_DAY6_27"		},
		{ "choker",			"qSay", 			"RESTAURANT4_DAY6_28"		},
		{ "choker",			"qSay", 			"RESTAURANT4_DAY6_29"		},
		{ "emily",			"qSay", 			"RESTAURANT4_DAY6_30"		},
		{ "choker",			"qSay", 			"RESTAURANT4_DAY6_31"		},		
		{ "scene",			"qNotify",			"start ambulance"			},	-- Start the ambulance lights
		{ "choker",			"qSay", 			"RESTAURANT4_DAY6_32"		},
		{ "emily",			"qSay", 			"RESTAURANT4_DAY6_33"		},
		{ "scene",			"qFadeToBlack"									},
		{ "choker",			"qStopSound",		"SOUND_PARK_AMBIENT"		},
		{ "ambulanceLights", "qSetVisible", 	false						},
		{ "ambulanceOverlay","qSetVisible",		false						},	
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}
	
end

function day6:onLevelInited()

	event.choker:setVisible(false)
	event.choker:setPosition(cleaner:getHomeNode())
	event.choker:setClickable(false)

end

function day6:onNotify(notification)
	if (notification == "start dying") then
		-- disable everything
		getProduct("ROSES"):setClickable(false)
		getProduct("POPCORN"):setClickable(false)
		getProduct("SALT"):setClickable(false)
		getProduct("SWEET"):setClickable(false)
		getProduct("BALLOON_SWITCH_ORANGE"):setClickable(false)
		getProduct("BALLOON_SWITCH_BLUE"):setClickable(false)
		getProduct("BALLOON_ORANGE"):setClickable(false)
		getProduct("BALLOON_BLUE"):setClickable(false)
		getProduct("COTTON_CANDY_BLUE"):setClickable(false)
		getProduct("COTTON_CANDY_PINK"):setClickable(false)
		getProduct("ORANGE_JUICE"):setClickable(false)
		getProduct("BERRY_JUICE"):setClickable(false)
		getProduct("BEAR"):setClickable(false)
		getProduct("SYRUP"):setClickable(false)
		getProduct("POWDER"):setClickable(false)
		getProduct("PANCAKEMIX"):setClickable(false)
		om:getTable(0):setClickable(false)
		om:getTable(1):setClickable(false)
		register:setClickable(false)
		getAppliance("rest4_cotton_candy_pink"):setClickable(false)
		getAppliance("rest4_cotton_candy_blue"):setClickable(false)
		getAppliance("rest4_popcorn_app"):setClickable(false)
		getAppliance("rest4_karaoke"):setClickable(false)
		getAppliance("rest4_hammerpole"):setClickable(false)
	
		qSequence(event.sequenceChoke)
	
	elseif (notification == "smoke") then
		self.fireworksSmoke:setVisible(true)
		self.fireworksSmoke:animate("ANIM_SMOKE", -1)
	
	elseif (notification == "explode") then
		pauseMusic()
		event.choker:playSound("SOUND_PARK_AMBIENT", true)
		event.choker:setShadowVisible(false)
		self.fireworksSmoke:setVisible(false)
		self.fireworksPackage:animate("OBJECT_FIREWORKS_EXPLODED", 0)
		self.fireworksExplosion:setVisible(true)
		self.fireworksExplosion:animate("ANIM_EXPLOSION", 1, false, -1, true)
	
	elseif (notification == "start auto cpr") then
		self.timerCpr = self.timeUntilCpr
	
	elseif (notification == "stop auto cpr") then
		self.timerCpr = 0
		self.timerReset = 0
		
		emily:setVisible(true)
		event.choker:animate("IDLE", 0)
		
	elseif (notification == "start ambulance") then
		self.ambulanceLights:setVisible(true)
		self.ambulanceLights:animate("OBJECT_AMBULANCE_LIGHTS", -1, 7)
		self.ambulanceOverlay:setVisible(true)
		self.ambulanceOverlay:animate("OBJECT_AMBULANCE_LIGHTS_OVERLAY", -1, 7)
		
	end
	
end

function day6:createObject(desc)
	if (desc:getType() == "FireWorksPackage") then
		self.fireworksPackage = D2Object()
		self.fireworksPackage:animate("OBJECT_FIREWORKS_PACKAGE", 0)
		self.fireworksPackage:setType(desc:getType())
		self.fireworksPackage:setVisible(false)
		
	end
	
	return self.fireworksPackage
end

function day6:onTick(time)

	if (self.timerReset > 0) then
		self.timerReset = self.timerReset - time
		if (self.timerReset <= 0) then
--			emily:setVisible(true)
--			event.choker:animate("IDLE", 0)
			self.timerCpr = self.timeUntilCpr
			self.timerReset = 0		
		
		end	
	end

	if (self.timerCpr > 0) then
		self.timerCpr = self.timerCpr - time
		if (self.timerCpr <= 0) then
			emily:setVisible(false)
			event.choker:animate("CPRCHEST", 1, false, 15, true)
			self.timerCpr = 0
			self.timerReset = 800
		
		end	
	end
	
end

-- set day
day = day6()
