include("scripts/events/chasebullyevent.lua")

-- set event
event = chaseBullyEvent()

-- day class
class 'day7' (interface)

day7.firstTry = true

function day7:__init() super()
end

function day7:onLevelGlobals()
	cleaner:setVisible(false)
	cleaner.clean = false
	self.firstTry = true
	
	self.charles = pm:createPerson("charles")
	self.charles:setPosition(grid:getNode(0,15))
	self.charles:setVisible(false)

	-- set event configuration
	event.baseName = "INGAME_PERSON_BULLY"
	event.actionDuration = 100
	event.coordinates =
	{
		{ 42, 32, 39, 32 },
		{  8,  7,  5,  7 },
		{  8,  32,  11,  32 },
		{  41,  7,  42,  7 },
		{ 42, 32, 39, 32 },
		{  8,  32,  11,  32 },
		{  41,  7,  42,  7 },
		{  8,  7,  5,  7 },
		{  8,  32,  11,  32 },
		{ 42, 32, 39, 32 }
	}
	event.score = 500
	event.timerStart = 10 * 1000
	event.timerReturn = 8 * 1000
	event.scoreGotOne = 25
	event.scoreGotAll = 100
	
	self.mayor = pm:createPerson("mayor")
	self.mayor:setPosition(entryNode)
	self.mayor:setVisible(false)
	emily:setPosition(grid:getCounterNode())
	
	event.sequenceBeginDay =
	{
		{ "scene",		"qStartMovie" 								},
		{ "emily",		"qSetAppearance", 	"NEUTRAL"				},
		{ "mayor",		"qSetAppearance", 	"SHOCK"					},
		{ "mayor",      "qSetVisible",      true                    },
		{ "mayor",		"qWalkToXY",	 	20, 29					},
		{ "mayor",		"qSetAppearance", 	"NERVOUS"				},
		{ "mayor",		"qSay", 			"RESTAURANT4_DAY7_0"	},
		{ "mayor",		"qSay", 			"RESTAURANT4_DAY7_1"	},
		{ "emily",		"qSay", 			"RESTAURANT4_DAY7_2"	},
		{ "emily",		"qSay", 			"RESTAURANT4_DAY7_3"	},
		{ "emily",		"qSay", 			"RESTAURANT4_DAY7_4"	},
		{ "emily",		"qSetAppearance", 	"HAPPY"					},
		{ "emily",		"qSay", 			"RESTAURANT4_DAY7_5"	},
		{ "mayor",		"qSetAppearance", 	"HAPPY"					},
		{ "mayor",		"qSay", 			"RESTAURANT4_DAY7_6"	},
		{ "mayor",		"qSetAppearance", 	""						},
		{ "mayor",		"qSay", 			"RESTAURANT4_DAY7_7"	},
		{ "emily",		"qSetAppearance", 	"NEUTRAL"				},
		{ "emily",		"qSay", 			"RESTAURANT4_DAY7_8"	},
		{ "mayor",		"qSay", 			"RESTAURANT4_DAY7_9"	},
		{ "mayor",		"qSetAppearance", 	"SHOCK"					},
		{ "mayor",		"qSay", 			"RESTAURANT4_DAY7_10"	},
		{ "emily",		"qSay", 			"RESTAURANT4_DAY7_11"	},
		{ "mayor",		"qSay", 			"RESTAURANT4_DAY7_12"	},
		{ "emily",		"qSetAppearance", 	"HAPPY"					},
		{ "emily",		"qSay", 			"RESTAURANT4_DAY7_13"	},
		{ "mayor",		"qSetAppearance", 	"HAPPY"					},
		{ "mayor",		"qSay", 			"RESTAURANT4_DAY7_14"	},
		{ "emily",		"qSetAppearance", 	"LAUGH"					},
		{ "emily",		"qSay", 			"RESTAURANT4_DAY7_15"	},
		{ "emily",		"qSetAppearance", 	""						},
		{ "mayor",		"qWalkToNode", 		exitNode				},
		{ "mayor",		"qDestroy",			"day.mayor"				},
		{ "scene", 		"qFinishMovie" 								},
		{ "scene",		"qNotify", 			"start event timer"		}
	}
	
	event.sequenceStart =
	{
		{ "scene",			"qStartMovie", 		false						},
		{ "camPerson",		"qSetPosition",		exitNode            		},
		{ "camPerson",      "qSetAppearance",   "ASHAMED"                   },
		{ "camPerson",		"qSetVisible",		true						},
		{ "camPerson",		"qWalkToXY",		46, 15						},
		{ "camPerson",      "qAnimate",         "SHAME", -1, 8              },
		{ "emily",			"qWalkToXY",		32, 15						},		
		{ "camPerson",      "qWait",            1000                        },
		{ "camPerson",		"qWalkToXY",		36, 15						},
		{ "camPerson",		"qSayYesNo",		"RESTAURANT4_DAY7_20"		},
	}
	
	event.sequenceAngry =
	{
		{ "emily",			"qSetAppearance",	"OFFENDED"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_21"		},
		{ "camPerson",		"qAnimate",			"CRY", -1, 6				},
		{ "camPerson",      "qWait",            500                         },
		{ "camPerson",		"qSay",				"RESTAURANT4_DAY7_22"		},
		{ "camPerson",		"qAnimate",			"IDLE", 0					},
		{ "camPerson",		"qSetAppearance",	"CRYING"					},
		{ "camPerson",		"qPlaySound",		"SOUND_BOY_CRYING"			},
		{ "camPerson",		"qWalkToXY",		42, 32						},
		{ "camPerson",		"qAnimate",			"SITCRY", -1, 6				},
		{ "charles", 		"qSetVisible", 		true						},
		{ "charles",		"qWalkToXY",		8, 16						},
		{ "charles",		"qSay",				"RESTAURANT4_DAY7_23"		},
		{ "charles",		"qSay",				"RESTAURANT4_DAY7_24"		},
		{ "emily",			"qSetAppearance",	"SHOCK"						},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_25"		},
		{ "charles",		"qSay",				"RESTAURANT4_DAY7_26"		},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_27"		},
		{ "emily",			"qSetAppearance",	"NEUTRAL"					},
		{ "charles",		"qWalkToNode", 		entryNode					},
		{ "charles",		"qDestroy",			"day.charles"				},
		{ "scene", 			"qNotify",			"start event"				},
		{ "scene", 			"qFinishMovie" 									},
		{ "camPerson",		"qCreateOverhead",	"INGAME_ARROW"				}
		
	}
	
	event.sequenceSaint =
	{
		{ "emily",			"qSetAppearance",	"NEUTRAL"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_40"		},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_41"		},
		{ "camPerson",		"qAnimate",			"CRY", -1, 6				},
		{ "camPerson",      "qWait",            500                         },
		{ "camPerson",		"qSay",				"RESTAURANT4_DAY7_42"		},
		{ "camPerson",		"qAnimate",			"IDLE", 0					},
		{ "",				"qSequence",		"sequenceFinalize"			}
	}

	event.sequenceTooLate =
	{
		-- Nothing happens in this event / moment
	}
	
	event.sequenceCompleted =
	{
		{ "scene",			"qStartMovie" 									},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_35"		},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_36"		},
		{ "camPerson",		"qAnimate",			"CRY", -1, 6				},
		{ "camPerson",		"qSay",				"RESTAURANT4_DAY7_37"		},
		{ "camPerson",		"qAnimate",			"IDLE", 0					},
		{ "",				"qSequence",		"sequenceFinalize"			}
	}

	event.sequenceFinalize =
	{
		{ "camPerson",		"qSetAppearance",	"SAD"						},
		{ "camPerson",		"qSay",				"RESTAURANT4_DAY7_50"		},
		{ "camPerson",		"qSay",				"RESTAURANT4_DAY7_51"		},
		{ "camPerson",		"qSay",				"RESTAURANT4_DAY7_52"		},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_53"		},
		{ "camPerson",		"qSetAppearance",	""							},
		{ "emily",			"qSetAppearance",	"SURPRISED"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_54"		},
		{ "emily",			"qSetAppearance",	"NEUTRAL"					},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_55"		},
		{ "camPerson",		"qSay",				"RESTAURANT4_DAY7_56"		},
		{ "emily",			"qSetAppearance",	"HAPPY"						},
		{ "emily",			"qSay",				"RESTAURANT4_DAY7_57"		},
		{ "camPerson",		"qWalkToNode",		cleaner:getHomeNode()		},
		{ "scene",			"qNotify",			"dog entertainer"			},
		{ "scene", 			"qFinishMovie" 									}
	}
	
end

function day7:onLevelInited()

    event.camPerson:setVisible(false)
    event.camPerson:setOverheadY(40)

end

function day7:onDayBegin()
	cleaner:setVisible(false)
	qSequence(event.sequenceBeginDay)
end

function day7:onDayEnd()
	if (event.completed == false) then
		if (event.camPerson ~= nil) and (event.camPerson:isVisible()) then
			autoAllPeopleWalkOut = false
			event.camPerson:qRemoveOverhead()
			event.camPerson:qWalkToXY(11, 12)
			emily:qWalkToXY(9, 16)
			sequential()
			qSequence(event.sequenceSaint)
			scene:qFinishGame()
		
		end
	end
end

function day7:onClickMessage(text, result)
	
	if (text == "RESTAURANT4_DAY7_20") then		-- Bully asks if Emily is mad at him
		if (result == "yes") then
			qSequence(event.sequenceAngry)
		else
			incScore(500, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")		
			qSequence(event.sequenceSaint)
		end

		return true
	end

end

function day7:onNotify(notification)

	if (notification == "camera start") then
		
		event.camPerson:setSelected(false)
		
		if (self.firstTry == true) then
			self.firstTry = false
			
			event.camPerson:qAnimate("IDLE", -1, 6)
			event.camPerson:qSetAppearance("ASHAMED")
			event.camPerson:qSayTimed("RESTAURANT4_DAY7_30", 800)
			event.camPerson:qWait(800)
			event.camPerson:qSetAppearance("CRYING")
		end
		
	elseif (notification == "camera complete") then
	
	
	elseif (notification == "dog entertainer") then
		event.camPerson:setClickable(false)
		event.camPerson:setVisible(false)
		cleaner:setVisible(true)
		cleaner.clean = true
	
	elseif (notification == "start event") then
		scene:qNotify("start")

	end

end

-- set day
day = day7()