include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"Note",
}

-- day class
class 'day8' (interface)

day8.sequenceStart = nil

day8.timeBeforeMidDay = 1000 * 3
day8.timer = 0
day8.lostNotes = {}
day8.spectators =
{
	{
		{"INGAME_CUSTOMER_FEMALE_REGULAR", 22, 22},
		{"INGAME_CUSTOMER_MALE_REGULAR", 25, 22},
	},
	{
		{"INGAME_CUSTOMER_MALE_ELDERLY", 24, 20},
		{"INGAME_CUSTOMER_FEMALE_ELDERLY", 27, 20},
	},
	{
		{"INGAME_CUSTOMER_MALE_CHILD", 23, 21},
	},		
	{
		{"INGAME_CUSTOMER_MALE_REGULAR", 28, 25},
		{"INGAME_CUSTOMER_FEMALE_REGULAR", 31, 25},
	},	
	{
		{"INGAME_CUSTOMER_MALE_ELDERLY", 19, 21},
	},		
	{
		{"INGAME_CUSTOMER_FEMALE_REGULAR", 23, 24},
		{"INGAME_CUSTOMER_FEMALE_CHILD", 26, 24},
	},	
	{
		{"INGAME_CUSTOMER_FEMALE_ELDERLY", 22, 25},
		{"INGAME_CUSTOMER_FEMALE_REGULAR", 19, 25},
	},		
	
}

function day8:__init() super()
end

function day8:onLevelGlobals()
	
	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.mayor = pm:createPerson("mayor")
	self.mayor:setPosition(grid:getNode(0,15))
	self.mayor:setVisible(false)
	
	-- position everyone
    emily:setPosition(grid:getCounterNode())
    cleaner:setPosition(cleaner:getHomeNode())
	
	-- set event configuration
	event.baseName = ""
	event.entryX = 30
	event.entryY = 0
	event.highlightX = 24
	event.highlightY = 21
	event.timeUntilEnterMin = 1
	event.timeUntilEnterMax = 2
	event.scoreFoundOne	= 50
	event.scoreFoundAll	= 100
	self.sequenceStart	=
	{	
		{ "scene", 		"qStartGame" 									},		
		{ "scene",		"qNotify",			"start timer"				}
	}
	self.sequenceMidDay = 								
	{
		{ "scene",		"qStartMovie" 									},
		{ "mayor", 		"qSetVisible",		true				 		},
		{ "mayor", 		"qWalkToXY",		22, 20				 		},
		{ "emily",		"qWalkToNode",		grid:getCounterNode()		},
		{ "emily", 		"qSay",				"RESTAURANT4_DAY8_0" 		},
		{ "mayor", 		"qWalkToXY",		22, 30				 		},
		{ "emily", 		"qSay",				"RESTAURANT4_DAY8_1" 		},
		{ "mayor", 		"qSay",				"RESTAURANT4_DAY8_2" 		},
		{ "mayor", 		"qSay",				"RESTAURANT4_DAY8_3" 		},
		{ "mayor", 		"qSay",				"RESTAURANT4_DAY8_4" 		},
		{ "mayor", 		"qSay",				"RESTAURANT4_DAY8_5" 		},
		{ "mayor",		"qSetAppearance",	"DISTRESS"					},
		{ "mayor",		"qCreateOverhead",	"INGAME_EMPTY_PLATES_SIGN"	},
		{ "mayor",		"qPlaySound",		"SOUND_EVENT_ATTENTION"		},
		{ "mayor",		"qWait",			1000						},
		{ "mayor",		"qRemoveOverhead"								},
		{ "mayor",		"qNotify",			"ho_arrived"				},		
		{ "mayor",		"qSetAppearance",	"SHOCK"						},
		{ "mayor", 		"qSay",				"RESTAURANT4_DAY8_6" 		},
		{ "emily",		"qSetAppearance",	"LAUGH"						},
		{ "emily", 		"qSay",				"RESTAURANT4_DAY8_7" 		},
		{ "mayor",		"qSetAppearance",	""							},
		{ "emily", 		"qSay",				"RESTAURANT4_DAY8_8" 		},
		{ "emily",		"qSetAppearance",	""							},
		{ "mayor", 		"qWalkToXY",		14, 33				 		},
		{ "scene", 		"qFinishMovie" 									},
		{ "scene",		"qNotify",			"show bar"					}
	}
	event.sequenceDone = 									-- text when you find all items
	{
		{ "scene",		"qStartMovie" 									},
		{ "emily",		"qWalkToXY",		18, 33				 		},
		{ "emily",		"qAnimate",			"JUMP", 1					},
		{ "emily",		"qWait",			500							},
		{ "emily",		"qAnimate",			"IDLE", 0					},
		{ "emily",		"qSetAppearance",	"HAPPY"						},
		{ "emily",		"qSay",				"RESTAURANT4_DAY8_10"		},
		{ "mayor",		"qSay",				"RESTAURANT4_DAY8_11"		},
		{ "emily",		"qSetAppearance",	""							},
		{ "scene", 		"qFinishMovie" 									}
	}	
	
	event.sequenceLost = 
	{
		{ "emily",		"qWalkToXY",		18, 33				 		},
		{ "emily",		"qSetAppearance",	"NEUTRAL"					},
		{ "emily",		"qSay",				"RESTAURANT4_DAY8_15"		},
		{ "mayor",		"qSay",				"RESTAURANT4_DAY8_16"		},
		{ "emily",		"qSetAppearance",	""							},
	}
	
	event.sequenceCompleted = 								-- day ends
	{
		{ "cleaner",	"qWalkToXY",		29, 23						},
		{ "cleaner",	"qAnimate",			"IDLE_UP", 0				},
		{ "emily",		"qWalkToXY",		25, 26						},
		{ "emily",		"qAnimate",			"IDLE_UP", 0				},
		{ "mayor",		"qWalkToXY",		25, 15						},
		{ "scene",		"qNotify",			"speech"					}
	}

	-- start sequence
	qSequence(self.sequenceStart)

end

function day8:onTick(time)

	if (event.completed == true) then
		return
	end
	
	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			qSequence(self.sequenceMidDay)
		end		
	end

end

function day8:onNotify(notification)

	if (notification == "start timer") then
		self.timer = self.timeBeforeMidDay
	
	elseif (notification == "speech") then
		if (event.completed == false) then
			-- Define which notes are lost:
			-- cout("event.countItems :" .. event.countItems .. "\n")
			-- cout("event.countFound :" .. event.countFound .. "\n")
			for i = 1, (event.countItems - event.countFound) do
				local random = 1
				-- cout("Defining note " .. i .. "\n")
				while (self.lostNotes[random] == 1) do
					random = getRandomRange(1, event.countItems + 1)
					-- cout(".")
				end
				self.lostNotes[random] = 1
				-- cout(" " .. random .. "\n")
			end
		end

		-- Perform the actual speech:
		self.mayor:qAnimate("SPEECH", -1, 8)
		local lineID = 20
		local foundNote = "y"
		for line = 1, event.countItems do
			if (self.lostNotes[line] == 1) then
				foundNote = "n"
			else
				foundNote = "y"
			end
			
			self.mayor:qSay("RESTAURANT4_DAY8_" .. lineID .. foundNote)
			
			lineID = lineID + 1
		end
		
		self.mayor:qAnimate("IDLE", 0)
		scene:qFinishMovie()
		scene:qFinishGame()
		
	end
	
end

function day8:onDayEnd()
	
	-- prevent walking out
	autoAllPeopleWalkOut = false
	
	scene:qStartMovie(false)
	-- If not all notes were found, play animation:
	if (event.completed == false) then
		qSequence(event.sequenceLost)
	end
		
	-- enter spectators
	self:doSpectators()		
	
	-- play completed sequence
	qSequence(event.sequenceCompleted)
	    
end

function day8:doSpectators()

	for indexg, valueg in ipairs(self.spectators) do
		local r = getRandom(2)
	
		parallel()
		for indexs, values in ipairs(valueg) do	
			local s = pm:createPerson("fakecustomer")
			s:setVisible(false)
			if (r == 0) then s:setPosition(entryNode) end
			if (r == 1) then s:setPosition(exitNode) end
			s:setBaseName(values[1])
			s:qWait(indexs * 300)
			s:qSetVisible(true)
			s:qWalkToXY(values[2], values[3])
			s:qAnimate("IDLE_UP", 0)	
		end
		sequential()
		
	end

end

-- set day
day = day8()


