include("scripts/events/brokenobjectevent.lua")

-- set event
event = brokenObjectEvent()
event.targetType = "FireWorks"
event.nrTargets = 4

-- day class
class 'day9' (interface)

day9.sequenceOutro = nil
day9.mo = nil
day9.tashi = nil
day9.beagle = nil
day9.mayor = nil
day9.mailman = nil
day9.charles = nil
day9.matthew = nil
day9.francois = nil
day9.betty = nil
day9.elvis = nil
day9.spectator0 = nil
day9.spectator1 = nil
day9.spectator2 = nil
day9.spectator3 = nil
day9.spectator4 = nil
day9.spectator5 = nil

function day9:__init() super()

	makeProgressBarsSmall = true

end

function day9:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.mo = pm:createPerson("mo")
	self.mo:setVisible(false)
	self.mo:setPosition(entryNode)
	self.tashi = pm:createPerson("tashi")
	self.tashi:setVisible(false)
	self.tashi:setPosition(entryNode)
	self.beagle = pm:createPerson("beagle")
	self.beagle:setVisible(false)
	self.beagle:setPosition(entryNode)
	self.mayor = pm:createPerson("mayor")
	self.mayor:setVisible(false)
	self.mayor:setPosition(exitNode)
	self.mailman = pm:createPerson("mailman")
	self.mailman:setVisible(false)
	self.mailman:setPosition(exitNode)
	self.charles = pm:createPerson("charles")
	self.charles:setVisible(false)
	self.charles:setPosition(exitNode)
	self.matthew = pm:createPerson("matthew")
	self.matthew:setVisible(false)	
	self.matthew:setPosition(exitNode)
	self.francois = pm:createPerson("francois")
	self.francois:setVisible(false)	
	self.francois:setPosition(entryNode)
	self.betty = pm:createPerson("betty")
	self.betty:setVisible(false)	
	self.betty:setPosition(entryNode)	
	self.elvis = pm:createPerson("elvis")
	self.elvis:setVisible(false)	
	self.elvis:setPosition(entryNode)	
	self.spectator0 = pm:createPerson("fakecustomer")
	self.spectator0:setVisible(false)	
	self.spectator0:setPosition(exitNode)	
	self.spectator0:setBaseName("INGAME_CUSTOMER_FEMALE_ELDERLY")
	self.spectator1 = pm:createPerson("fakecustomer")
	self.spectator1:setVisible(false)	
	self.spectator1:setPosition(exitNode)		
	self.spectator1:setBaseName("INGAME_CUSTOMER_MALE_CHILD")
	self.spectator2 = pm:createPerson("fakecustomer")
	self.spectator2:setVisible(false)	
	self.spectator2:setPosition(entryNode)	
	self.spectator2:setBaseName("INGAME_CUSTOMER_MALE_REGULAR")
	self.spectator3 = pm:createPerson("fakecustomer")
	self.spectator3:setVisible(false)	
	self.spectator3:setPosition(entryNode)
	self.spectator3:setBaseName("INGAME_CUSTOMER_FEMALE_REGULAR")
	self.spectator4 = pm:createPerson("fakecustomer")
	self.spectator4:setVisible(false)	
	self.spectator4:setPosition(exitNode)	
	self.spectator4:setBaseName("INGAME_CUSTOMER_FEMALE_CHILD")
	self.spectator5 = pm:createPerson("fakecustomer")
	self.spectator5:setVisible(false)	
	self.spectator5:setPosition(exitNode)			
	self.spectator5:setBaseName("INGAME_CUSTOMER_MALE_ELDERLY")
	
	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(cleaner:getHomeNode())

	event.animFix = "FIX"
	event.overheadY = 33
	event.pbY = 23
	event.timeUntilFixed = 1000 * 10
	event.score = 50	
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 											},
		{ "mayor",			"qSetAppearance",			"NERVOUS"					},
		{ "mayor",			"qSetVisible",				true						},
		{ "mayor",			"qWalkToXY",				20, 30						},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_0"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_1"		},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_2"		},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_3"		},
		{ "mayor",			"qSayTimed",				"RESTAURANT4_DAY9_4", 500	},
		{ "mayor",			"qWait",					1000						},
		{ "emily",			"qSetAppearance",			"CONFUSED"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_5"		},
		{ "emily",			"qSetAppearance",			""							},
		{ "mayor",			"qSetAppearance",			""							},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_6"		},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_7"		},
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_9"		},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_10"		},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_11"		},
		{ "emily",			"qSetAppearance",			""							},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_12"		},		
		{ "mayor",			"qWalkToNode",				exitNode					},
		{ "mayor",			"qSetVisible",				false						},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qStartGame" 											},		
	}
	
	self.sequenceOutro = 
	{
		{ "scene",			"qStartMovie" 											},
		
		{ "emily",			"qWalkToNode",				grid:getCounterNode()		},
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		
		{ "",				"parallel"												},
		{ "spectator4",		"qSetVisible",				true						},
		{ "spectator4",		"qWalkToXY",				37, 18						},
		{ "spectator4",		"qAnimate",					"IDLE_UP", 0				},
		{ "spectator5",		"qWait",					300							},
		{ "spectator5",		"qSetVisible",				true						},
		{ "spectator5",		"qWalkToXY",				40, 18						},
		{ "spectator5",		"qAnimate",					"IDLE_UP", 0				},
		{ "",				"sequential",											},			
		
		{ "",				"parallel"												},
		{ "betty",			"qSetVisible",				true						},
		{ "betty",			"qSitAt",					om:getTable(1), 0			},
		{ "elvis",			"qWait",					300							},
		{ "elvis",			"qSetVisible",				true						},
		{ "elvis",			"qSitAt",					om:getTable(1), 1			},
		{ "",				"sequential",											},		
		
		{ "",				"parallel"												},
		{ "spectator0",		"qSetVisible",				true						},
		{ "spectator0",		"qWalkToXY",				19, 14						},
		{ "spectator0",		"qAnimate",					"IDLE_UP", 0				},
		{ "spectator1",		"qWait",					300							},
		{ "spectator1",		"qSetVisible",				true						},
		{ "spectator1",		"qWalkToXY",				22, 12						},
		{ "spectator1",		"qAnimate",					"IDLE_UP", 0				},
		{ "",				"sequential",											},				
		
		{ "",				"parallel"												},
		{ "mo",				"qSetVisible",				true						},
		{ "mo",				"qWalkToXY",				12, 15						},
		{ "mo",				"qAnimate",					"IDLE_UP", 0				},
		{ "tashi",			"qWait",					300							},
		{ "tashi",			"qSetVisible",				true						},
		{ "tashi",			"qWalkToXY",				10, 15						},
		{ "tashi",			"qAnimate",					"IDLE_UP", 0				},
		{ "",				"blocker"												},
		{ "tashi",			"qAnimate",					"IDLE_COUPLE", 0			},
		{ "mo",				"qAnimate",					"IDLE_COUPLE", 0			},
		{ "beagle",			"qWait",					600							},
		{ "beagle",			"qSetVisible",				true						},
		{ "beagle",			"qWalkToXY",				7, 16						},				
		{ "beagle",			"qAnimate",					"IDLE_UP", 0				},
		{ "",				"sequential",											},		
		
		{ "",				"parallel"												},
		{ "spectator2",		"qSetVisible",				true						},
		{ "spectator2",		"qWalkToXY",				17, 18						},
		{ "spectator2",		"qAnimate",					"IDLE_UP", 0				},
		{ "spectator3",		"qWait",					300							},
		{ "spectator3",		"qSetVisible",				true						},
		{ "spectator3",		"qWalkToXY",				14, 18						},
		{ "spectator3",		"qAnimate",					"IDLE_UP", 0				},
		{ "",				"sequential",											},		
		
		{ "",				"parallel"												},
		{ "matthew",		"qSetVisible",				true						},
		{ "matthew",		"qWalkToXY",				31, 15						},
		{ "matthew",		"qAnimate",					"IDLE_UP", 0				},
		{ "charles",		"qWait",					300							},
		{ "charles",		"qSetVisible",				true						},
		{ "charles",		"qWalkToXY",				34, 15						},
		{ "charles",		"qAnimate",					"IDLE_UP", 0				},
		{ "",				"sequential",											},		

		{ "",				"parallel"												},
		{ "cleaner",		"qWalkToXY",				9, 19						},
		{ "cleaner",		"qAnimate",					"IDLE_UP", 0				},
		{ "",				"sequential",											},
		
		{ "",				"parallel"												},
		{ "mayor",			"qSetVisible",				true						},
		{ "mayor",			"qWalkToXY",				32, 20						},
		{ "mayor",			"qAnimate",					"IDLE_UP", 0				},
		{ "mailman",		"qWait",					300							},
		{ "mailman",		"qSetVisible",				true						},
		{ "mailman",		"qWalkToXY",				34, 20						},
		{ "mailman",		"qNotify",					"mailman y"					},
		{ "mailman",		"qAnimate",					"IDLE_COUPLE", 0			},
		{ "",				"sequential",											},		
		
		{ "emily",			"qWalkToXY",				27, 23						},
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "emily",			"qAnimate",					"LOOKAROUND", -1, 6			},
		{ "emily",			"qWait",					2000						},
		{ "emily",			"qSetAppearance",			"SAD"						},
		{ "emily",			"qAnimate",					"IDLE", 0					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_20"		},		
		{ "mailman",		"qAnimate",					"IDLE_UP", 0				},
		{ "mayor",			"qWalkToXY",				23, 23						},
		{ "mayor",			"qSetAppearance",			"HAPPY"						},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_21"		},
		{ "emily",			"qSetAppearance",			"CONFUSED"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_22"		},		
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_23"		},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_24"		},
		{ "mayor",			"qSay",						"RESTAURANT4_DAY9_25"		},
		{ "francois",		"qSetVisible",				true						},
		
		{ "",				"parallel"												},
		{ "francois",		"qWalkToXY",				24, 23						},
		{ "mayor",			"qWalkToXY",				32, 20						},
		{ "mayor",			"qAnimate",					"IDLE_UP", 0				},
		{ "",				"sequential"											},
		{ "mailman",		"qAnimate",					"IDLE_COUPLE", 0			},		
		
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_26"		},
		{ "",				"parallel"												},
		{ "francois",		"qAnimate",					"HUG", 0					},
		{ "emily",			"qSetVisible",				false						},
		{ "",				"sequential"											},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_27"		},
		{ "francois",		"qSetAppearance",			"HAPPY"						},
		{ "francois",		"qSay",						"RESTAURANT4_DAY9_28"		},
		{ "francois",		"qSay",						"RESTAURANT4_DAY9_29"		},
		{ "",				"parallel"												},
		{ "francois",		"qAnimate",					"IDLE", 0					},
		{ "emily",			"qSetVisible",				true						},
		{ "",				"sequential"											},		
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_30"		},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "francois",		"qSay",						"RESTAURANT4_DAY9_31"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_32"		},
		{ "francois",		"qSay",						"RESTAURANT4_DAY9_33"		},
		{ "francois",		"qSay",						"RESTAURANT4_DAY9_34"		},
		{ "francois",		"qSay",						"RESTAURANT4_DAY9_35"		},
		
		{ "",				"parallel",												},
		{ "francois",		"qAnimate",					"LAUGH", -1, 8				},
		{ "francois",		"qSetAppearance",			"HAPPY"						},
		{ "francois",		"qWait",					750							},
		{ "francois",		"qAnimate",					"IDLE", 0					},		
		{ "emily",			"qAnimate",					"LAUGH", -1, 8				},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qWait",					750							},
		{ "emily",			"qAnimate",					"IDLE", 0					},		
		{ "",				"sequential",											},		
		
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "emily",			"qWait",					1000						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_36"		},
		{ "francois",		"qAnimate",					"LAUGH", 0					},
		{ "francois",		"qSay",						"RESTAURANT4_DAY9_37"		},
		{ "francois",		"qAnimate",					"IDLE", 0					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_38"		},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_39"		},
		{ "emily",			"qSetAppearance",			"SAD"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_40"		},
		{ "francois",		"qSay",						"RESTAURANT4_DAY9_41"		},
		{ "emily",			"qSetAppearance",			"CONFUSED"					},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_42"		},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "francois",		"qSay",						"RESTAURANT4_DAY9_43"		},
		{ "emily",			"qSetAppearance",			"SURPRISED"					},
		{ "emily",			"qCreateOverhead",			"INGAME_THINK_ICON"			},
		{ "emily",			"qWait",					2000						},
		{ "emily",			"qRemoveOverhead"										},
		{ "emily",			"qWait",					1000						},
		{ "emily",			"qSetAppearance",			"HAPPY"						},
		{ "emily",			"qSay",						"RESTAURANT4_DAY9_44"		},
		
		{ "emily",			"qWait",					600							},
		
		{ "",				"parallel",												},
		{ "emily",			"qAnimate",					"IDLE_UP", 0				},
		{ "francois",		"qAnimate",					"IDLE_UP", 0				},
		{ "",				"sequential"											},
		
		{ "emily",			"qWait",					400							},
		
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qFinishGame" 											},	
	}

end

function day9:onDayEnd()

	if (getScore() >= level:getTargetScore()) then

		autoAllPeopleWalkOut = false

		if (not event.completed) then
			for index, value in ipairs(event.brokenObjects) do
				if (value:isVisible()) then
					emily:qWalkTo(value)
					emily:qAnimate("FIX", -1)
					emily:qWait(1000)
					emily:qNotify("hardswap" .. value.index)
	
				end
			end
		end
		
		emily:qWalkToNode(grid:getCounterNode())
		emily:qNotify("outro")
	
	end

end

function day9:onNotify(notification)

	if (notification == "hardswap1") then
		self:onHardSwap(1)	
	
	elseif (notification == "hardswap2") then
		self:onHardSwap(2)
	
	elseif (notification == "hardswap3") then
		self:onHardSwap(3)	
	
	elseif (notification == "hardswap4") then
		self:onHardSwap(4)	
	
	elseif (notification == "outro") then
		qSequence(self.sequenceOutro)
	
	elseif (notification == "mailman y") then
		self.mailman:setY(self.mailman:getY() + 1)
	
	end

end

function day9:onHardSwap(objectIndex)

	local desc = event.brokenObjects[objectIndex].desc
	
	-- remove the broken object
	event.brokenObjects[objectIndex]:setVisible(false)
	event.brokenObjects[objectIndex]:setObsolete(true)
	
	-- add the original object
	om:addObject(desc)

end

function day9:createObject(desc)

	local result = nil
	if (desc:getType() == "FireWorks") then
		result = fireworksObject()
		result:setType(desc:getType())

	end
	
	return result

end

-- a fireworks object
class 'fireworksObject' (D2Object)

function fireworksObject:__init() super()
end

function fireworksObject:onCreate()

	self:animate(self:getBaseName(), 0)

end

-- set day
day = day9()
